/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.pqc.jcajce.provider.xmss;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.pqc.asn1.XMSSKeyParams;
import com.aspose.imaging.internal.bouncycastle.pqc.asn1.XMSSPrivateKey;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.BDS;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.aspose.imaging.internal.bouncycastle.pqc.jcajce.interfaces.XMSSKey;
import com.aspose.imaging.internal.bouncycastle.pqc.jcajce.provider.xmss.a;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.PrivateKey;

public class BCXMSSPrivateKey
implements XMSSKey,
PrivateKey {
    private final XMSSPrivateKeyParameters a;
    private final ASN1ObjectIdentifier b;

    public BCXMSSPrivateKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, XMSSPrivateKeyParameters xMSSPrivateKeyParameters) {
        this.b = aSN1ObjectIdentifier;
        this.a = xMSSPrivateKeyParameters;
    }

    public BCXMSSPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        XMSSKeyParams xMSSKeyParams = XMSSKeyParams.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getParameters());
        this.b = xMSSKeyParams.getTreeDigest().getAlgorithm();
        XMSSPrivateKey xMSSPrivateKey = XMSSPrivateKey.getInstance(privateKeyInfo.parsePrivateKey());
        try {
            XMSSPrivateKeyParameters.Builder builder = new XMSSPrivateKeyParameters.Builder(new XMSSParameters(xMSSKeyParams.getHeight(), com.aspose.imaging.internal.bouncycastle.pqc.jcajce.provider.xmss.a.a(this.b))).withIndex(xMSSPrivateKey.getIndex()).withSecretKeySeed(xMSSPrivateKey.getSecretKeySeed()).withSecretKeyPRF(xMSSPrivateKey.getSecretKeyPRF()).withPublicSeed(xMSSPrivateKey.getPublicSeed()).withRoot(xMSSPrivateKey.getRoot());
            if (xMSSPrivateKey.getBdsState() != null) {
                builder.withBDSState((BDS)XMSSUtil.deserialize(xMSSPrivateKey.getBdsState()));
            }
            this.a = builder.build();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("ClassNotFoundException processing BDS state: " + classNotFoundException.getMessage());
        }
    }

    @Override
    public String getAlgorithm() {
        return "XMSS";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss, new XMSSKeyParams(this.a.getParameters().getHeight(), new AlgorithmIdentifier(this.b)));
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, this.a());
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCXMSSPrivateKey) {
            BCXMSSPrivateKey bCXMSSPrivateKey = (BCXMSSPrivateKey)object;
            return this.b.equals(bCXMSSPrivateKey.b) && Arrays.areEqual(this.a.toByteArray(), bCXMSSPrivateKey.a.toByteArray());
        }
        return false;
    }

    public int hashCode() {
        return this.b.hashCode() + 37 * Arrays.hashCode(this.a.toByteArray());
    }

    CipherParameters getKeyParams() {
        return this.a;
    }

    private XMSSPrivateKey a() {
        byte[] byArray = this.a.toByteArray();
        int n2 = this.a.getParameters().getDigestSize();
        int n3 = this.a.getParameters().getHeight();
        int n4 = 4;
        int n5 = n2;
        int n6 = n2;
        int n7 = n2;
        int n8 = n2;
        int n9 = 0;
        int n10 = (int)XMSSUtil.bytesToXBigEndian(byArray, n9, n4);
        if (!XMSSUtil.isIndexValid(n3, n10)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        byte[] byArray2 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n4, n5);
        byte[] byArray3 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n5, n6);
        byte[] byArray4 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n6, n7);
        byte[] byArray5 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n7, n8);
        byte[] byArray6 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n8, byArray.length - n9);
        return new XMSSPrivateKey(n10, byArray2, byArray3, byArray4, byArray5, byArray6);
    }

    ASN1ObjectIdentifier getTreeDigestOID() {
        return this.b;
    }

    @Override
    public int getHeight() {
        return this.a.getParameters().getHeight();
    }

    @Override
    public String getTreeDigest() {
        return com.aspose.imaging.internal.bouncycastle.pqc.jcajce.provider.xmss.a.b(this.b);
    }
}

