/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss;

import com.aspose.imaging.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.q;

public final class XMSSPublicKeyParameters
extends AsymmetricKeyParameter
implements XMSSStoreableObjectInterface {
    private final XMSSParameters a;
    private final byte[] b;
    private final byte[] c;

    private XMSSPublicKeyParameters(Builder builder) {
        super(false);
        this.a = builder.a;
        if (this.a == null) {
            throw new NullPointerException("params == null");
        }
        int n2 = this.a.getDigestSize();
        byte[] byArray = builder.d;
        if (byArray != null) {
            int n3 = n2;
            int n4 = n2;
            int n5 = n3 + n4;
            if (byArray.length != n5) {
                throw new IllegalArgumentException("public key has wrong size");
            }
            int n6 = 0;
            this.b = XMSSUtil.extractBytesAtOffset(byArray, n6, n3);
            this.c = XMSSUtil.extractBytesAtOffset(byArray, n6 += n3, n4);
        } else {
            byte[] byArray2 = builder.b;
            if (byArray2 != null) {
                if (byArray2.length != n2) {
                    throw new IllegalArgumentException("length of root must be equal to length of digest");
                }
                this.b = byArray2;
            } else {
                this.b = new byte[n2];
            }
            byte[] byArray3 = builder.c;
            if (byArray3 != null) {
                if (byArray3.length != n2) {
                    throw new IllegalArgumentException("length of publicSeed must be equal to length of digest");
                }
                this.c = byArray3;
            } else {
                this.c = new byte[n2];
            }
        }
    }

    @Override
    public byte[] toByteArray() {
        int n2;
        int n3 = n2 = this.a.getDigestSize();
        int n4 = n2;
        int n5 = n3 + n4;
        byte[] byArray = new byte[n5];
        int n6 = 0;
        XMSSUtil.copyBytesAtOffset(byArray, this.b, n6);
        XMSSUtil.copyBytesAtOffset(byArray, this.c, n6 += n3);
        return byArray;
    }

    public byte[] getRoot() {
        return XMSSUtil.cloneArray(this.b);
    }

    public byte[] getPublicSeed() {
        return XMSSUtil.cloneArray(this.c);
    }

    public XMSSParameters getParameters() {
        return this.a;
    }

    /* synthetic */ XMSSPublicKeyParameters(Builder builder, q q2) {
        this(builder);
    }

    public static class Builder {
        private final XMSSParameters a;
        private byte[] b = null;
        private byte[] c = null;
        private byte[] d = null;

        public Builder(XMSSParameters xMSSParameters) {
            this.a = xMSSParameters;
        }

        public Builder withRoot(byte[] byArray) {
            this.b = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withPublicSeed(byte[] byArray) {
            this.c = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withPublicKey(byte[] byArray) {
            this.d = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public XMSSPublicKeyParameters build() {
            return new XMSSPublicKeyParameters(this, null);
        }
    }
}

