/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.pqc.crypto.gmss;

import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.Digest;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.MessageSigner;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.gmss.GMSSDigestProvider;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.gmss.GMSSKeyParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.gmss.GMSSParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.gmss.GMSSPrivateKeyParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.gmss.GMSSPublicKeyParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.gmss.util.GMSSUtil;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSVerify;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSignature;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class GMSSSigner
implements MessageSigner {
    private GMSSUtil a = new GMSSUtil();
    private byte[] b;
    private Digest c;
    private int d;
    private int e;
    private Digest f;
    private WinternitzOTSignature g;
    private GMSSDigestProvider h;
    private int[] i;
    private byte[][][] j;
    private byte[][] k;
    private GMSSParameters l;
    private GMSSRandom m;
    GMSSKeyParameters key;
    private SecureRandom n;

    public GMSSSigner(GMSSDigestProvider gMSSDigestProvider) {
        this.h = gMSSDigestProvider;
        this.f = this.c = gMSSDigestProvider.get();
        this.d = this.c.getDigestSize();
        this.m = new GMSSRandom(this.c);
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (bl2) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.n = parametersWithRandom.getRandom();
                this.key = (GMSSPrivateKeyParameters)parametersWithRandom.getParameters();
                this.a();
            } else {
                this.n = new SecureRandom();
                this.key = (GMSSPrivateKeyParameters)cipherParameters;
                this.a();
            }
        } else {
            this.key = (GMSSPublicKeyParameters)cipherParameters;
            this.b();
        }
    }

    private void a() {
        int n2;
        this.c.reset();
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters = (GMSSPrivateKeyParameters)this.key;
        if (gMSSPrivateKeyParameters.isUsed()) {
            throw new IllegalStateException("Private key already used");
        }
        if (gMSSPrivateKeyParameters.getIndex(0) >= gMSSPrivateKeyParameters.getNumLeafs(0)) {
            throw new IllegalStateException("No more signatures can be generated");
        }
        this.l = gMSSPrivateKeyParameters.getParameters();
        this.e = this.l.getNumOfLayers();
        byte[] byArray = gMSSPrivateKeyParameters.getCurrentSeeds()[this.e - 1];
        byte[] byArray2 = new byte[this.d];
        byte[] byArray3 = new byte[this.d];
        System.arraycopy(byArray, 0, byArray3, 0, this.d);
        byArray2 = this.m.nextSeed(byArray3);
        this.g = new WinternitzOTSignature(byArray2, this.h.get(), this.l.getWinternitzParameter()[this.e - 1]);
        byte[][][] byArray4 = gMSSPrivateKeyParameters.getCurrentAuthPaths();
        this.j = new byte[this.e][][];
        for (int i2 = 0; i2 < this.e; ++i2) {
            this.j[i2] = new byte[byArray4[i2].length][this.d];
            for (n2 = 0; n2 < byArray4[i2].length; ++n2) {
                System.arraycopy(byArray4[i2][n2], 0, this.j[i2][n2], 0, this.d);
            }
        }
        this.i = new int[this.e];
        System.arraycopy(gMSSPrivateKeyParameters.getIndex(), 0, this.i, 0, this.e);
        this.k = new byte[this.e - 1][];
        for (n2 = 0; n2 < this.e - 1; ++n2) {
            byte[] byArray5 = gMSSPrivateKeyParameters.getSubtreeRootSig(n2);
            this.k[n2] = new byte[byArray5.length];
            System.arraycopy(byArray5, 0, this.k[n2], 0, byArray5.length);
        }
        gMSSPrivateKeyParameters.markUsed();
    }

    @Override
    public byte[] generateSignature(byte[] byArray) {
        byte[] byArray2 = new byte[this.d];
        byArray2 = this.g.getSignature(byArray);
        byte[] byArray3 = this.a.concatenateArray(this.j[this.e - 1]);
        byte[] byArray4 = this.a.intToBytesLittleEndian(this.i[this.e - 1]);
        byte[] byArray5 = new byte[byArray4.length + byArray2.length + byArray3.length];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
        System.arraycopy(byArray2, 0, byArray5, byArray4.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray5, byArray4.length + byArray2.length, byArray3.length);
        byte[] byArray6 = new byte[]{};
        for (int i2 = this.e - 1 - 1; i2 >= 0; --i2) {
            byArray3 = this.a.concatenateArray(this.j[i2]);
            byArray4 = this.a.intToBytesLittleEndian(this.i[i2]);
            byte[] byArray7 = new byte[byArray6.length];
            System.arraycopy(byArray6, 0, byArray7, 0, byArray6.length);
            byArray6 = new byte[byArray7.length + byArray4.length + this.k[i2].length + byArray3.length];
            System.arraycopy(byArray7, 0, byArray6, 0, byArray7.length);
            System.arraycopy(byArray4, 0, byArray6, byArray7.length, byArray4.length);
            System.arraycopy(this.k[i2], 0, byArray6, byArray7.length + byArray4.length, this.k[i2].length);
            System.arraycopy(byArray3, 0, byArray6, byArray7.length + byArray4.length + this.k[i2].length, byArray3.length);
        }
        byte[] byArray8 = new byte[byArray5.length + byArray6.length];
        System.arraycopy(byArray5, 0, byArray8, 0, byArray5.length);
        System.arraycopy(byArray6, 0, byArray8, byArray5.length, byArray6.length);
        return byArray8;
    }

    private void b() {
        this.c.reset();
        GMSSPublicKeyParameters gMSSPublicKeyParameters = (GMSSPublicKeyParameters)this.key;
        this.b = gMSSPublicKeyParameters.getPublicKey();
        this.l = gMSSPublicKeyParameters.getParameters();
        this.e = this.l.getNumOfLayers();
    }

    @Override
    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        boolean bl2 = false;
        this.f.reset();
        byte[] byArray3 = byArray;
        int n2 = 0;
        for (int i2 = this.e - 1; i2 >= 0; --i2) {
            int n3;
            WinternitzOTSVerify winternitzOTSVerify = new WinternitzOTSVerify(this.h.get(), this.l.getWinternitzParameter()[i2]);
            int n4 = winternitzOTSVerify.getSignatureLength();
            byArray = byArray3;
            int n5 = this.a.bytesToIntLittleEndian(byArray2, n2);
            byte[] byArray4 = new byte[n4];
            System.arraycopy(byArray2, n2 += 4, byArray4, 0, n4);
            n2 += n4;
            byte[] byArray5 = winternitzOTSVerify.Verify(byArray, byArray4);
            if (byArray5 == null) {
                System.err.println("OTS Public Key is null in GMSSSignature.verify");
                return false;
            }
            byte[][] byArray6 = new byte[this.l.getHeightOfTrees()[i2]][this.d];
            for (n3 = 0; n3 < byArray6.length; ++n3) {
                System.arraycopy(byArray2, n2, byArray6[n3], 0, this.d);
                n2 += this.d;
            }
            byArray3 = new byte[this.d];
            byArray3 = byArray5;
            n3 = 1 << byArray6.length;
            n3 += n5;
            for (int i3 = 0; i3 < byArray6.length; ++i3) {
                byte[] byArray7 = new byte[this.d << 1];
                if (n3 % 2 == 0) {
                    System.arraycopy(byArray3, 0, byArray7, 0, this.d);
                    System.arraycopy(byArray6[i3], 0, byArray7, this.d, this.d);
                    n3 /= 2;
                } else {
                    System.arraycopy(byArray6[i3], 0, byArray7, 0, this.d);
                    System.arraycopy(byArray3, 0, byArray7, this.d, byArray3.length);
                    n3 = (n3 - 1) / 2;
                }
                this.c.update(byArray7, 0, byArray7.length);
                byArray3 = new byte[this.c.getDigestSize()];
                this.c.doFinal(byArray3, 0);
            }
        }
        if (Arrays.areEqual(this.b, byArray3)) {
            bl2 = true;
        }
        return bl2;
    }
}

