/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.pqc.asn1;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.aspose.imaging.internal.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.aspose.imaging.internal.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import java.math.BigInteger;

public class McElieceCCA2PrivateKey
extends ASN1Object {
    private int a;
    private int b;
    private byte[] c;
    private byte[] d;
    private byte[] e;
    private AlgorithmIdentifier f;

    public McElieceCCA2PrivateKey(int n2, int n3, GF2mField gF2mField, PolynomialGF2mSmallM polynomialGF2mSmallM, Permutation permutation, AlgorithmIdentifier algorithmIdentifier) {
        this.a = n2;
        this.b = n3;
        this.c = gF2mField.getEncoded();
        this.d = polynomialGF2mSmallM.getEncoded();
        this.e = permutation.getEncoded();
        this.f = algorithmIdentifier;
    }

    private McElieceCCA2PrivateKey(ASN1Sequence aSN1Sequence) {
        BigInteger bigInteger = ((ASN1Integer)aSN1Sequence.getObjectAt(0)).getValue();
        this.a = bigInteger.intValue();
        BigInteger bigInteger2 = ((ASN1Integer)aSN1Sequence.getObjectAt(1)).getValue();
        this.b = bigInteger2.intValue();
        this.c = ((ASN1OctetString)aSN1Sequence.getObjectAt(2)).getOctets();
        this.d = ((ASN1OctetString)aSN1Sequence.getObjectAt(3)).getOctets();
        this.e = ((ASN1OctetString)aSN1Sequence.getObjectAt(4)).getOctets();
        this.f = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(5));
    }

    public int getN() {
        return this.a;
    }

    public int getK() {
        return this.b;
    }

    public GF2mField getField() {
        return new GF2mField(this.c);
    }

    public PolynomialGF2mSmallM getGoppaPoly() {
        return new PolynomialGF2mSmallM(this.getField(), this.d);
    }

    public Permutation getP() {
        return new Permutation(this.e);
    }

    public AlgorithmIdentifier getDigest() {
        return this.f;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.a));
        aSN1EncodableVector.add(new ASN1Integer(this.b));
        aSN1EncodableVector.add(new DEROctetString(this.c));
        aSN1EncodableVector.add(new DEROctetString(this.d));
        aSN1EncodableVector.add(new DEROctetString(this.e));
        aSN1EncodableVector.add(this.f);
        return new DERSequence(aSN1EncodableVector);
    }

    public static McElieceCCA2PrivateKey getInstance(Object object) {
        if (object instanceof McElieceCCA2PrivateKey) {
            return (McElieceCCA2PrivateKey)object;
        }
        if (object != null) {
            return new McElieceCCA2PrivateKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }
}

