/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.openssl.jcajce;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.DERNull;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.EncryptionScheme;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PBES2Parameters;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PBKDF2Params;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.jcajce.PKCS12KeyWithParameters;
import com.aspose.imaging.internal.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.aspose.imaging.internal.bouncycastle.jcajce.util.JcaJceHelper;
import com.aspose.imaging.internal.bouncycastle.jcajce.util.NamedJcaJceHelper;
import com.aspose.imaging.internal.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import com.aspose.imaging.internal.bouncycastle.openssl.jcajce.d;
import com.aspose.imaging.internal.bouncycastle.openssl.jcajce.h;
import com.aspose.imaging.internal.bouncycastle.operator.OperatorCreationException;
import com.aspose.imaging.internal.bouncycastle.operator.OutputEncryptor;
import java.io.IOException;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class JceOpenSSLPKCS8EncryptorBuilder {
    public static final String AES_128_CBC = NISTObjectIdentifiers.id_aes128_CBC.getId();
    public static final String AES_192_CBC = NISTObjectIdentifiers.id_aes192_CBC.getId();
    public static final String AES_256_CBC = NISTObjectIdentifiers.id_aes256_CBC.getId();
    public static final String DES3_CBC = PKCSObjectIdentifiers.des_EDE3_CBC.getId();
    public static final String PBE_SHA1_RC4_128 = PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC4.getId();
    public static final String PBE_SHA1_RC4_40 = PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC4.getId();
    public static final String PBE_SHA1_3DES = PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC.getId();
    public static final String PBE_SHA1_2DES = PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC.getId();
    public static final String PBE_SHA1_RC2_128 = PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC.getId();
    public static final String PBE_SHA1_RC2_40 = PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC.getId();
    private JcaJceHelper a = new DefaultJcaJceHelper();
    private AlgorithmParameters b;
    private ASN1ObjectIdentifier c;
    byte[] salt;
    int iterationCount;
    private Cipher d;
    private SecureRandom e;
    private AlgorithmParameterGenerator f;
    private char[] g;
    private SecretKey h;
    private AlgorithmIdentifier i = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA1, DERNull.INSTANCE);

    public JceOpenSSLPKCS8EncryptorBuilder(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.c = aSN1ObjectIdentifier;
        this.iterationCount = 2048;
    }

    public JceOpenSSLPKCS8EncryptorBuilder setRandom(SecureRandom secureRandom) {
        this.e = secureRandom;
        return this;
    }

    public JceOpenSSLPKCS8EncryptorBuilder setPasssword(char[] cArray) {
        this.g = cArray;
        return this;
    }

    public JceOpenSSLPKCS8EncryptorBuilder setPRF(AlgorithmIdentifier algorithmIdentifier) {
        this.i = algorithmIdentifier;
        return this;
    }

    public JceOpenSSLPKCS8EncryptorBuilder setIterationCount(int n2) {
        this.iterationCount = n2;
        return this;
    }

    public JceOpenSSLPKCS8EncryptorBuilder setProvider(String string) {
        this.a = new NamedJcaJceHelper(string);
        return this;
    }

    public JceOpenSSLPKCS8EncryptorBuilder setProvider(Provider provider) {
        this.a = new ProviderJcaJceHelper(provider);
        return this;
    }

    public OutputEncryptor build() throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier;
        if (this.e == null) {
            this.e = new SecureRandom();
        }
        try {
            this.d = this.a.createCipher(this.c.getId());
            if (com.aspose.imaging.internal.bouncycastle.openssl.jcajce.h.c(this.c)) {
                this.f = this.a.createAlgorithmParameterGenerator(this.c.getId());
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new OperatorCreationException(this.c + " not available: " + generalSecurityException.getMessage(), generalSecurityException);
        }
        if (com.aspose.imaging.internal.bouncycastle.openssl.jcajce.h.c(this.c)) {
            this.salt = new byte[com.aspose.imaging.internal.bouncycastle.openssl.jcajce.h.a(this.i.getAlgorithm())];
            this.e.nextBytes(this.salt);
            this.b = this.f.generateParameters();
            try {
                EncryptionScheme encryptionScheme = new EncryptionScheme(this.c, ASN1Primitive.fromByteArray(this.b.getEncoded()));
                KeyDerivationFunc keyDerivationFunc = new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, new PBKDF2Params(this.salt, this.iterationCount, this.i));
                ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                aSN1EncodableVector.add(keyDerivationFunc);
                aSN1EncodableVector.add(encryptionScheme);
                algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, PBES2Parameters.getInstance(new DERSequence(aSN1EncodableVector)));
            }
            catch (IOException iOException) {
                throw new OperatorCreationException(iOException.getMessage(), iOException);
            }
            try {
                this.h = com.aspose.imaging.internal.bouncycastle.openssl.jcajce.h.a(this.i) ? com.aspose.imaging.internal.bouncycastle.openssl.jcajce.h.a(this.a, this.c.getId(), this.g, this.salt, this.iterationCount) : com.aspose.imaging.internal.bouncycastle.openssl.jcajce.h.a(this.a, this.c.getId(), this.g, this.salt, this.iterationCount, this.i);
                this.d.init(1, (Key)this.h, this.b);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new OperatorCreationException(generalSecurityException.getMessage(), generalSecurityException);
            }
        }
        if (com.aspose.imaging.internal.bouncycastle.openssl.jcajce.h.d(this.c)) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            this.salt = new byte[20];
            this.e.nextBytes(this.salt);
            aSN1EncodableVector.add(new DEROctetString(this.salt));
            aSN1EncodableVector.add(new ASN1Integer(this.iterationCount));
            algorithmIdentifier = new AlgorithmIdentifier(this.c, PKCS12PBEParams.getInstance(new DERSequence(aSN1EncodableVector)));
            try {
                this.d.init(1, new PKCS12KeyWithParameters(this.g, this.salt, this.iterationCount));
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new OperatorCreationException(generalSecurityException.getMessage(), generalSecurityException);
            }
        } else {
            throw new OperatorCreationException("unknown algorithm: " + this.c, null);
        }
        return new d(this, algorithmIdentifier);
    }

    static /* synthetic */ Cipher access$000(JceOpenSSLPKCS8EncryptorBuilder jceOpenSSLPKCS8EncryptorBuilder) {
        return jceOpenSSLPKCS8EncryptorBuilder.d;
    }

    static /* synthetic */ SecretKey access$100(JceOpenSSLPKCS8EncryptorBuilder jceOpenSSLPKCS8EncryptorBuilder) {
        return jceOpenSSLPKCS8EncryptorBuilder.h;
    }
}

