/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.openssl;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERNull;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.ContentInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.RSAPrivateKey;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.RSAPublicKey;
import com.aspose.imaging.internal.bouncycastle.asn1.sec.ECPrivateKey;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.DSAParameter;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X9ECParameters;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.cert.X509AttributeCertificateHolder;
import com.aspose.imaging.internal.bouncycastle.cert.X509CRLHolder;
import com.aspose.imaging.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.imaging.internal.bouncycastle.openssl.PEMEncryptedKeyPair;
import com.aspose.imaging.internal.bouncycastle.openssl.PEMException;
import com.aspose.imaging.internal.bouncycastle.openssl.PEMKeyPair;
import com.aspose.imaging.internal.bouncycastle.openssl.X509TrustedCertificateBlock;
import com.aspose.imaging.internal.bouncycastle.pkcs.PKCS10CertificationRequest;
import com.aspose.imaging.internal.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import com.aspose.imaging.internal.bouncycastle.util.encoders.Hex;
import com.aspose.imaging.internal.bouncycastle.util.io.pem.PemHeader;
import com.aspose.imaging.internal.bouncycastle.util.io.pem.PemObject;
import com.aspose.imaging.internal.bouncycastle.util.io.pem.PemObjectParser;
import com.aspose.imaging.internal.bouncycastle.util.io.pem.PemReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class PEMParser
extends PemReader {
    private final Map a = new HashMap();

    public PEMParser(Reader reader) {
        super(reader);
        this.a.put("CERTIFICATE REQUEST", new f(null));
        this.a.put("NEW CERTIFICATE REQUEST", new f(null));
        this.a.put("CERTIFICATE", new n(null));
        this.a.put("TRUSTED CERTIFICATE", new o(null));
        this.a.put("X509 CERTIFICATE", new n(null));
        this.a.put("X509 CRL", new m(null));
        this.a.put("PKCS7", new g(null));
        this.a.put("CMS", new g(null));
        this.a.put("ATTRIBUTE CERTIFICATE", new l(null));
        this.a.put("EC PARAMETERS", new b(null));
        this.a.put("PUBLIC KEY", new i());
        this.a.put("RSA PUBLIC KEY", new k());
        this.a.put("RSA PRIVATE KEY", new e(new j(null)));
        this.a.put("DSA PRIVATE KEY", new e(new a(null)));
        this.a.put("EC PRIVATE KEY", new e(new c(null)));
        this.a.put("ENCRYPTED PRIVATE KEY", new d());
        this.a.put("PRIVATE KEY", new h());
    }

    public Object readObject() throws IOException {
        PemObject pemObject = this.readPemObject();
        if (pemObject != null) {
            String string = pemObject.getType();
            if (this.a.containsKey(string)) {
                return ((PemObjectParser)this.a.get(string)).parseObject(pemObject);
            }
            throw new IOException("unrecognised object: " + string);
        }
        return null;
    }

    private class a
    implements com.aspose.imaging.internal.bouncycastle.openssl.a {
        private a() {
        }

        @Override
        public PEMKeyPair a(byte[] byArray) throws IOException {
            try {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(byArray);
                if (aSN1Sequence.size() != 6) {
                    throw new PEMException("malformed sequence in DSA private key");
                }
                ASN1Integer aSN1Integer = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1));
                ASN1Integer aSN1Integer2 = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(2));
                ASN1Integer aSN1Integer3 = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(3));
                ASN1Integer aSN1Integer4 = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(4));
                ASN1Integer aSN1Integer5 = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(5));
                return new PEMKeyPair(new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, new DSAParameter(aSN1Integer.getValue(), aSN1Integer2.getValue(), aSN1Integer3.getValue())), aSN1Integer4), new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, new DSAParameter(aSN1Integer.getValue(), aSN1Integer2.getValue(), aSN1Integer3.getValue())), aSN1Integer5));
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new PEMException("problem creating DSA private key: " + exception.toString(), exception);
            }
        }

        /* synthetic */ a(com.aspose.imaging.internal.bouncycastle.openssl.b b2) {
            this();
        }
    }

    private class b
    implements PemObjectParser {
        private b() {
        }

        @Override
        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray(pemObject.getContent());
                if (aSN1Primitive instanceof ASN1ObjectIdentifier) {
                    return ASN1Primitive.fromByteArray(pemObject.getContent());
                }
                if (aSN1Primitive instanceof ASN1Sequence) {
                    return X9ECParameters.getInstance(aSN1Primitive);
                }
                return null;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new PEMException("exception extracting EC named curve: " + exception.toString());
            }
        }

        /* synthetic */ b(com.aspose.imaging.internal.bouncycastle.openssl.b b2) {
            this();
        }
    }

    private class c
    implements com.aspose.imaging.internal.bouncycastle.openssl.a {
        private c() {
        }

        @Override
        public PEMKeyPair a(byte[] byArray) throws IOException {
            try {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(byArray);
                ECPrivateKey eCPrivateKey = ECPrivateKey.getInstance(aSN1Sequence);
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, eCPrivateKey.getParameters());
                PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, eCPrivateKey);
                SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, eCPrivateKey.getPublicKey().getBytes());
                return new PEMKeyPair(subjectPublicKeyInfo, privateKeyInfo);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new PEMException("problem creating EC private key: " + exception.toString(), exception);
            }
        }

        /* synthetic */ c(com.aspose.imaging.internal.bouncycastle.openssl.b b2) {
            this();
        }
    }

    private class d
    implements PemObjectParser {
        @Override
        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                return new PKCS8EncryptedPrivateKeyInfo(EncryptedPrivateKeyInfo.getInstance(pemObject.getContent()));
            }
            catch (Exception exception) {
                throw new PEMException("problem parsing ENCRYPTED PRIVATE KEY: " + exception.toString(), exception);
            }
        }
    }

    private class e
    implements PemObjectParser {
        private final com.aspose.imaging.internal.bouncycastle.openssl.a b;

        public e(com.aspose.imaging.internal.bouncycastle.openssl.a a2) {
            this.b = a2;
        }

        @Override
        public Object parseObject(PemObject pemObject) throws IOException {
            boolean bl2 = false;
            String string = null;
            List list = pemObject.getHeaders();
            for (Object object2 : list) {
                if (((PemHeader)object2).getName().equals("Proc-Type") && ((PemHeader)object2).getValue().equals("4,ENCRYPTED")) {
                    bl2 = true;
                    continue;
                }
                if (!((PemHeader)object2).getName().equals("DEK-Info")) continue;
                string = ((PemHeader)object2).getValue();
            }
            Object object = pemObject.getContent();
            try {
                if (bl2) {
                    Object object2;
                    object2 = new StringTokenizer(string, ",");
                    String string2 = ((StringTokenizer)object2).nextToken();
                    byte[] byArray = Hex.decode(((StringTokenizer)object2).nextToken());
                    return new PEMEncryptedKeyPair(string2, byArray, (byte[])object, this.b);
                }
                return this.b.a((byte[])object);
            }
            catch (IOException iOException) {
                if (bl2) {
                    throw new PEMException("exception decoding - please check password and data.", iOException);
                }
                throw new PEMException(iOException.getMessage(), iOException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (bl2) {
                    throw new PEMException("exception decoding - please check password and data.", illegalArgumentException);
                }
                throw new PEMException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }
    }

    private class f
    implements PemObjectParser {
        private f() {
        }

        @Override
        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                return new PKCS10CertificationRequest(pemObject.getContent());
            }
            catch (Exception exception) {
                throw new PEMException("problem parsing certrequest: " + exception.toString(), exception);
            }
        }

        /* synthetic */ f(com.aspose.imaging.internal.bouncycastle.openssl.b b2) {
            this();
        }
    }

    private class g
    implements PemObjectParser {
        private g() {
        }

        @Override
        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                ASN1InputStream aSN1InputStream = new ASN1InputStream(pemObject.getContent());
                return ContentInfo.getInstance(aSN1InputStream.readObject());
            }
            catch (Exception exception) {
                throw new PEMException("problem parsing PKCS7 object: " + exception.toString(), exception);
            }
        }

        /* synthetic */ g(com.aspose.imaging.internal.bouncycastle.openssl.b b2) {
            this();
        }
    }

    private class h
    implements PemObjectParser {
        @Override
        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                return PrivateKeyInfo.getInstance(pemObject.getContent());
            }
            catch (Exception exception) {
                throw new PEMException("problem parsing PRIVATE KEY: " + exception.toString(), exception);
            }
        }
    }

    private class i
    implements PemObjectParser {
        @Override
        public Object parseObject(PemObject pemObject) throws IOException {
            return SubjectPublicKeyInfo.getInstance(pemObject.getContent());
        }
    }

    private class j
    implements com.aspose.imaging.internal.bouncycastle.openssl.a {
        private j() {
        }

        @Override
        public PEMKeyPair a(byte[] byArray) throws IOException {
            try {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(byArray);
                if (aSN1Sequence.size() != 9) {
                    throw new PEMException("malformed sequence in RSA private key");
                }
                RSAPrivateKey rSAPrivateKey = RSAPrivateKey.getInstance(aSN1Sequence);
                RSAPublicKey rSAPublicKey = new RSAPublicKey(rSAPrivateKey.getModulus(), rSAPrivateKey.getPublicExponent());
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE);
                return new PEMKeyPair(new SubjectPublicKeyInfo(algorithmIdentifier, rSAPublicKey), new PrivateKeyInfo(algorithmIdentifier, rSAPrivateKey));
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new PEMException("problem creating RSA private key: " + exception.toString(), exception);
            }
        }

        /* synthetic */ j(com.aspose.imaging.internal.bouncycastle.openssl.b b2) {
            this();
        }
    }

    private class k
    implements PemObjectParser {
        @Override
        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                RSAPublicKey rSAPublicKey = RSAPublicKey.getInstance(pemObject.getContent());
                return new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), rSAPublicKey);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new PEMException("problem extracting key: " + exception.toString(), exception);
            }
        }
    }

    private class l
    implements PemObjectParser {
        private l() {
        }

        @Override
        public Object parseObject(PemObject pemObject) throws IOException {
            return new X509AttributeCertificateHolder(pemObject.getContent());
        }

        /* synthetic */ l(com.aspose.imaging.internal.bouncycastle.openssl.b b2) {
            this();
        }
    }

    private class m
    implements PemObjectParser {
        private m() {
        }

        @Override
        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                return new X509CRLHolder(pemObject.getContent());
            }
            catch (Exception exception) {
                throw new PEMException("problem parsing cert: " + exception.toString(), exception);
            }
        }

        /* synthetic */ m(com.aspose.imaging.internal.bouncycastle.openssl.b b2) {
            this();
        }
    }

    private class n
    implements PemObjectParser {
        private n() {
        }

        @Override
        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                return new X509CertificateHolder(pemObject.getContent());
            }
            catch (Exception exception) {
                throw new PEMException("problem parsing cert: " + exception.toString(), exception);
            }
        }

        /* synthetic */ n(com.aspose.imaging.internal.bouncycastle.openssl.b b2) {
            this();
        }
    }

    private class o
    implements PemObjectParser {
        private o() {
        }

        @Override
        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                return new X509TrustedCertificateBlock(pemObject.getContent());
            }
            catch (Exception exception) {
                throw new PEMException("problem parsing cert: " + exception.toString(), exception);
            }
        }

        /* synthetic */ o(com.aspose.imaging.internal.bouncycastle.openssl.b b2) {
            this();
        }
    }
}

