/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.jce.provider;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1BitString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERBitString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERNull;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import com.aspose.imaging.internal.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X962Parameters;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X9ECParameters;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X9ECPoint;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X9IntegerConverter;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import com.aspose.imaging.internal.bouncycastle.jce.ECGOST3410NamedCurveTable;
import com.aspose.imaging.internal.bouncycastle.jce.interfaces.ECPointEncoder;
import com.aspose.imaging.internal.bouncycastle.jce.provider.BouncyCastleProvider;
import com.aspose.imaging.internal.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import com.aspose.imaging.internal.bouncycastle.jce.spec.ECNamedCurveSpec;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.imaging.internal.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;

public class JCEECPublicKey
implements ECPointEncoder,
com.aspose.imaging.internal.bouncycastle.jce.interfaces.ECPublicKey,
ECPublicKey {
    private String a = "EC";
    private com.aspose.imaging.internal.bouncycastle.math.ec.ECPoint b;
    private ECParameterSpec c;
    private boolean d;
    private GOST3410PublicKeyAlgParameters e;

    public JCEECPublicKey(String string, JCEECPublicKey jCEECPublicKey) {
        this.a = string;
        this.b = jCEECPublicKey.b;
        this.c = jCEECPublicKey.c;
        this.d = jCEECPublicKey.d;
        this.e = jCEECPublicKey.e;
    }

    public JCEECPublicKey(String string, ECPublicKeySpec eCPublicKeySpec) {
        this.a = string;
        this.c = eCPublicKeySpec.getParams();
        this.b = EC5Util.convertPoint(this.c, eCPublicKeySpec.getW(), false);
    }

    public JCEECPublicKey(String string, com.aspose.imaging.internal.bouncycastle.jce.spec.ECPublicKeySpec eCPublicKeySpec) {
        this.a = string;
        this.b = eCPublicKeySpec.getQ();
        if (eCPublicKeySpec.getParams() != null) {
            ECCurve eCCurve = eCPublicKeySpec.getParams().getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, eCPublicKeySpec.getParams().getSeed());
            this.c = EC5Util.convertSpec(ellipticCurve, eCPublicKeySpec.getParams());
        } else {
            if (this.b.getCurve() == null) {
                com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
                this.b = eCParameterSpec.getCurve().createPoint(this.b.getAffineXCoord().toBigInteger(), this.b.getAffineYCoord().toBigInteger(), false);
            }
            this.c = null;
        }
    }

    public JCEECPublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.a = string;
        this.b = eCPublicKeyParameters.getQ();
        if (eCParameterSpec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCDomainParameters.getCurve(), eCDomainParameters.getSeed());
            this.c = this.a(ellipticCurve, eCDomainParameters);
        } else {
            this.c = eCParameterSpec;
        }
    }

    public JCEECPublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.a = string;
        this.b = eCPublicKeyParameters.getQ();
        if (eCParameterSpec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCDomainParameters.getCurve(), eCDomainParameters.getSeed());
            this.c = this.a(ellipticCurve, eCDomainParameters);
        } else {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getSeed());
            this.c = EC5Util.convertSpec(ellipticCurve, eCParameterSpec);
        }
    }

    public JCEECPublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters) {
        this.a = string;
        this.b = eCPublicKeyParameters.getQ();
        this.c = null;
    }

    private ECParameterSpec a(EllipticCurve ellipticCurve, ECDomainParameters eCDomainParameters) {
        return new ECParameterSpec(ellipticCurve, EC5Util.convertPoint(eCDomainParameters.getG()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
    }

    public JCEECPublicKey(ECPublicKey eCPublicKey) {
        this.a = eCPublicKey.getAlgorithm();
        this.c = eCPublicKey.getParams();
        this.b = EC5Util.convertPoint(this.c, eCPublicKey.getW(), false);
    }

    JCEECPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.a(subjectPublicKeyInfo);
    }

    private void a(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        if (subjectPublicKeyInfo.getAlgorithmId().getAlgorithm().equals(CryptoProObjectIdentifiers.gostR3410_2001)) {
            ASN1OctetString aSN1OctetString;
            DERBitString dERBitString = subjectPublicKeyInfo.getPublicKeyData();
            this.a = "ECGOST3410";
            try {
                aSN1OctetString = (ASN1OctetString)ASN1Primitive.fromByteArray(dERBitString.getBytes());
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error recovering public key");
            }
            byte[] byArray = aSN1OctetString.getOctets();
            byte[] byArray2 = new byte[65];
            byArray2[0] = 4;
            for (int i2 = 1; i2 <= 32; ++i2) {
                byArray2[i2] = byArray[32 - i2];
                byArray2[i2 + 32] = byArray[64 - i2];
            }
            this.e = new GOST3410PublicKeyAlgParameters((ASN1Sequence)subjectPublicKeyInfo.getAlgorithmId().getParameters());
            ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECGOST3410NamedCurveTable.getParameterSpec(ECGOST3410NamedCurves.getName(this.e.getPublicKeyParamSet()));
            ECCurve eCCurve = eCNamedCurveParameterSpec.getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, eCNamedCurveParameterSpec.getSeed());
            this.b = eCCurve.decodePoint(byArray2);
            this.c = new ECNamedCurveSpec(ECGOST3410NamedCurves.getName(this.e.getPublicKeyParamSet()), ellipticCurve, EC5Util.convertPoint(eCNamedCurveParameterSpec.getG()), eCNamedCurveParameterSpec.getN(), eCNamedCurveParameterSpec.getH());
        } else {
            int n2;
            ECCurve eCCurve;
            Object object;
            ASN1Object aSN1Object;
            X962Parameters x962Parameters = new X962Parameters((ASN1Primitive)subjectPublicKeyInfo.getAlgorithmId().getParameters());
            if (x962Parameters.isNamedCurve()) {
                aSN1Object = (ASN1ObjectIdentifier)x962Parameters.getParameters();
                object = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)aSN1Object);
                eCCurve = ((X9ECParameters)object).getCurve();
                EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, ((X9ECParameters)object).getSeed());
                this.c = new ECNamedCurveSpec(ECUtil.getCurveName((ASN1ObjectIdentifier)aSN1Object), ellipticCurve, EC5Util.convertPoint(((X9ECParameters)object).getG()), ((X9ECParameters)object).getN(), ((X9ECParameters)object).getH());
            } else if (x962Parameters.isImplicitlyCA()) {
                this.c = null;
                eCCurve = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa().getCurve();
            } else {
                aSN1Object = X9ECParameters.getInstance(x962Parameters.getParameters());
                eCCurve = ((X9ECParameters)aSN1Object).getCurve();
                EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, ((X9ECParameters)aSN1Object).getSeed());
                this.c = new ECParameterSpec(ellipticCurve, EC5Util.convertPoint(((X9ECParameters)aSN1Object).getG()), ((X9ECParameters)aSN1Object).getN(), ((X9ECParameters)aSN1Object).getH().intValue());
            }
            aSN1Object = subjectPublicKeyInfo.getPublicKeyData();
            object = ((ASN1BitString)aSN1Object).getBytes();
            ASN1OctetString aSN1OctetString = new DEROctetString((byte[])object);
            if (object[0] == 4 && object[1] == ((Object)object).length - 2 && (object[2] == 2 || object[2] == 3) && (n2 = new X9IntegerConverter().getByteLength(eCCurve)) >= ((Object)object).length - 3) {
                try {
                    aSN1OctetString = (ASN1OctetString)ASN1Primitive.fromByteArray((byte[])object);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("error recovering public key");
                }
            }
            X9ECPoint x9ECPoint = new X9ECPoint(eCCurve, aSN1OctetString);
            this.b = x9ECPoint.getPoint();
        }
    }

    @Override
    public String getAlgorithm() {
        return this.a;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        if (this.a.equals("ECGOST3410")) {
            Object object;
            Object object2;
            ASN1Object aSN1Object;
            if (this.e != null) {
                aSN1Object = this.e;
            } else if (this.c instanceof ECNamedCurveSpec) {
                aSN1Object = new GOST3410PublicKeyAlgParameters(ECGOST3410NamedCurves.getOID(((ECNamedCurveSpec)this.c).getName()), CryptoProObjectIdentifiers.gostR3411_94_CryptoProParamSet);
            } else {
                object2 = EC5Util.convertCurve(this.c.getCurve());
                object = new X9ECParameters((ECCurve)object2, EC5Util.convertPoint((ECCurve)object2, this.c.getGenerator(), this.d), this.c.getOrder(), BigInteger.valueOf(this.c.getCofactor()), this.c.getCurve().getSeed());
                aSN1Object = new X962Parameters((X9ECParameters)object);
            }
            object2 = this.b.getAffineXCoord().toBigInteger();
            object = this.b.getAffineYCoord().toBigInteger();
            byte[] byArray = new byte[64];
            this.a(byArray, 0, (BigInteger)object2);
            this.a(byArray, 32, (BigInteger)object);
            try {
                subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, aSN1Object), new DEROctetString(byArray));
            }
            catch (IOException iOException) {
                return null;
            }
        } else {
            ASN1Object aSN1Object;
            X962Parameters x962Parameters;
            Object object;
            if (this.c instanceof ECNamedCurveSpec) {
                object = ECUtil.getNamedCurveOid(((ECNamedCurveSpec)this.c).getName());
                if (object == null) {
                    object = new ASN1ObjectIdentifier(((ECNamedCurveSpec)this.c).getName());
                }
                x962Parameters = new X962Parameters((ASN1ObjectIdentifier)object);
            } else if (this.c == null) {
                x962Parameters = new X962Parameters(DERNull.INSTANCE);
            } else {
                object = EC5Util.convertCurve(this.c.getCurve());
                aSN1Object = new X9ECParameters((ECCurve)object, EC5Util.convertPoint((ECCurve)object, this.c.getGenerator(), this.d), this.c.getOrder(), BigInteger.valueOf(this.c.getCofactor()), this.c.getCurve().getSeed());
                x962Parameters = new X962Parameters((X9ECParameters)aSN1Object);
            }
            object = this.engineGetQ().getCurve();
            aSN1Object = (ASN1OctetString)new X9ECPoint(((ECCurve)object).createPoint(this.getQ().getAffineXCoord().toBigInteger(), this.getQ().getAffineYCoord().toBigInteger(), this.d)).toASN1Primitive();
            subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), ((ASN1OctetString)aSN1Object).getOctets());
        }
        return KeyUtil.getEncodedSubjectPublicKeyInfo(subjectPublicKeyInfo);
    }

    private void a(byte[] byArray, int n2, BigInteger bigInteger) {
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2.length < 32) {
            byte[] byArray3 = new byte[32];
            System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
            byArray2 = byArray3;
        }
        for (int i2 = 0; i2 != 32; ++i2) {
            byArray[n2 + i2] = byArray2[byArray2.length - 1 - i2];
        }
    }

    @Override
    public ECParameterSpec getParams() {
        return this.c;
    }

    @Override
    public com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec getParameters() {
        if (this.c == null) {
            return null;
        }
        return EC5Util.convertSpec(this.c, this.d);
    }

    @Override
    public ECPoint getW() {
        return EC5Util.convertPoint(this.b);
    }

    @Override
    public com.aspose.imaging.internal.bouncycastle.math.ec.ECPoint getQ() {
        if (this.c == null) {
            return this.b.getDetachedPoint();
        }
        return this.b;
    }

    public com.aspose.imaging.internal.bouncycastle.math.ec.ECPoint engineGetQ() {
        return this.b;
    }

    com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec engineGetSpec() {
        if (this.c != null) {
            return EC5Util.convertSpec(this.c, this.d);
        }
        return BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Strings.lineSeparator();
        stringBuffer.append("EC Public Key").append(string);
        stringBuffer.append("            X: ").append(this.b.getAffineXCoord().toBigInteger().toString(16)).append(string);
        stringBuffer.append("            Y: ").append(this.b.getAffineYCoord().toBigInteger().toString(16)).append(string);
        return stringBuffer.toString();
    }

    @Override
    public void setPointFormat(String string) {
        this.d = !"UNCOMPRESSED".equalsIgnoreCase(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof JCEECPublicKey)) {
            return false;
        }
        JCEECPublicKey jCEECPublicKey = (JCEECPublicKey)object;
        return this.engineGetQ().equals(jCEECPublicKey.engineGetQ()) && this.engineGetSpec().equals(jCEECPublicKey.engineGetSpec());
    }

    public int hashCode() {
        return this.engineGetQ().hashCode() ^ this.engineGetSpec().hashCode();
    }

    private void a(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.a(SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray)));
        this.a = (String)objectInputStream.readObject();
        this.d = objectInputStream.readBoolean();
    }

    private void a(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.getEncoded());
        objectOutputStream.writeObject(this.a);
        objectOutputStream.writeBoolean(this.d);
    }
}

