/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric;

import com.aspose.imaging.internal.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.crypto.CipherKeyGenerator;
import com.aspose.imaging.internal.bouncycastle.crypto.engines.SEEDEngine;
import com.aspose.imaging.internal.bouncycastle.crypto.engines.SEEDWrapEngine;
import com.aspose.imaging.internal.bouncycastle.crypto.generators.Poly1305KeyGenerator;
import com.aspose.imaging.internal.bouncycastle.crypto.macs.CMac;
import com.aspose.imaging.internal.bouncycastle.crypto.macs.GMac;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.CBCBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.GCMBlockCipher;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.k;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.p;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.util.BaseWrapCipher;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public final class SEED {
    private SEED() {
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        @Override
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for SEED parameter generation.");
        }

        @Override
        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters algorithmParameters;
            byte[] byArray = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(byArray);
            try {
                algorithmParameters = this.createParametersInstance("SEED");
                algorithmParameters.init(new IvParameterSpec(byArray));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            return algorithmParameters;
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "SEED IV";
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new SEEDEngine()), 128);
        }
    }

    public static class CMAC
    extends BaseMac {
        public CMAC() {
            super(new CMac(new SEEDEngine()));
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new k());
        }
    }

    public static class GMAC
    extends BaseMac {
        public GMAC() {
            super(new GMac(new GCMBlockCipher(new SEEDEngine())));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("SEED", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends p {
        private static final String a = SEED.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("AlgorithmParameters.SEED", a + "$AlgParams");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters." + KISAObjectIdentifiers.id_seedCBC, "SEED");
            configurableProvider.addAlgorithm("AlgorithmParameterGenerator.SEED", a + "$AlgParamGen");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator." + KISAObjectIdentifiers.id_seedCBC, "SEED");
            configurableProvider.addAlgorithm("Cipher.SEED", a + "$ECB");
            configurableProvider.addAlgorithm("Cipher", KISAObjectIdentifiers.id_seedCBC, a + "$CBC");
            configurableProvider.addAlgorithm("Cipher.SEEDWRAP", a + "$Wrap");
            configurableProvider.addAlgorithm("Alg.Alias.Cipher", KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap, "SEEDWRAP");
            configurableProvider.addAlgorithm("Alg.Alias.Cipher.SEEDKW", "SEEDWRAP");
            configurableProvider.addAlgorithm("KeyGenerator.SEED", a + "$KeyGen");
            configurableProvider.addAlgorithm("KeyGenerator", KISAObjectIdentifiers.id_seedCBC, a + "$KeyGen");
            configurableProvider.addAlgorithm("KeyGenerator", KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap, a + "$KeyGen");
            this.addCMacAlgorithm(configurableProvider, "SEED", a + "$CMAC", a + "$KeyGen");
            this.addGMacAlgorithm(configurableProvider, "SEED", a + "$GMAC", a + "$KeyGen");
            this.addPoly1305Algorithm(configurableProvider, "SEED", a + "$Poly1305", a + "$Poly1305KeyGen");
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new com.aspose.imaging.internal.bouncycastle.crypto.macs.Poly1305(new SEEDEngine()));
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-SEED", 256, new Poly1305KeyGenerator());
        }
    }

    public static class Wrap
    extends BaseWrapCipher {
        public Wrap() {
            super(new SEEDWrapEngine());
        }
    }
}

