/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.ecgost;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.DERBitString;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import com.aspose.imaging.internal.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X962Parameters;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X9ECParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import com.aspose.imaging.internal.bouncycastle.jce.ECGOST3410NamedCurveTable;
import com.aspose.imaging.internal.bouncycastle.jce.interfaces.ECPointEncoder;
import com.aspose.imaging.internal.bouncycastle.jce.interfaces.ECPublicKey;
import com.aspose.imaging.internal.bouncycastle.jce.provider.BouncyCastleProvider;
import com.aspose.imaging.internal.bouncycastle.jce.spec.ECNamedCurveSpec;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECCurve;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;

public class BCECGOST3410PublicKey
implements ECPointEncoder,
ECPublicKey,
java.security.interfaces.ECPublicKey {
    static final long serialVersionUID = 7026240464295649314L;
    private String a = "ECGOST3410";
    private boolean b;
    private transient ECPublicKeyParameters c;
    private transient ECParameterSpec d;
    private transient ASN1Encodable e;

    public BCECGOST3410PublicKey(BCECGOST3410PublicKey bCECGOST3410PublicKey) {
        this.c = bCECGOST3410PublicKey.c;
        this.d = bCECGOST3410PublicKey.d;
        this.b = bCECGOST3410PublicKey.b;
        this.e = bCECGOST3410PublicKey.e;
    }

    public BCECGOST3410PublicKey(ECPublicKeySpec eCPublicKeySpec) {
        this.d = eCPublicKeySpec.getParams();
        this.c = new ECPublicKeyParameters(EC5Util.convertPoint(this.d, eCPublicKeySpec.getW(), false), EC5Util.getDomainParameters(null, eCPublicKeySpec.getParams()));
    }

    public BCECGOST3410PublicKey(com.aspose.imaging.internal.bouncycastle.jce.spec.ECPublicKeySpec eCPublicKeySpec, ProviderConfiguration providerConfiguration) {
        if (eCPublicKeySpec.getParams() != null) {
            ECCurve eCCurve = eCPublicKeySpec.getParams().getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, eCPublicKeySpec.getParams().getSeed());
            this.c = new ECPublicKeyParameters(eCPublicKeySpec.getQ(), ECUtil.getDomainParameters(providerConfiguration, eCPublicKeySpec.getParams()));
            this.d = EC5Util.convertSpec(ellipticCurve, eCPublicKeySpec.getParams());
        } else {
            com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = providerConfiguration.getEcImplicitlyCa();
            this.c = new ECPublicKeyParameters(eCParameterSpec.getCurve().createPoint(eCPublicKeySpec.getQ().getAffineXCoord().toBigInteger(), eCPublicKeySpec.getQ().getAffineYCoord().toBigInteger()), EC5Util.getDomainParameters(providerConfiguration, null));
            this.d = null;
        }
    }

    public BCECGOST3410PublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.a = string;
        this.c = eCPublicKeyParameters;
        if (eCParameterSpec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCDomainParameters.getCurve(), eCDomainParameters.getSeed());
            this.d = this.a(ellipticCurve, eCDomainParameters);
        } else {
            this.d = eCParameterSpec;
        }
    }

    public BCECGOST3410PublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.a = string;
        this.c = eCPublicKeyParameters;
        if (eCParameterSpec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCDomainParameters.getCurve(), eCDomainParameters.getSeed());
            this.d = this.a(ellipticCurve, eCDomainParameters);
        } else {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getSeed());
            this.d = EC5Util.convertSpec(ellipticCurve, eCParameterSpec);
        }
    }

    public BCECGOST3410PublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters) {
        this.a = string;
        this.c = eCPublicKeyParameters;
        this.d = null;
    }

    private ECParameterSpec a(EllipticCurve ellipticCurve, ECDomainParameters eCDomainParameters) {
        return new ECParameterSpec(ellipticCurve, EC5Util.convertPoint(eCDomainParameters.getG()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
    }

    public BCECGOST3410PublicKey(java.security.interfaces.ECPublicKey eCPublicKey) {
        this.a = eCPublicKey.getAlgorithm();
        this.d = eCPublicKey.getParams();
        this.c = new ECPublicKeyParameters(EC5Util.convertPoint(this.d, eCPublicKey.getW(), false), EC5Util.getDomainParameters(null, eCPublicKey.getParams()));
    }

    BCECGOST3410PublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.a(subjectPublicKeyInfo);
    }

    private void a(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        Object object;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        ASN1OctetString aSN1OctetString;
        DERBitString dERBitString = subjectPublicKeyInfo.getPublicKeyData();
        this.a = "ECGOST3410";
        try {
            aSN1OctetString = (ASN1OctetString)ASN1Primitive.fromByteArray(dERBitString.getBytes());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("error recovering public key");
        }
        byte[] byArray = aSN1OctetString.getOctets();
        byte[] byArray2 = new byte[65];
        byArray2[0] = 4;
        for (int i2 = 1; i2 <= 32; ++i2) {
            byArray2[i2] = byArray[32 - i2];
            byArray2[i2 + 32] = byArray[64 - i2];
        }
        if (subjectPublicKeyInfo.getAlgorithm().getParameters() instanceof ASN1ObjectIdentifier) {
            aSN1ObjectIdentifier = ASN1ObjectIdentifier.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
            this.e = aSN1ObjectIdentifier;
        } else {
            object = GOST3410PublicKeyAlgParameters.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
            this.e = object;
            aSN1ObjectIdentifier = ((GOST3410PublicKeyAlgParameters)object).getPublicKeyParamSet();
        }
        object = ECGOST3410NamedCurveTable.getParameterSpec(ECGOST3410NamedCurves.getName(aSN1ObjectIdentifier));
        ECCurve eCCurve = ((com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec)object).getCurve();
        EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, ((com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec)object).getSeed());
        this.c = new ECPublicKeyParameters(eCCurve.decodePoint(byArray2), ECUtil.getDomainParameters(null, (com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec)object));
        this.d = new ECNamedCurveSpec(ECGOST3410NamedCurves.getName(aSN1ObjectIdentifier), ellipticCurve, EC5Util.convertPoint(((com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec)object).getG()), ((com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec)object).getN(), ((com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec)object).getH());
    }

    @Override
    public String getAlgorithm() {
        return this.a;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        Object object;
        Object object2;
        ASN1Encodable aSN1Encodable = this.getGostParams();
        if (aSN1Encodable == null) {
            if (this.d instanceof ECNamedCurveSpec) {
                aSN1Encodable = new GOST3410PublicKeyAlgParameters(ECGOST3410NamedCurves.getOID(((ECNamedCurveSpec)this.d).getName()), CryptoProObjectIdentifiers.gostR3411_94_CryptoProParamSet);
            } else {
                object2 = EC5Util.convertCurve(this.d.getCurve());
                object = new X9ECParameters((ECCurve)object2, EC5Util.convertPoint((ECCurve)object2, this.d.getGenerator(), this.b), this.d.getOrder(), BigInteger.valueOf(this.d.getCofactor()), this.d.getCurve().getSeed());
                aSN1Encodable = new X962Parameters((X9ECParameters)object);
            }
        }
        object2 = this.c.getQ().getAffineXCoord().toBigInteger();
        object = this.c.getQ().getAffineYCoord().toBigInteger();
        byte[] byArray = new byte[64];
        this.a(byArray, 0, (BigInteger)object2);
        this.a(byArray, 32, (BigInteger)object);
        try {
            subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, aSN1Encodable), new DEROctetString(byArray));
        }
        catch (IOException iOException) {
            return null;
        }
        return KeyUtil.getEncodedSubjectPublicKeyInfo(subjectPublicKeyInfo);
    }

    private void a(byte[] byArray, int n2, BigInteger bigInteger) {
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2.length < 32) {
            byte[] byArray3 = new byte[32];
            System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
            byArray2 = byArray3;
        }
        for (int i2 = 0; i2 != 32; ++i2) {
            byArray[n2 + i2] = byArray2[byArray2.length - 1 - i2];
        }
    }

    @Override
    public ECParameterSpec getParams() {
        return this.d;
    }

    @Override
    public com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec getParameters() {
        if (this.d == null) {
            return null;
        }
        return EC5Util.convertSpec(this.d, this.b);
    }

    @Override
    public ECPoint getW() {
        return EC5Util.convertPoint(this.c.getQ());
    }

    @Override
    public com.aspose.imaging.internal.bouncycastle.math.ec.ECPoint getQ() {
        if (this.d == null) {
            return this.c.getQ().getDetachedPoint();
        }
        return this.c.getQ();
    }

    ECPublicKeyParameters engineGetKeyParameters() {
        return this.c;
    }

    com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec engineGetSpec() {
        if (this.d != null) {
            return EC5Util.convertSpec(this.d, this.b);
        }
        return BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
    }

    public String toString() {
        return ECUtil.publicKeyToString(this.a, this.c.getQ(), this.engineGetSpec());
    }

    @Override
    public void setPointFormat(String string) {
        this.b = !"UNCOMPRESSED".equalsIgnoreCase(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCECGOST3410PublicKey)) {
            return false;
        }
        BCECGOST3410PublicKey bCECGOST3410PublicKey = (BCECGOST3410PublicKey)object;
        return this.c.getQ().equals(bCECGOST3410PublicKey.c.getQ()) && this.engineGetSpec().equals(bCECGOST3410PublicKey.engineGetSpec());
    }

    public int hashCode() {
        return this.c.getQ().hashCode() ^ this.engineGetSpec().hashCode();
    }

    private void a(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.a(SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray)));
    }

    private void a(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }

    ASN1Encodable getGostParams() {
        if (this.e == null && this.d instanceof ECNamedCurveSpec) {
            this.e = new GOST3410PublicKeyAlgParameters(ECGOST3410NamedCurves.getOID(((ECNamedCurveSpec)this.d).getName()), CryptoProObjectIdentifiers.gostR3411_94_CryptoProParamSet);
        }
        return this.e;
    }
}

