/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.prng.drbg;

import com.aspose.imaging.internal.bouncycastle.math.ec.ECPoint;

public class DualECPoints {
    private final ECPoint a;
    private final ECPoint b;
    private final int c;
    private final int d;

    public DualECPoints(int n2, ECPoint eCPoint, ECPoint eCPoint2, int n3) {
        if (!eCPoint.getCurve().equals(eCPoint2.getCurve())) {
            throw new IllegalArgumentException("points need to be on the same curve");
        }
        this.c = n2;
        this.a = eCPoint;
        this.b = eCPoint2;
        this.d = n3;
    }

    public int getSeedLen() {
        return this.a.getCurve().getFieldSize();
    }

    public int getMaxOutlen() {
        return (this.a.getCurve().getFieldSize() - (13 + DualECPoints.a(this.d))) / 8 * 8;
    }

    public ECPoint getP() {
        return this.a;
    }

    public ECPoint getQ() {
        return this.b;
    }

    public int getSecurityStrength() {
        return this.c;
    }

    public int getCofactor() {
        return this.d;
    }

    private static int a(int n2) {
        int n3 = 0;
        while ((n2 >>= 1) != 0) {
            ++n3;
        }
        return n3;
    }
}

