/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.params;

import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECPoint;

public class SM2KeyExchangePrivateParameters
implements CipherParameters {
    private final boolean a;
    private final ECPrivateKeyParameters b;
    private final ECPoint c;
    private final ECPrivateKeyParameters d;
    private final ECPoint e;

    public SM2KeyExchangePrivateParameters(boolean bl2, ECPrivateKeyParameters eCPrivateKeyParameters, ECPrivateKeyParameters eCPrivateKeyParameters2) {
        if (eCPrivateKeyParameters == null) {
            throw new NullPointerException("staticPrivateKey cannot be null");
        }
        if (eCPrivateKeyParameters2 == null) {
            throw new NullPointerException("ephemeralPrivateKey cannot be null");
        }
        ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
        if (!eCDomainParameters.equals(eCPrivateKeyParameters2.getParameters())) {
            throw new IllegalArgumentException("Static and ephemeral private keys have different domain parameters");
        }
        this.a = bl2;
        this.b = eCPrivateKeyParameters;
        this.c = eCDomainParameters.getG().multiply(eCPrivateKeyParameters.getD()).normalize();
        this.d = eCPrivateKeyParameters2;
        this.e = eCDomainParameters.getG().multiply(eCPrivateKeyParameters2.getD()).normalize();
    }

    public boolean isInitiator() {
        return this.a;
    }

    public ECPrivateKeyParameters getStaticPrivateKey() {
        return this.b;
    }

    public ECPoint getStaticPublicPoint() {
        return this.c;
    }

    public ECPrivateKeyParameters getEphemeralPrivateKey() {
        return this.d;
    }

    public ECPoint getEphemeralPublicPoint() {
        return this.e;
    }
}

