/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.params;

import com.aspose.imaging.internal.bouncycastle.crypto.DerivationParameters;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;

public class HKDFParameters
implements DerivationParameters {
    private final byte[] a;
    private final boolean b;
    private final byte[] c;
    private final byte[] d;

    private HKDFParameters(byte[] byArray, boolean bl2, byte[] byArray2, byte[] byArray3) {
        if (byArray == null) {
            throw new IllegalArgumentException("IKM (input keying material) should not be null");
        }
        this.a = Arrays.clone(byArray);
        this.b = bl2;
        this.c = (byte[])(byArray2 == null || byArray2.length == 0 ? null : Arrays.clone(byArray2));
        this.d = byArray3 == null ? new byte[0] : Arrays.clone(byArray3);
    }

    public HKDFParameters(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this(byArray, false, byArray2, byArray3);
    }

    public static HKDFParameters skipExtractParameters(byte[] byArray, byte[] byArray2) {
        return new HKDFParameters(byArray, true, null, byArray2);
    }

    public static HKDFParameters defaultParameters(byte[] byArray) {
        return new HKDFParameters(byArray, false, null, null);
    }

    public byte[] getIKM() {
        return Arrays.clone(this.a);
    }

    public boolean skipExtract() {
        return this.b;
    }

    public byte[] getSalt() {
        return Arrays.clone(this.c);
    }

    public byte[] getInfo() {
        return Arrays.clone(this.d);
    }
}

