/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.modes;

import com.aspose.imaging.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.imaging.internal.bouncycastle.crypto.StreamBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.a;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;

public class G3413CFBBlockCipher
extends StreamBlockCipher {
    private final int a;
    private int b;
    private int c;
    private byte[] d;
    private byte[] e;
    private BlockCipher f;
    private boolean g;
    private boolean h = false;
    private byte[] i;
    private byte[] j;
    private int k;

    public G3413CFBBlockCipher(BlockCipher blockCipher) {
        this(blockCipher, blockCipher.getBlockSize() * 8);
    }

    public G3413CFBBlockCipher(BlockCipher blockCipher, int n2) {
        super(blockCipher);
        if (n2 < 0 || n2 > blockCipher.getBlockSize() * 8) {
            throw new IllegalArgumentException("Parameter bitBlockSize must be in range 0 < bitBlockSize <= " + blockCipher.getBlockSize() * 8);
        }
        this.c = blockCipher.getBlockSize();
        this.f = blockCipher;
        this.a = n2 / 8;
        this.j = new byte[this.getBlockSize()];
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.g = bl2;
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length < this.c) {
                throw new IllegalArgumentException("Parameter m must blockSize <= m");
            }
            this.b = byArray.length;
            this.a();
            this.e = Arrays.clone(byArray);
            System.arraycopy(this.e, 0, this.d, 0, this.e.length);
            if (parametersWithIV.getParameters() != null) {
                this.f.init(true, parametersWithIV.getParameters());
            }
        } else {
            this.b();
            this.a();
            System.arraycopy(this.e, 0, this.d, 0, this.e.length);
            if (cipherParameters != null) {
                this.f.init(true, cipherParameters);
            }
        }
        this.h = true;
    }

    private void a() {
        this.d = new byte[this.b];
        this.e = new byte[this.b];
    }

    private void b() {
        this.b = 2 * this.c;
    }

    @Override
    public String getAlgorithmName() {
        return this.f.getAlgorithmName() + "/CFB" + this.c * 8;
    }

    @Override
    public int getBlockSize() {
        return this.a;
    }

    @Override
    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        this.processBytes(byArray, n2, this.getBlockSize(), byArray2, n3);
        return this.getBlockSize();
    }

    @Override
    protected byte calculateByte(byte by2) {
        if (this.k == 0) {
            this.i = this.createGamma();
        }
        byte by3 = (byte)(this.i[this.k] ^ by2);
        byte by4 = this.j[this.k++] = this.g ? by3 : by2;
        if (this.k == this.getBlockSize()) {
            this.k = 0;
            this.generateR(this.j);
        }
        return by3;
    }

    byte[] createGamma() {
        byte[] byArray = com.aspose.imaging.internal.bouncycastle.crypto.modes.a.a(this.d, this.c);
        byte[] byArray2 = new byte[byArray.length];
        this.f.processBlock(byArray, 0, byArray2, 0);
        return com.aspose.imaging.internal.bouncycastle.crypto.modes.a.a(byArray2, this.a);
    }

    void generateR(byte[] byArray) {
        byte[] byArray2 = com.aspose.imaging.internal.bouncycastle.crypto.modes.a.b(this.d, this.b - this.a);
        System.arraycopy(byArray2, 0, this.d, 0, byArray2.length);
        System.arraycopy(byArray, 0, this.d, byArray2.length, this.b - byArray2.length);
    }

    @Override
    public void reset() {
        this.k = 0;
        Arrays.clear(this.j);
        Arrays.clear(this.i);
        if (this.h) {
            System.arraycopy(this.e, 0, this.d, 0, this.e.length);
            this.f.reset();
        }
    }
}

