/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.generators;

import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.imaging.internal.bouncycastle.crypto.params.RSAKeyParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RSABlindingFactorGenerator {
    private static BigInteger a = BigInteger.valueOf(0L);
    private static BigInteger b = BigInteger.valueOf(1L);
    private RSAKeyParameters c;
    private SecureRandom d;

    public void init(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.c = (RSAKeyParameters)parametersWithRandom.getParameters();
            this.d = parametersWithRandom.getRandom();
        } else {
            this.c = (RSAKeyParameters)cipherParameters;
            this.d = new SecureRandom();
        }
        if (this.c instanceof RSAPrivateCrtKeyParameters) {
            throw new IllegalArgumentException("generator requires RSA public key");
        }
    }

    public BigInteger generateBlindingFactor() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        if (this.c == null) {
            throw new IllegalStateException("generator not initialised");
        }
        BigInteger bigInteger3 = this.c.getModulus();
        int n2 = bigInteger3.bitLength() - 1;
        do {
            bigInteger2 = new BigInteger(n2, this.d);
            bigInteger = bigInteger2.gcd(bigInteger3);
        } while (bigInteger2.equals(a) || bigInteger2.equals(b) || !bigInteger.equals(b));
        return bigInteger2;
    }
}

