/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.agreement.kdf;

import com.aspose.imaging.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.imaging.internal.bouncycastle.crypto.DerivationFunction;
import com.aspose.imaging.internal.bouncycastle.crypto.DerivationParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.Digest;
import com.aspose.imaging.internal.bouncycastle.crypto.OutputLengthException;
import com.aspose.imaging.internal.bouncycastle.crypto.params.KDFParameters;

public class ConcatenationKDFGenerator
implements DerivationFunction {
    private Digest a;
    private byte[] b;
    private byte[] c;
    private int d;

    public ConcatenationKDFGenerator(Digest digest) {
        this.a = digest;
        this.d = digest.getDigestSize();
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        if (!(derivationParameters instanceof KDFParameters)) {
            throw new IllegalArgumentException("KDF parameters required for generator");
        }
        KDFParameters kDFParameters = (KDFParameters)derivationParameters;
        this.b = kDFParameters.getSharedSecret();
        this.c = kDFParameters.getIV();
    }

    public Digest getDigest() {
        return this.a;
    }

    private void a(int n2, byte[] byArray) {
        byArray[0] = (byte)(n2 >>> 24);
        byArray[1] = (byte)(n2 >>> 16);
        byArray[2] = (byte)(n2 >>> 8);
        byArray[3] = (byte)(n2 >>> 0);
    }

    @Override
    public int generateBytes(byte[] byArray, int n2, int n3) throws DataLengthException, IllegalArgumentException {
        if (byArray.length - n3 < n2) {
            throw new OutputLengthException("output buffer too small");
        }
        byte[] byArray2 = new byte[this.d];
        byte[] byArray3 = new byte[4];
        int n4 = 1;
        int n5 = 0;
        this.a.reset();
        if (n3 > this.d) {
            do {
                this.a(n4, byArray3);
                this.a.update(byArray3, 0, byArray3.length);
                this.a.update(this.b, 0, this.b.length);
                this.a.update(this.c, 0, this.c.length);
                this.a.doFinal(byArray2, 0);
                System.arraycopy(byArray2, 0, byArray, n2 + n5, this.d);
                n5 += this.d;
            } while (n4++ < n3 / this.d);
        }
        if (n5 < n3) {
            this.a(n4, byArray3);
            this.a.update(byArray3, 0, byArray3.length);
            this.a.update(this.b, 0, this.b.length);
            this.a.update(this.c, 0, this.c.length);
            this.a.doFinal(byArray2, 0);
            System.arraycopy(byArray2, 0, byArray, n2 + n5, n3 - n5);
        }
        return n3;
    }
}

