/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.cms;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.KeyAgreeRecipientIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.OriginatorPublicKey;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.RecipientEncryptedKey;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.RecipientKeyIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.imaging.internal.bouncycastle.cms.CMSException;
import com.aspose.imaging.internal.bouncycastle.cms.KeyAgreeRecipient;
import com.aspose.imaging.internal.bouncycastle.cms.KeyAgreeRecipientId;
import com.aspose.imaging.internal.bouncycastle.cms.Recipient;
import com.aspose.imaging.internal.bouncycastle.cms.RecipientId;
import com.aspose.imaging.internal.bouncycastle.cms.RecipientInformation;
import com.aspose.imaging.internal.bouncycastle.cms.RecipientOperator;
import com.aspose.imaging.internal.bouncycastle.cms.a;
import com.aspose.imaging.internal.bouncycastle.cms.l;
import com.aspose.imaging.internal.bouncycastle.cms.q;
import java.io.IOException;
import java.util.List;

public class KeyAgreeRecipientInformation
extends RecipientInformation {
    private KeyAgreeRecipientInfo a;
    private ASN1OctetString b;

    static void readRecipientInfo(List list, KeyAgreeRecipientInfo keyAgreeRecipientInfo, AlgorithmIdentifier algorithmIdentifier, l l2, a a2) {
        ASN1Sequence aSN1Sequence = keyAgreeRecipientInfo.getRecipientEncryptedKeys();
        for (int i2 = 0; i2 < aSN1Sequence.size(); ++i2) {
            KeyAgreeRecipientId keyAgreeRecipientId;
            RecipientEncryptedKey recipientEncryptedKey = RecipientEncryptedKey.getInstance(aSN1Sequence.getObjectAt(i2));
            KeyAgreeRecipientIdentifier keyAgreeRecipientIdentifier = recipientEncryptedKey.getIdentifier();
            IssuerAndSerialNumber issuerAndSerialNumber = keyAgreeRecipientIdentifier.getIssuerAndSerialNumber();
            if (issuerAndSerialNumber != null) {
                keyAgreeRecipientId = new KeyAgreeRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
            } else {
                RecipientKeyIdentifier recipientKeyIdentifier = keyAgreeRecipientIdentifier.getRKeyID();
                keyAgreeRecipientId = new KeyAgreeRecipientId(recipientKeyIdentifier.getSubjectKeyIdentifier().getOctets());
            }
            list.add(new KeyAgreeRecipientInformation(keyAgreeRecipientInfo, keyAgreeRecipientId, recipientEncryptedKey.getEncryptedKey(), algorithmIdentifier, l2, a2));
        }
    }

    KeyAgreeRecipientInformation(KeyAgreeRecipientInfo keyAgreeRecipientInfo, RecipientId recipientId, ASN1OctetString aSN1OctetString, AlgorithmIdentifier algorithmIdentifier, l l2, a a2) {
        super(keyAgreeRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, l2, a2);
        this.a = keyAgreeRecipientInfo;
        this.rid = recipientId;
        this.b = aSN1OctetString;
    }

    private SubjectPublicKeyInfo a(AlgorithmIdentifier algorithmIdentifier, OriginatorIdentifierOrKey originatorIdentifierOrKey) throws CMSException, IOException {
        q q2;
        OriginatorPublicKey originatorPublicKey = originatorIdentifierOrKey.getOriginatorKey();
        if (originatorPublicKey != null) {
            return this.a(algorithmIdentifier, originatorPublicKey);
        }
        IssuerAndSerialNumber issuerAndSerialNumber = originatorIdentifierOrKey.getIssuerAndSerialNumber();
        if (issuerAndSerialNumber != null) {
            q2 = new q(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        } else {
            SubjectKeyIdentifier subjectKeyIdentifier = originatorIdentifierOrKey.getSubjectKeyIdentifier();
            q2 = new q(subjectKeyIdentifier.getKeyIdentifier());
        }
        return this.a(q2);
    }

    private SubjectPublicKeyInfo a(AlgorithmIdentifier algorithmIdentifier, OriginatorPublicKey originatorPublicKey) {
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, originatorPublicKey.getPublicKey().getBytes());
        return subjectPublicKeyInfo;
    }

    private SubjectPublicKeyInfo a(q q2) throws CMSException {
        throw new CMSException("No support for 'originator' as IssuerAndSerialNumber or SubjectKeyIdentifier");
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        KeyAgreeRecipient keyAgreeRecipient = (KeyAgreeRecipient)recipient;
        AlgorithmIdentifier algorithmIdentifier = keyAgreeRecipient.getPrivateKeyAlgorithmIdentifier();
        return ((KeyAgreeRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.a(algorithmIdentifier, this.a.getOriginator()), this.a.getUserKeyingMaterial(), this.b.getOctets());
    }
}

