/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.cert.ocsp;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERBitString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.ocsp.OCSPRequest;
import com.aspose.imaging.internal.bouncycastle.asn1.ocsp.Request;
import com.aspose.imaging.internal.bouncycastle.asn1.ocsp.Signature;
import com.aspose.imaging.internal.bouncycastle.asn1.ocsp.TBSRequest;
import com.aspose.imaging.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.GeneralName;
import com.aspose.imaging.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.imaging.internal.bouncycastle.cert.ocsp.CertificateID;
import com.aspose.imaging.internal.bouncycastle.cert.ocsp.OCSPException;
import com.aspose.imaging.internal.bouncycastle.cert.ocsp.OCSPReq;
import com.aspose.imaging.internal.bouncycastle.operator.ContentSigner;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OCSPReqBuilder {
    private List a = new ArrayList();
    private GeneralName b = null;
    private Extensions c = null;

    public OCSPReqBuilder addRequest(CertificateID certificateID) {
        this.a.add(new a(certificateID, null));
        return this;
    }

    public OCSPReqBuilder addRequest(CertificateID certificateID, Extensions extensions) {
        this.a.add(new a(certificateID, extensions));
        return this;
    }

    public OCSPReqBuilder setRequestorName(X500Name x500Name) {
        this.b = new GeneralName(4, x500Name);
        return this;
    }

    public OCSPReqBuilder setRequestorName(GeneralName generalName) {
        this.b = generalName;
        return this;
    }

    public OCSPReqBuilder setRequestExtensions(Extensions extensions) {
        this.c = extensions;
        return this;
    }

    private OCSPReq a(ContentSigner contentSigner, X509CertificateHolder[] x509CertificateHolderArray) throws OCSPException {
        Iterator iterator = this.a.iterator();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while (iterator.hasNext()) {
            try {
                aSN1EncodableVector.add(((a)iterator.next()).a());
            }
            catch (Exception exception) {
                throw new OCSPException("exception creating Request", exception);
            }
        }
        TBSRequest tBSRequest = new TBSRequest(this.b, (ASN1Sequence)new DERSequence(aSN1EncodableVector), this.c);
        Signature signature = null;
        if (contentSigner != null) {
            Object object;
            if (this.b == null) {
                throw new OCSPException("requestorName must be specified if request is signed.");
            }
            try {
                object = contentSigner.getOutputStream();
                ((OutputStream)object).write(tBSRequest.getEncoded("DER"));
                ((OutputStream)object).close();
            }
            catch (Exception exception) {
                throw new OCSPException("exception processing TBSRequest: " + exception, exception);
            }
            object = new DERBitString(contentSigner.getSignature());
            AlgorithmIdentifier algorithmIdentifier = contentSigner.getAlgorithmIdentifier();
            if (x509CertificateHolderArray != null && x509CertificateHolderArray.length > 0) {
                ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
                for (int i2 = 0; i2 != x509CertificateHolderArray.length; ++i2) {
                    aSN1EncodableVector2.add(x509CertificateHolderArray[i2].toASN1Structure());
                }
                signature = new Signature(algorithmIdentifier, (DERBitString)object, new DERSequence(aSN1EncodableVector2));
            } else {
                signature = new Signature(algorithmIdentifier, (DERBitString)object);
            }
        }
        return new OCSPReq(new OCSPRequest(tBSRequest, signature));
    }

    public OCSPReq build() throws OCSPException {
        return this.a(null, null);
    }

    public OCSPReq build(ContentSigner contentSigner, X509CertificateHolder[] x509CertificateHolderArray) throws OCSPException, IllegalArgumentException {
        if (contentSigner == null) {
            throw new IllegalArgumentException("no signer specified");
        }
        return this.a(contentSigner, x509CertificateHolderArray);
    }

    private class a {
        CertificateID a;
        Extensions b;

        public a(CertificateID certificateID, Extensions extensions) {
            this.a = certificateID;
            this.b = extensions;
        }

        public Request a() throws Exception {
            return new Request(this.a.toASN1Primitive(), this.b);
        }
    }
}

