/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.x500;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Choice;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1String;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.DERBMPString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERPrintableString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERT61String;
import com.aspose.imaging.internal.bouncycastle.asn1.DERUTF8String;
import com.aspose.imaging.internal.bouncycastle.asn1.DERUniversalString;

public class DirectoryString
extends ASN1Object
implements ASN1Choice,
ASN1String {
    private ASN1String a;

    public static DirectoryString getInstance(Object object) {
        if (object == null || object instanceof DirectoryString) {
            return (DirectoryString)object;
        }
        if (object instanceof DERT61String) {
            return new DirectoryString((DERT61String)object);
        }
        if (object instanceof DERPrintableString) {
            return new DirectoryString((DERPrintableString)object);
        }
        if (object instanceof DERUniversalString) {
            return new DirectoryString((DERUniversalString)object);
        }
        if (object instanceof DERUTF8String) {
            return new DirectoryString((DERUTF8String)object);
        }
        if (object instanceof DERBMPString) {
            return new DirectoryString((DERBMPString)object);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DirectoryString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        if (!bl2) {
            throw new IllegalArgumentException("choice item must be explicitly tagged");
        }
        return DirectoryString.getInstance(aSN1TaggedObject.getObject());
    }

    private DirectoryString(DERT61String dERT61String) {
        this.a = dERT61String;
    }

    private DirectoryString(DERPrintableString dERPrintableString) {
        this.a = dERPrintableString;
    }

    private DirectoryString(DERUniversalString dERUniversalString) {
        this.a = dERUniversalString;
    }

    private DirectoryString(DERUTF8String dERUTF8String) {
        this.a = dERUTF8String;
    }

    private DirectoryString(DERBMPString dERBMPString) {
        this.a = dERBMPString;
    }

    public DirectoryString(String string) {
        this.a = new DERUTF8String(string);
    }

    @Override
    public String getString() {
        return this.a.getString();
    }

    public String toString() {
        return this.a.getString();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return ((ASN1Encodable)((Object)this.a)).toASN1Primitive();
    }
}

