/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Exception;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.BERApplicationSpecificParser;
import com.aspose.imaging.internal.bouncycastle.asn1.BEROctetStringParser;
import com.aspose.imaging.internal.bouncycastle.asn1.BERSequenceParser;
import com.aspose.imaging.internal.bouncycastle.asn1.BERSetParser;
import com.aspose.imaging.internal.bouncycastle.asn1.BERTaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.BERTaggedObjectParser;
import com.aspose.imaging.internal.bouncycastle.asn1.DERApplicationSpecific;
import com.aspose.imaging.internal.bouncycastle.asn1.DERExternalParser;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetStringParser;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequenceParser;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSetParser;
import com.aspose.imaging.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.InMemoryRepresentable;
import com.aspose.imaging.internal.bouncycastle.asn1.c;
import com.aspose.imaging.internal.bouncycastle.asn1.f;
import com.aspose.imaging.internal.bouncycastle.asn1.g;
import com.aspose.imaging.internal.bouncycastle.asn1.h;
import com.aspose.imaging.internal.bouncycastle.asn1.l;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ASN1StreamParser {
    private final InputStream a;
    private final int b;
    private final byte[][] c;

    public ASN1StreamParser(InputStream inputStream) {
        this(inputStream, l.a(inputStream));
    }

    public ASN1StreamParser(InputStream inputStream, int n2) {
        this.a = inputStream;
        this.b = n2;
        this.c = new byte[11][];
    }

    public ASN1StreamParser(byte[] byArray) {
        this(new ByteArrayInputStream(byArray), byArray.length);
    }

    ASN1Encodable readIndef(int n2) throws IOException {
        switch (n2) {
            case 8: {
                return new DERExternalParser(this);
            }
            case 4: {
                return new BEROctetStringParser(this);
            }
            case 16: {
                return new BERSequenceParser(this);
            }
            case 17: {
                return new BERSetParser(this);
            }
        }
        throw new ASN1Exception("unknown BER object encountered: 0x" + Integer.toHexString(n2));
    }

    ASN1Encodable readImplicit(boolean bl2, int n2) throws IOException {
        if (this.a instanceof h) {
            if (!bl2) {
                throw new IOException("indefinite-length primitive encoding encountered");
            }
            return this.readIndef(n2);
        }
        if (bl2) {
            switch (n2) {
                case 17: {
                    return new DERSetParser(this);
                }
                case 16: {
                    return new DERSequenceParser(this);
                }
                case 4: {
                    return new BEROctetStringParser(this);
                }
            }
        } else {
            switch (n2) {
                case 17: {
                    throw new ASN1Exception("sequences must use constructed encoding (see X.690 8.9.1/8.10.1)");
                }
                case 16: {
                    throw new ASN1Exception("sets must use constructed encoding (see X.690 8.11.1/8.12.1)");
                }
                case 4: {
                    return new DEROctetStringParser((g)this.a);
                }
            }
        }
        throw new ASN1Exception("implicit tagging not implemented");
    }

    ASN1Primitive readTaggedObject(boolean bl2, int n2) throws IOException {
        if (!bl2) {
            g g2 = (g)this.a;
            return new DERTaggedObject(false, n2, new DEROctetString(g2.b()));
        }
        ASN1EncodableVector aSN1EncodableVector = this.readVector();
        if (this.a instanceof h) {
            return aSN1EncodableVector.size() == 1 ? new BERTaggedObject(true, n2, aSN1EncodableVector.get(0)) : new BERTaggedObject(false, n2, com.aspose.imaging.internal.bouncycastle.asn1.c.a(aSN1EncodableVector));
        }
        return aSN1EncodableVector.size() == 1 ? new DERTaggedObject(true, n2, aSN1EncodableVector.get(0)) : new DERTaggedObject(false, n2, f.a(aSN1EncodableVector));
    }

    public ASN1Encodable readObject() throws IOException {
        int n2 = this.a.read();
        if (n2 == -1) {
            return null;
        }
        this.a(false);
        int n3 = ASN1InputStream.readTagNumber(this.a, n2);
        boolean bl2 = (n2 & 0x20) != 0;
        int n4 = ASN1InputStream.readLength(this.a, this.b);
        if (n4 < 0) {
            if (!bl2) {
                throw new IOException("indefinite-length primitive encoding encountered");
            }
            h h2 = new h(this.a, this.b);
            ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(h2, this.b);
            if ((n2 & 0x40) != 0) {
                return new BERApplicationSpecificParser(n3, aSN1StreamParser);
            }
            if ((n2 & 0x80) != 0) {
                return new BERTaggedObjectParser(true, n3, aSN1StreamParser);
            }
            return aSN1StreamParser.readIndef(n3);
        }
        g g2 = new g(this.a, n4);
        if ((n2 & 0x40) != 0) {
            return new DERApplicationSpecific(bl2, n3, g2.b());
        }
        if ((n2 & 0x80) != 0) {
            return new BERTaggedObjectParser(bl2, n3, new ASN1StreamParser(g2));
        }
        if (bl2) {
            switch (n3) {
                case 4: {
                    return new BEROctetStringParser(new ASN1StreamParser(g2));
                }
                case 16: {
                    return new DERSequenceParser(new ASN1StreamParser(g2));
                }
                case 17: {
                    return new DERSetParser(new ASN1StreamParser(g2));
                }
                case 8: {
                    return new DERExternalParser(new ASN1StreamParser(g2));
                }
            }
            throw new IOException("unknown tag " + n3 + " encountered");
        }
        switch (n3) {
            case 4: {
                return new DEROctetStringParser(g2);
            }
        }
        try {
            return ASN1InputStream.createPrimitiveDERObject(n3, g2, this.c);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ASN1Exception("corrupted stream detected", illegalArgumentException);
        }
    }

    private void a(boolean bl2) {
        if (this.a instanceof h) {
            ((h)this.a).a(bl2);
        }
    }

    ASN1EncodableVector readVector() throws IOException {
        ASN1Encodable aSN1Encodable;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while ((aSN1Encodable = this.readObject()) != null) {
            if (aSN1Encodable instanceof InMemoryRepresentable) {
                aSN1EncodableVector.add(((InMemoryRepresentable)((Object)aSN1Encodable)).getLoadedObject());
                continue;
            }
            aSN1EncodableVector.add(aSN1Encodable.toASN1Primitive());
        }
        return aSN1EncodableVector;
    }
}

