/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.imageoptions;

import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.xmp.XmpPacketWrapper;

public class PngOptions
extends ImageOptionsBase {
    public static final int DEFAULT_COMPRESSION_LEVEL = 6;
    private int a = 2;
    private boolean b;
    private int c = 0;
    private int d = 6;
    private byte e = (byte)8;

    public PngOptions() {
    }

    public PngOptions(PngOptions pngOptions) {
        super(pngOptions);
        this.d = pngOptions.d;
        this.a = pngOptions.a;
        this.c = pngOptions.c;
        this.b = pngOptions.b;
        this.setPalette(pngOptions.getPalette());
        this.e = pngOptions.e;
        this.xmpData = pngOptions.xmpData;
    }

    @Override
    public XmpPacketWrapper getXmpData() {
        return this.xmpData;
    }

    @Override
    protected Object memberwiseClone() {
        return new PngOptions(this);
    }

    @Override
    public void setXmpData(XmpPacketWrapper xmpPacketWrapper) {
        this.xmpData = xmpPacketWrapper;
    }

    public int getColorType() {
        return this.a;
    }

    public void setColorType(int n2) {
        this.a = n2;
    }

    public boolean getProgressive() {
        return this.b;
    }

    public void setProgressive(boolean bl2) {
        this.b = bl2;
    }

    public int getFilterType() {
        return this.c;
    }

    public void setFilterType(int n2) {
        this.c = n2;
    }

    public int getCompressionLevel() {
        return this.d;
    }

    public void setCompressionLevel(int n2) {
        if (n2 > 9 || n2 < 0) {
            throw new ArgumentOutOfRangeException("value", "Compresion must be in 0-9 range.");
        }
        this.d = n2;
    }

    public byte getBitDepth() {
        return this.e;
    }

    public void setBitDepth(byte by2) {
        this.e = by2;
    }

    public void b() {
        switch (this.a) {
            case 0: {
                if ((this.e & 0xFF) == 1 || (this.e & 0xFF) == 2 || (this.e & 0xFF) == 4 || (this.e & 0xFF) == 8) break;
                throw new FrameworkException("Bit depth of 1, 2, 4 or 8 bits are supported for grayscale images.");
            }
            case 2: {
                if ((this.e & 0xFF) == 8) break;
                throw new FrameworkException("Bit depth of 8 bits are supported for RGB images.");
            }
            case 3: {
                if ((this.e & 0xFF) == 1 || (this.e & 0xFF) == 2 || (this.e & 0xFF) == 4 || (this.e & 0xFF) == 8) break;
                throw new FrameworkException("Bit depth of 1, 2, 4 or 8 bits are supported for palette images.");
            }
            case 4: {
                if ((this.e & 0xFF) == 8) break;
                throw new FrameworkException("Bit depth of 8 bits are supported for grayscale images with alpha channel.");
            }
            case 6: {
                if ((this.e & 0xFF) == 8) break;
                throw new FrameworkException("Bit depth of 8 bits are supported for RGBA images.");
            }
            default: {
                throw new ArgumentOutOfRangeException();
            }
        }
    }
}

