/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.webp;

import com.aspose.imaging.Color;
import com.aspose.imaging.DisposableObject;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IMultipageImageExt;
import com.aspose.imaging.IRasterImagePixelLoader;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageResizeSettings;
import com.aspose.imaging.LoadOptions;
import com.aspose.imaging.PageExportingAction;
import com.aspose.imaging.RasterCachedImage;
import com.aspose.imaging.RasterCachedMultipageImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.fileformats.webp.IFrame;
import com.aspose.imaging.fileformats.webp.WebPFrameBlock;
import com.aspose.imaging.imagefilters.filteroptions.FilterOptionsBase;
import com.aspose.imaging.imageoptions.WebPOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.NotSupportedException;
import com.aspose.imaging.internal.Exceptions.NullReferenceException;
import com.aspose.imaging.internal.hm.d;
import com.aspose.imaging.internal.hm.g;
import com.aspose.imaging.internal.hn.a;
import com.aspose.imaging.internal.iB.i;
import com.aspose.imaging.internal.iC.e;
import com.aspose.imaging.internal.kF.p;
import com.aspose.imaging.system.IDisposable;
import com.aspose.imaging.system.collections.Generic.IGenericEnumerator;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.FileStream;
import com.aspose.imaging.system.io.Stream;
import java.io.InputStream;

public final class WebPImage
extends RasterCachedMultipageImage
implements IMultipageImageExt {
    private final List<WebPFrameBlock> i = new List();
    private WebPFrameBlock j;
    private final WebPOptions k;

    public WebPImage(InputStream inputStream) {
        this(Stream.fromJava(inputStream));
    }

    WebPImage(Stream stream) {
        this(stream, null);
    }

    public WebPImage(InputStream inputStream, LoadOptions loadOptions) {
        this(Stream.fromJava(inputStream), loadOptions);
    }

    WebPImage(Stream stream, LoadOptions loadOptions) {
        this(new WebPOptions(), loadOptions);
        this.c(stream, loadOptions);
        this.q();
    }

    public WebPImage(String string) {
        this(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebPImage(String string, LoadOptions loadOptions) {
        this(new WebPOptions(), loadOptions);
        FileStream fileStream = new FileStream(string, 3);
        try {
            this.c(fileStream, loadOptions);
        }
        finally {
            fileStream.close();
        }
        this.q();
    }

    public WebPImage(RasterImage rasterImage) {
        this(rasterImage, null);
    }

    public WebPImage(RasterImage rasterImage, LoadOptions loadOptions) {
        this(new WebPOptions(), loadOptions);
        WebPImage webPImage = (WebPImage)((Object)com.aspose.imaging.internal.pI.d.a(rasterImage, WebPImage.class));
        if (webPImage != null) {
            for (Image image : webPImage.getPages()) {
                RasterCachedImage rasterCachedImage = (RasterCachedImage)((Object)com.aspose.imaging.internal.pI.d.a(image, RasterCachedImage.class));
                if (rasterCachedImage == null) continue;
                this.addBlock(new WebPFrameBlock(rasterCachedImage));
            }
        } else {
            WebPFrameBlock webPFrameBlock = new WebPFrameBlock(rasterImage);
            this.addBlock(webPFrameBlock);
        }
        this.q();
    }

    public WebPImage(int n2, int n3, WebPOptions webPOptions) {
        this(n2, n3, webPOptions, null);
    }

    public WebPImage(int n2, int n3, WebPOptions webPOptions, LoadOptions loadOptions) {
        this(webPOptions, loadOptions);
        WebPFrameBlock webPFrameBlock = new WebPFrameBlock(n2, n3);
        this.addBlock(webPFrameBlock);
        this.q();
    }

    WebPImage(Stream stream, LoadOptions loadOptions, i i2) {
        this(new WebPOptions(), loadOptions);
        this.a(i2, true);
        this.c(stream, loadOptions);
        this.q();
    }

    private WebPImage(int n2, int n3, int n4, IRasterImagePixelLoader iRasterImagePixelLoader) {
        this(n2, n3, new WebPOptions());
    }

    private WebPImage(WebPOptions webPOptions, LoadOptions loadOptions) {
        WebPOptions webPOptions2 = webPOptions;
        if (webPOptions2 == null) {
            webPOptions2 = new WebPOptions();
        }
        this.k = webPOptions2;
        if (loadOptions != null) {
            this.a(loadOptions);
        }
    }

    public static WebPImage a(Stream stream, LoadOptions loadOptions, i i2) {
        return new WebPImage(stream, loadOptions, i2);
    }

    public final WebPOptions getOptions() {
        return this.k;
    }

    @Override
    public Image[] getPages() {
        return this.i.toArray((WebPFrameBlock[])new WebPFrameBlock[0]);
    }

    @Override
    public int getPageCount() {
        return this.i.size();
    }

    @Override
    @Deprecated
    public Image getDefaultPage() {
        return this.j;
    }

    @Override
    public long getFileFormat() {
        return 2048L;
    }

    @Override
    public boolean hasAlpha() {
        return super.hasAlpha();
    }

    @Override
    public PageExportingAction getPageExportingAction() {
        return null;
    }

    @Override
    public void setPageExportingAction(PageExportingAction pageExportingAction) {
        throw new NotSupportedException("WebPImage does not support batch export mode.");
    }

    @Override
    public final void addPage(RasterImage rasterImage) {
        if (rasterImage == null) {
            throw new ArgumentNullException("page");
        }
        this.addBlock(new WebPFrameBlock(rasterImage));
    }

    public final void addBlock(IFrame iFrame) {
        this.verifyNotDisposed();
        if (iFrame == null) {
            throw new ArgumentNullException("block");
        }
        WebPFrameBlock webPFrameBlock = (WebPFrameBlock)((Object)com.aspose.imaging.internal.pI.d.a(iFrame, WebPFrameBlock.class));
        if (webPFrameBlock != null) {
            this.i.addItem(webPFrameBlock);
            webPFrameBlock.a(this);
        }
    }

    public final void clearBlocks() {
        this.verifyNotDisposed();
        this.i.clear();
    }

    public final void insertBlock(int n2, IFrame iFrame) {
        this.verifyNotDisposed();
        if (iFrame == null) {
            throw new ArgumentNullException("block");
        }
        WebPFrameBlock webPFrameBlock = (WebPFrameBlock)((Object)com.aspose.imaging.internal.pI.d.a(iFrame, WebPFrameBlock.class));
        if (webPFrameBlock != null && webPFrameBlock.getContainer() != null && webPFrameBlock.getContainer() != this) {
            throw new ArgumentOutOfRangeException("block", "The block belongs to other image and cannot be inserted into this GIF image.");
        }
        this.i.insertItem(n2, webPFrameBlock);
        if (webPFrameBlock != null) {
            webPFrameBlock.a(this);
        }
    }

    public final void removeBlock(IFrame iFrame) {
        this.verifyNotDisposed();
        if (iFrame == null) {
            throw new ArgumentNullException("block");
        }
        WebPFrameBlock webPFrameBlock = (WebPFrameBlock)((Object)com.aspose.imaging.internal.pI.d.a(iFrame, WebPFrameBlock.class));
        if (webPFrameBlock != null && webPFrameBlock.getContainer() != this) {
            throw new ArgumentOutOfRangeException("block", "The block does not belong to the current GIF image.");
        }
        this.i.removeItem(webPFrameBlock);
        if (webPFrameBlock != null) {
            webPFrameBlock.a((Image)null);
        }
    }

    public static WebPImage a(int n2, int n3, int n4, IRasterImagePixelLoader iRasterImagePixelLoader) {
        return new WebPImage(n2, n3, n4, iRasterImagePixelLoader);
    }

    @Override
    protected boolean doUseRecursion(int n2) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveData(Stream stream) {
        g g2 = new g();
        g2.a(this.k.getLossless());
        g2.a(this.getWidth());
        g2.b(this.getHeight());
        g2.f(this.getPageCount() > 1);
        g2.a(this.k.getQuality());
        g2.k(this.k.b());
        g2.a(this.k.c());
        g2.b(this.k.b() > 0);
        if (g2.b() || g2.f()) {
            g2.c(1448097880);
        }
        if (g2.f()) {
            g2.g((int)this.k.getAnimBackgroundColor());
            g2.a((short)this.k.getAnimLoopCount());
        }
        com.aspose.imaging.internal.hm.i i2 = new com.aspose.imaging.internal.hm.i(stream, g2, this.h());
        i2.c();
        DisposableObject disposableObject = null;
        IGenericEnumerator iGenericEnumerator = this.i.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                WebPFrameBlock webPFrameBlock = (WebPFrameBlock)iGenericEnumerator.next();
                if (webPFrameBlock == null) continue;
                a a2 = new a(this.h());
                try {
                    a2.a((e)disposableObject);
                    a2.a(webPFrameBlock, false);
                    i2.a(a2);
                    disposableObject = a2.a();
                    a2.a((e)null);
                }
                finally {
                    a2.dispose();
                }
            }
        }
        finally {
            if (com.aspose.imaging.internal.pI.d.a(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
            if (disposableObject != null) {
                disposableObject.close();
            }
        }
        i2.d();
    }

    @Override
    protected void releaseManagedResources() {
        super.releaseManagedResources();
        this.i.clear();
    }

    @Override
    protected void updateDimensions(int n2, int n3) {
    }

    private void q() {
        if (this.i.get_Item(0) == null) {
            throw new NullReferenceException("The image don't contain frames");
        }
        this.j = this.i.get_Item(0);
        this.setDataLoader(new d(this.j));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c(Stream stream, LoadOptions loadOptions) {
        Object object;
        g g2 = new g();
        p p2 = new com.aspose.imaging.internal.am.a(stream, this, g2, loadOptions).iterator();
        try {
            while (p2.hasNext()) {
                object = (a)p2.next();
                WebPFrameBlock webPFrameBlock = new WebPFrameBlock((a)object);
                this.addBlock(webPFrameBlock);
                if (loadOptions != null) {
                    webPFrameBlock.a(loadOptions);
                }
                webPFrameBlock.cacheData();
            }
        }
        finally {
            if (com.aspose.imaging.internal.pI.d.a(p2, IDisposable.class) != false) {
                ((IDisposable)((Object)p2)).dispose();
            }
        }
        this.k.setAnimBackgroundColor((long)g2.q() & 0xFFFFFFFFL);
        this.k.setAnimLoopCount(g2.r() & 0xFFFF);
        this.k.setLossless(g2.a());
        this.k.setQuality(g2.z());
        this.k.a(g2.v());
        this.k.a(g2.w());
        object = new long[]{this.d};
        Image.a((long[])object, stream);
        this.d = (long)object[0];
    }

    @Override
    public void rotate(float f2, boolean bl2, Color color) {
        super.rotate(f2, bl2, color.Clone());
    }

    @Override
    public void resize(int n2, int n3, int n4) {
        super.resize(n2, n3, n4);
    }

    @Override
    public void resizeWidthProportionally(int n2, int n3) {
        super.resizeWidthProportionally(n2, n3);
    }

    @Override
    public void resizeHeightProportionally(int n2, int n3) {
        super.resizeHeightProportionally(n2, n3);
    }

    @Override
    public void rotateFlip(int n2) {
        super.rotateFlip(n2);
    }

    @Override
    public void dither(int n2, int n3, IColorPalette iColorPalette) {
        super.dither(n2, n3, iColorPalette);
    }

    @Override
    public void crop(Rectangle rectangle) {
        super.crop(rectangle.Clone());
    }

    @Override
    public void crop(int n2, int n3, int n4, int n5) {
        super.crop(n2, n3, n4, n5);
    }

    @Override
    public void binarizeFixed(byte by2) {
        super.binarizeFixed(by2);
    }

    @Override
    public void binarizeOtsu() {
        super.binarizeOtsu();
    }

    @Override
    public void binarizeBradley(double d2, int n2) {
        super.binarizeBradley(d2, n2);
    }

    @Override
    public void grayscale() {
        super.grayscale();
    }

    @Override
    public void adjustGamma(float f2) {
        super.adjustGamma(f2);
    }

    @Override
    public void adjustGamma(float f2, float f3, float f4) {
        super.adjustGamma(f2, f3, f4);
    }

    @Override
    public void adjustBrightness(int n2) {
        super.adjustBrightness(n2);
    }

    @Override
    public void adjustContrast(float f2) {
        super.adjustContrast(f2);
    }

    @Override
    public void filter(Rectangle rectangle, FilterOptionsBase filterOptionsBase) {
        super.filter(rectangle.Clone(), filterOptionsBase);
    }

    @Override
    public void resize(int n2, int n3, ImageResizeSettings imageResizeSettings) {
        super.resize(n2, n3, imageResizeSettings);
    }
}

