/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.jpeg2000;

import com.aspose.imaging.IRasterImageArgb32PixelLoader;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.PixelDataFormat;
import com.aspose.imaging.Point;
import com.aspose.imaging.RasterCachedImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.OperationInterruptedException;
import com.aspose.imaging.coreexceptions.imageformats.Jpeg2000Exception;
import com.aspose.imaging.imageoptions.Jpeg2000Options;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.at.bv;
import com.aspose.imaging.internal.at.k;
import com.aspose.imaging.internal.fk.a;
import com.aspose.imaging.internal.fk.d;
import com.aspose.imaging.internal.fl.f;
import com.aspose.imaging.internal.fu.ai;
import com.aspose.imaging.internal.fu.al;
import com.aspose.imaging.internal.fu.am;
import com.aspose.imaging.internal.fv.c;
import com.aspose.imaging.internal.fv.e;
import com.aspose.imaging.internal.fv.m;
import com.aspose.imaging.internal.iB.i;
import com.aspose.imaging.internal.iC.l;
import com.aspose.imaging.internal.kE.Q;
import com.aspose.imaging.multithreading.IInterruptMonitor;
import com.aspose.imaging.multithreading.InterruptMonitor;
import com.aspose.imaging.system.io.Stream;
import com.aspose.imaging.xmp.XmpPacketWrapper;
import java.io.InputStream;

public final class Jpeg2000Image
extends RasterCachedImage {
    private static final int i = 24;
    private int j;
    private int k;
    private final d l = new d();
    private final Q m = new Q();

    public Jpeg2000Image(String string) {
        this(string, 24);
    }

    public Jpeg2000Image(String string, int n2) {
        if (string == null) {
            throw new ArgumentNullException("path");
        }
        bv bv2 = new bv(string);
        this.a(bv2, bv2.a().getWidth(), bv2.a().getHeight(), n2);
    }

    public Jpeg2000Image(InputStream inputStream) {
        this(Stream.fromJava(inputStream));
    }

    Jpeg2000Image(Stream stream) {
        this(stream, 24);
    }

    public Jpeg2000Image(InputStream inputStream, int n2) {
        this(Stream.fromJava(inputStream), n2);
    }

    Jpeg2000Image(Stream stream, int n2) {
        if (stream == null) {
            throw new ArgumentNullException("stream");
        }
        bv bv2 = new bv(stream);
        this.a(bv2, bv2.a().getWidth(), bv2.a().getHeight(), n2);
    }

    public Jpeg2000Image(int n2, int n3) {
        this(n2, n3, 24);
    }

    public Jpeg2000Image(int n2, int n3, Jpeg2000Options jpeg2000Options) {
        this(n2, n3, 24);
        this.l.a(jpeg2000Options.getComments());
        this.l.a(jpeg2000Options.getCodec());
        this.l.a(jpeg2000Options.getResolutionSettings());
        this.l.a(jpeg2000Options.getXmpData());
        this.l.b(jpeg2000Options.getIrreversible());
    }

    public Jpeg2000Image(int n2, int n3, int n4) {
        if (n4 != 24) {
            throw new Jpeg2000Exception("Only 24 bits per pixel is supported at the moment.");
        }
        this.j = n2;
        this.k = n3;
        this.l.b(n4);
    }

    public Jpeg2000Image(RasterImage rasterImage) {
        this(rasterImage, 24);
    }

    public Jpeg2000Image(RasterImage rasterImage, int n2) {
        if (rasterImage == null) {
            throw new ArgumentNullException("rasterImage");
        }
        this.a(rasterImage, rasterImage.getWidth(), rasterImage.getHeight(), n2);
    }

    private Jpeg2000Image(int n2, int n3, IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader, int n4, String[] stringArray, XmpPacketWrapper xmpPacketWrapper) {
        this.a(iRasterImageArgb32PixelLoader, n2, n3, n4);
        this.l.a(stringArray);
        this.l.a(xmpPacketWrapper);
    }

    private Jpeg2000Image(am am2, String[] stringArray, int n2, XmpPacketWrapper xmpPacketWrapper, ai ai2, IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader) {
        al al2 = am2.g()[0];
        int n3 = (int)((al2.h() & 0xFFFFFFFFL) * (am2.e() & 0xFFFFFFFFL));
        int n4 = (int)al2.d();
        int n5 = (int)al2.e();
        this.l.a(stringArray);
        this.l.a(n2);
        this.l.a(ai2.c().i());
        this.l.a(xmpPacketWrapper);
        this.a(iRasterImageArgb32PixelLoader, n4, n5, n3);
    }

    @Override
    public XmpPacketWrapper getXmpData() {
        return this.l.a();
    }

    @Override
    public void setXmpData(XmpPacketWrapper xmpPacketWrapper) {
        this.l.a(xmpPacketWrapper);
    }

    @Override
    public long getFileFormat() {
        return 512L;
    }

    @Override
    public PixelDataFormat getRawDataFormat() {
        PixelDataFormat pixelDataFormat = PixelDataFormat.getRgb24Bpp();
        switch (this.l.g()) {
            case 24: {
                pixelDataFormat = PixelDataFormat.getRgb24Bpp();
                break;
            }
            case 32: {
                pixelDataFormat = PixelDataFormat.getRgb32Bpp();
                break;
            }
            case 16: {
                pixelDataFormat = PixelDataFormat.getRgb16Bpp555();
                break;
            }
        }
        return pixelDataFormat;
    }

    @Override
    public int getRawLineSize() {
        return this.j * (this.l.g() / 8);
    }

    @Override
    public int getWidth() {
        return this.j;
    }

    @Override
    public int getHeight() {
        return this.k;
    }

    @Override
    public int getBitsPerPixel() {
        return this.l.g();
    }

    @Override
    public double getHorizontalResolution() {
        return this.l.c();
    }

    @Override
    public void setHorizontalResolution(double d2) {
        this.l.a(true);
        this.l.b(d2);
    }

    @Override
    public double getVerticalResolution() {
        return this.l.b();
    }

    @Override
    public void setVerticalResolution(double d2) {
        this.l.a(true);
        this.l.a(d2);
    }

    public String[] getComments() {
        return this.l.e();
    }

    public void setComments(String[] stringArray) {
        this.l.a(stringArray);
    }

    public int getCodec() {
        return this.l.f();
    }

    public Q q() {
        return this.m;
    }

    public void a(Q q2) {
        q2.f(this.m);
    }

    public static Jpeg2000Image a(int n2, int n3, IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader, int n4, String[] stringArray, XmpPacketWrapper xmpPacketWrapper) {
        return new Jpeg2000Image(n2, n3, iRasterImageArgb32PixelLoader, n4, stringArray, xmpPacketWrapper);
    }

    public static Jpeg2000Image a(am am2, String[] stringArray, XmpPacketWrapper xmpPacketWrapper, int n2, ai ai2, IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader) {
        return new Jpeg2000Image(am2, stringArray, n2, xmpPacketWrapper, ai2, iRasterImageArgb32PixelLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void a(RasterImage var0, Stream var1_1, d var2_2, Rectangle var3_3) {
        if (InterruptMonitor.isThreadInterrupted()) {
            throw new OperationInterruptedException("The operation has been interrupted.");
        }
        var4_4 = com.aspose.imaging.internal.fv.c.R();
        var5_5 = Jpeg2000Image.a(var0, var3_3);
        var4_4.a((byte)((var5_5.e() & 0xFFFFFFFFL) >= 3L));
        var4_4.a(var2_2.e());
        var4_4.f(var2_2.d());
        var4_4.a(var2_2.h());
        var4_4.e(var2_2.j());
        var6_6 = var2_2.i();
        if (var6_6 != null) {
            var4_4.l(0);
            var7_7 = var4_4.v();
            for (var8_8 = 0; var8_8 < var6_6.length; ++var8_8) {
                var7_7[var8_8] = (float)var6_6[var8_8];
            }
            var4_4.l(var4_4.u() + var6_6.length);
        }
        var7_7 = var0.h().f();
        try {
            switch (var2_2.f()) {
                case 0: {
                    var8_9 = com.aspose.imaging.internal.fk.a.a(0);
                    var9_12 = var8_9.c();
                    com.aspose.imaging.internal.fq.a.a(var9_12, var4_4, var5_5);
                    com.aspose.imaging.internal.fq.a.a(var9_12, var5_5, var1_1, (i)var7_7);
                    com.aspose.imaging.internal.fq.a.a(var9_12, var1_1, var0.h());
                    com.aspose.imaging.internal.fq.a.a(var9_12, var1_1);
                    ** break;
lbl29:
                    // 1 sources

                    break;
                }
                case 1: {
                    var8_10 = com.aspose.imaging.internal.fk.a.a(2);
                    var10_14 = var8_10.b();
                    com.aspose.imaging.internal.fr.a.a(var10_14, var4_4, var5_5);
                    com.aspose.imaging.internal.fr.a.a(var10_14, var5_5, var1_1, (i)var7_7);
                    com.aspose.imaging.internal.fq.a.a(var10_14.a(), var1_1, var0.h());
                    com.aspose.imaging.internal.fr.a.a(var10_14, var1_1);
                    ** break;
lbl39:
                    // 1 sources

                    break;
                }
                ** default:
lbl41:
                // 1 sources

                break;
            }
        }
        finally {
            var7_7.close();
        }
        for (e var11_17 : var5_5.g()) {
            var11_17.l().close();
        }
        if (var2_2.a() != null && var2_2.f() == 0) {
            var8_11 = new f(var2_2.a());
            var8_11.a(var1_1, true);
        }
    }

    @Override
    public ImageOptionsBase getOriginalOptions() {
        Jpeg2000Options jpeg2000Options = new Jpeg2000Options();
        jpeg2000Options.setCodec(this.l.f());
        jpeg2000Options.setComments(this.l.e());
        jpeg2000Options.setCompressionRatios(this.l.i());
        jpeg2000Options.setIrreversible(this.l.j());
        jpeg2000Options.setResolutionSettings(this.l.h());
        jpeg2000Options.setXmpData(this.l.a());
        return jpeg2000Options;
    }

    @Override
    protected void updateDimensions(int n2, int n3) {
        this.j = n2;
        this.k = n3;
    }

    @Override
    protected boolean doUseRecursion(int n2) {
        if (n2 == 2 || n2 == 1) {
            return true;
        }
        return super.doUseRecursion(n2);
    }

    @Override
    protected void saveData(Stream stream) {
        this.updateMetadata();
        StreamContainer streamContainer = new StreamContainer(stream);
        try {
            Jpeg2000Image.a(this, streamContainer.a(), this.l, this.getBounds());
        }
        finally {
            streamContainer.close();
        }
    }

    private static m a(RasterImage rasterImage, Rectangle rectangle) {
        int n2 = 1;
        com.aspose.imaging.internal.fv.f[] fArray = new com.aspose.imaging.internal.fv.f[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            fArray[i2] = new com.aspose.imaging.internal.fv.f();
            fArray[i2].g(8L);
            fArray[i2].h(8L);
            fArray[i2].i(0L);
            fArray[i2].a(1L);
            fArray[i2].b(1L);
            fArray[i2].c((long)rectangle.getWidth() & 0xFFFFFFFFL);
            fArray[i2].d((long)rectangle.getHeight() & 0xFFFFFFFFL);
        }
        IInterruptMonitor iInterruptMonitor = InterruptMonitor.getThreadLocalInstance();
        if (iInterruptMonitor.isInterrupted()) {
            throw new OperationInterruptedException("The operation has been interrupted.");
        }
        m m2 = com.aspose.imaging.internal.fv.m.a(3L, fArray, n2, rasterImage.h());
        m2.a(0L);
        m2.b(0L);
        m2.c((long)rectangle.getWidth() & 0xFFFFFFFFL);
        m2.d((long)rectangle.getHeight() & 0xFFFFFFFFL);
        Rectangle rectangle2 = rasterImage.getBounds();
        Rectangle rectangle3 = Rectangle.intersect(rectangle, rectangle2);
        int n3 = rectangle3.getHeight();
        int n4 = rectangle3.getWidth();
        if (n4 > 0 && n3 > 0) {
            Point point = new Point(rectangle2.getX() - rectangle.getX(), rectangle2.getY() - rectangle.getY());
            int[] nArray = Jpeg2000Image.b(rasterImage, rectangle3);
            int n5 = rectangle3.getX() + point.getX();
            rectangle3.setX(n5);
            rectangle3.setY(rectangle3.getY() + point.getY());
            int n6 = rectangle3.getY() * rectangle.getWidth();
            int n7 = 0;
            e[] eArray = m2.g();
            l l2 = eArray[0].l().i();
            l l3 = eArray[1].l().i();
            l l4 = eArray[2].l().i();
            for (int i3 = 0; i3 < n3; ++i3) {
                if (i3 % 100 == 0 && iInterruptMonitor.isInterrupted()) {
                    throw new OperationInterruptedException("The operation has been interrupted.");
                }
                int n8 = n6 + n5;
                for (int i4 = 0; i4 < n4; ++i4) {
                    int n9 = nArray[n7];
                    int n10 = n9 >> 16 & 0xFF;
                    int n11 = n9 >> 8 & 0xFF;
                    int n12 = n9 & 0xFF;
                    l2.a(n8, n10);
                    l3.a(n8, n11);
                    l4.a(n8, n12);
                    ++n7;
                    ++n8;
                }
                n6 += rectangle.getWidth();
            }
        }
        return m2;
    }

    private static int[] b(RasterImage rasterImage, Rectangle rectangle) {
        int[] nArray = rasterImage.loadArgb32Pixels(rectangle);
        com.aspose.imaging.internal.at.k.a(rasterImage, new com.aspose.imaging.internal.iE.a(nArray), new Rectangle(0, 0, rectangle.getWidth(), rectangle.getHeight()));
        return nArray;
    }

    private void a(IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader, int n2, int n3, int n4) {
        this.setDataLoader(iRasterImageArgb32PixelLoader);
        this.j = n2;
        this.k = n3;
        this.l.b(n4);
    }
}

