/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.gif.blocks;

import com.aspose.imaging.Color;
import com.aspose.imaging.ColorPalette;
import com.aspose.imaging.DisposableObject;
import com.aspose.imaging.IAdvancedBufferProcessor;
import com.aspose.imaging.IAnimationFrame;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.IPartialRawDataLoader;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.LoadOptions;
import com.aspose.imaging.Point;
import com.aspose.imaging.RasterCachedImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.Size;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.coreexceptions.OperationInterruptedException;
import com.aspose.imaging.coreexceptions.imageformats.GifImageException;
import com.aspose.imaging.fileformats.gif.GifImage;
import com.aspose.imaging.fileformats.gif.IGifBlock;
import com.aspose.imaging.fileformats.gif.blocks.GifGraphicsControlBlock;
import com.aspose.imaging.internal.D.e;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.NotImplementedException;
import com.aspose.imaging.internal.Exceptions.NotSupportedException;
import com.aspose.imaging.internal.at.F;
import com.aspose.imaging.internal.at.aA;
import com.aspose.imaging.internal.at.aZ;
import com.aspose.imaging.internal.at.au;
import com.aspose.imaging.internal.at.bI;
import com.aspose.imaging.internal.at.be;
import com.aspose.imaging.internal.at.bk;
import com.aspose.imaging.internal.at.bv;
import com.aspose.imaging.internal.az.g;
import com.aspose.imaging.internal.az.n;
import com.aspose.imaging.internal.eJ.c;
import com.aspose.imaging.internal.iB.i;
import com.aspose.imaging.internal.iB.x;
import com.aspose.imaging.internal.iM.b;
import com.aspose.imaging.internal.kE.bB;
import com.aspose.imaging.internal.pI.d;
import com.aspose.imaging.multithreading.IInterruptMonitor;
import com.aspose.imaging.multithreading.InterruptMonitor;
import com.aspose.imaging.system.io.Stream;
import java.io.InputStream;
import java.util.Arrays;

public final class GifFrameBlock
extends RasterCachedImage
implements IAnimationFrame,
IGifBlock,
com.aspose.imaging.internal.J.a {
    public static final int EXTENSION_LABEL = 44;
    public static final int IMAGE_DESCRIPTOR_SIZE = 10;
    private byte i;
    private int j;
    private int k;
    private int l;
    private int m;
    private byte n;
    private GifGraphicsControlBlock o;
    private int p;
    private int q;

    public GifFrameBlock(int n2, int n3) {
        this(0, 0, n2, n3);
    }

    public GifFrameBlock(int n2, int n3, int n4, int n5) {
        this(null, n2, n3, n4, n5, null, false, false, 8);
    }

    public GifFrameBlock(int n2, int n3, int n4, int n5, IColorPalette iColorPalette, boolean bl2, boolean bl3, byte by2) {
        this(null, n2, n3, n4, n5, iColorPalette, bl2, bl3, by2);
    }

    public GifFrameBlock(RasterImage rasterImage) {
        this(rasterImage, 0, 0, false, false, 8);
    }

    public GifFrameBlock(RasterImage rasterImage, int n2, int n3) {
        this(rasterImage, n2, n3, false, false, 8);
    }

    public GifFrameBlock(RasterImage rasterImage, int n2, int n3, boolean bl2, boolean bl3, byte by2) {
        if (rasterImage == null) {
            throw new ArgumentNullException("image");
        }
        this.a(new bv(rasterImage), n2, n3, bl2, bl3, by2);
    }

    public GifFrameBlock(InputStream inputStream) {
        this(Stream.fromJava(inputStream));
    }

    public GifFrameBlock(Stream stream) {
        this(stream, 0, 0, false, false, 8);
    }

    public GifFrameBlock(InputStream inputStream, int n2, int n3) {
        this(Stream.fromJava(inputStream), n2, n3);
    }

    GifFrameBlock(Stream stream, int n2, int n3) {
        this(stream, n2, n3, false, false, 8);
    }

    public GifFrameBlock(InputStream inputStream, int n2, int n3, boolean bl2, boolean bl3, byte by2) {
        this(Stream.fromJava(inputStream), n2, n3, bl2, bl3, by2);
    }

    GifFrameBlock(Stream stream, int n2, int n3, boolean bl2, boolean bl3, byte by2) {
        if (stream == null) {
            throw new ArgumentNullException("stream");
        }
        this.a(new bv(stream), n2, n3, bl2, bl3, by2);
    }

    public GifFrameBlock(String string) {
        this(string, 0, 0, false, false, 8);
    }

    public GifFrameBlock(String string, int n2, int n3) {
        this(string, n2, n3, false, false, 8);
    }

    public GifFrameBlock(String string, int n2, int n3, boolean bl2, boolean bl3, byte by2) {
        if (string == null) {
            throw new ArgumentNullException("path");
        }
        this.a(new bv(string), n2, n3, bl2, bl3, by2);
    }

    private GifFrameBlock(com.aspose.imaging.internal.eJ.a a2, int n2, int n3, int n4, int n5, IColorPalette iColorPalette, boolean bl2, boolean bl3, byte by2) {
        super(iColorPalette);
        this.a(iColorPalette, n2, n3, n4 & 0xFFFF, n5 & 0xFFFF, bl2, bl3, by2);
        if (a2 != null) {
            this.setDataLoader(a2);
            a2.a(this);
        }
    }

    public static IColorPalette getColorPalette(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
        IColorPalette iColorPalette3 = null;
        if (iColorPalette != null) {
            iColorPalette3 = iColorPalette;
        } else if (iColorPalette2 != null) {
            iColorPalette3 = iColorPalette2;
        }
        if (iColorPalette3 == null) {
            throw new GifImageException("Cannot work with GIF frame pixels since palette is not present neither in GIF image nor in GIF frame. Tip: setup color palette first.");
        }
        return iColorPalette3;
    }

    public static byte createFlags(IColorPalette iColorPalette, boolean bl2, boolean bl3) {
        byte by2 = 0;
        if (iColorPalette != null) {
            if (iColorPalette.getEntriesCount() == 1) {
                throw new ArgumentOutOfRangeException("colorPalette", "The color palette must contain entries count equal to the power of 2. Minimal entries count are 2 and maximal 256.");
            }
            int n2 = 0;
            int n3 = iColorPalette.getEntriesCount();
            while (n3 > 2) {
                if ((n3 & 1) == 1) {
                    throw new ArgumentOutOfRangeException("colorPalette", "The color palette must contain entries count equal to the power of 2. Minimal entries count are 2 and maximal 256.");
                }
                n3 >>= 1;
                n2 = (byte)(n2 + 1);
            }
            by2 = (byte)(n2 & 0xFF);
            by2 = (byte)(by2 & 0xFF | 0x80);
        }
        if (bl2) {
            by2 = (byte)(by2 & 0xFF | 0x20);
        }
        if (bl3) {
            by2 = (byte)(by2 & 0xFF | 0x40);
        }
        return by2;
    }

    public static GifFrameBlock a(com.aspose.imaging.internal.eJ.a a2, int n2, int n3, int n4, int n5, IColorPalette iColorPalette, boolean bl2, boolean bl3, byte by2) {
        return new GifFrameBlock(a2, n2, n3, n4, n5, iColorPalette, bl2, bl3, by2);
    }

    public static void a(StreamContainer streamContainer, Rectangle rectangle, byte by2) {
        streamContainer.writeByte((byte)44);
        com.aspose.imaging.internal.ic.b b2 = new com.aspose.imaging.internal.ic.b(streamContainer);
        b2.a(rectangle.getLeft());
        b2.a(rectangle.getTop());
        b2.a(rectangle.getWidth());
        b2.a(rectangle.getHeight());
        streamContainer.writeByte(by2);
    }

    public static void a(RasterImage rasterImage, StreamContainer streamContainer, IColorPalette iColorPalette, byte by2, boolean bl2, Rectangle rectangle, int n2) {
        if (iColorPalette == null) {
            throw new ArgumentNullException("palette");
        }
        if (n2 < 0 || n2 > 1000) {
            throw new ArgumentException("GifOptions.MaxDiff must be in range [0, 1000].");
        }
        streamContainer.writeByte(by2);
        GifFrameBlock.b(rasterImage, streamContainer, iColorPalette, by2, bl2, rectangle, n2);
    }

    @Override
    public void a(i i2, boolean bl2) {
        if (this.getContainer() != null) {
            throw new NotSupportedException("Setting a memory manager for an image-related frame is not allowed.");
        }
        super.a(i2, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void b(RasterImage rasterImage, StreamContainer streamContainer, IColorPalette iColorPalette, byte by2, boolean bl2, Rectangle rectangle, int n2) {
        a a2 = new a(rasterImage, streamContainer, iColorPalette, by2 & 0xFF, rectangle, n2);
        try {
            Rectangle rectangle2 = Rectangle.intersect(rasterImage.getBounds(), rectangle);
            if (rectangle2.getWidth() > 0 && rectangle2.getHeight() > 0) {
                com.aspose.imaging.internal.eJ.a a3;
                boolean bl3 = bl2;
                GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.pI.d.a(rasterImage, GifFrameBlock.class));
                com.aspose.imaging.internal.eJ.a a4 = a3 = gifFrameBlock == null ? null : (com.aspose.imaging.internal.eJ.a)((Object)com.aspose.imaging.internal.pI.d.a(gifFrameBlock.getDataLoader(), com.aspose.imaging.internal.eJ.a.class));
                if (a3 != null) {
                    bl3 = !gifFrameBlock.getInterlaced() && bl2;
                    a3.a(!bl3);
                }
                if (bl3) {
                    bk.a(rectangle2, rasterImage.getWidth(), rasterImage.getHeight(), a2, rasterImage);
                } else {
                    bk.a(rectangle2, a2, (b)rasterImage);
                }
                if (a3 != null) {
                    a3.a(false);
                }
            }
            a2.a(true);
        }
        finally {
            a2.close();
        }
    }

    @Override
    public long getFileFormat() {
        return 4L;
    }

    @Override
    public int getWidth() {
        return this.j;
    }

    @Override
    public int getHeight() {
        return this.k;
    }

    @Override
    public int getBitsPerPixel() {
        this.verifyNotDisposed();
        return this.i & 0xFF;
    }

    @Override
    public int getFrameTime() {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock == null) {
            return 10;
        }
        return (gifGraphicsControlBlock.getDelayTime() & 0xFFFF) * 10;
    }

    public void setFrameTime(int n2) {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock != null) {
            gifGraphicsControlBlock.setDelayTime(n2 / 10 & 0xFFFF);
        }
    }

    public boolean getInterlaced() {
        this.verifyNotDisposed();
        return (this.n & 0xFF & 0x40) != 0;
    }

    public void setInterlaced(boolean bl2) {
        this.verifyNotDisposed();
        byte by2 = this.n;
        by2 = bl2 ? (byte)(by2 & 0xFF | 0x40) : (byte)(by2 & 0xFF & 0xBF);
        this.n = by2;
    }

    @Override
    public boolean isInterlaced() {
        return this.getInterlaced();
    }

    public boolean isPaletteSorted() {
        this.verifyNotDisposed();
        return (this.n & 0xFF & 0x20) != 0;
    }

    public void setPaletteSorted(boolean bl2) {
        this.verifyNotDisposed();
        byte by2 = this.n;
        by2 = bl2 ? (byte)(by2 & 0xFF | 0x20) : (byte)(by2 & 0xFF & 0xDF);
        this.n = by2;
    }

    public byte getGifFrameBitsPerPixel() {
        this.verifyNotDisposed();
        return this.i;
    }

    public void setGifFrameBitsPerPixel(byte by2) {
        this.verifyNotDisposed();
        if ((by2 & 0xFF) > 8) {
            throw new ArgumentOutOfRangeException("value", "Too big bits per pixel. The maximal allowed is 8 bits.");
        }
        if ((by2 & 0xFF) < 2) {
            throw new ArgumentOutOfRangeException("value", "Too small bits per pixel. The minimal allowed is 2 bits.");
        }
        this.i = by2;
    }

    public int getLeft() {
        this.verifyNotDisposed();
        return this.l;
    }

    public void setLeft(int n2) {
        this.verifyNotDisposed();
        this.l = n2;
    }

    public int getTop() {
        this.verifyNotDisposed();
        return this.m;
    }

    public void setTop(int n2) {
        this.verifyNotDisposed();
        this.m = n2;
    }

    @Override
    public int getFrameTop() {
        return this.getTop() & 0xFFFF;
    }

    @Override
    public int getFrameLeft() {
        return this.getLeft() & 0xFFFF;
    }

    @Override
    public int getDisposalMethod() {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock == null) {
            return 1;
        }
        switch (gifGraphicsControlBlock.getDisposalMethod()) {
            case 0: 
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return 0;
    }

    public byte getFlags() {
        this.verifyNotDisposed();
        return this.n;
    }

    public void setFlags(byte by2) {
        this.verifyNotDisposed();
        if ((this.n & 0xFF) != (by2 & 0xFF)) {
            if ((by2 & 0x80) > 0 && this.getPalette() == null) {
                throw new ArgumentOutOfRangeException("value", "The flags are incorrect since palette is not present but flags indicate it is.");
            }
            if ((by2 & 0x80) == 0 && this.getPalette() != null) {
                throw new ArgumentOutOfRangeException("value", "The flags are incorrect since palette is present but flags indicate it is not.");
            }
            if (this.getPalette() != null && this.getPalette().getEntriesCount() != 2 << (by2 & 7)) {
                throw new ArgumentOutOfRangeException("value", "The flags are incorrect since palette entries count do not correspond to flags entries count.");
            }
            this.n = by2;
        }
    }

    public GifGraphicsControlBlock getControlBlock() {
        GifGraphicsControlBlock gifGraphicsControlBlock = null;
        Image image = this.getContainer();
        if (image instanceof GifImage) {
            if (this.o != null) {
                return this.o;
            }
            IGifBlock[] iGifBlockArray = ((GifImage)image).r();
            block0: for (int i2 = 0; i2 < iGifBlockArray.length; ++i2) {
                if (iGifBlockArray[i2] != this) continue;
                if (i2 <= 0) break;
                for (int i3 = i2 - 1; i3 >= 0; --i3) {
                    IGifBlock iGifBlock = iGifBlockArray[i3];
                    if (com.aspose.imaging.internal.pI.d.b((Object)iGifBlock, GifGraphicsControlBlock.class)) {
                        gifGraphicsControlBlock = (GifGraphicsControlBlock)iGifBlock;
                        break block0;
                    }
                    if (iGifBlock instanceof GifFrameBlock) break block0;
                }
                break;
            }
        }
        return gifGraphicsControlBlock;
    }

    @Override
    public boolean hasTransparentColor() {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock == null) {
            return false;
        }
        return gifGraphicsControlBlock.hasTransparentColor();
    }

    @Override
    public void setTransparentColor(boolean bl2) {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock != null) {
            gifGraphicsControlBlock.setTransparentColor(bl2);
        } else if (this.getContainer() instanceof GifImage) {
            IGifBlock[] iGifBlockArray = ((GifImage)this.getContainer()).r();
            for (int i2 = 0; i2 < iGifBlockArray.length; ++i2) {
                if (iGifBlockArray[i2] != this) continue;
                GifImage gifImage = (GifImage)((Object)com.aspose.imaging.internal.pI.d.a(this.getContainer(), GifImage.class));
                gifGraphicsControlBlock = new GifGraphicsControlBlock();
                gifGraphicsControlBlock.setTransparentColor(bl2);
                gifImage.a(i2, gifGraphicsControlBlock);
            }
        } else {
            throw new FrameworkException("The block does not belong to any image and transparent color could not be set.");
        }
    }

    @Override
    public Color getTransparentColor() {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock == null) {
            return Color.getEmpty();
        }
        IColorPalette iColorPalette = this.q();
        int n2 = gifGraphicsControlBlock.getTransparentColorIndex() & 0xFF;
        if (n2 < iColorPalette.getEntriesCount()) {
            return Color.fromArgb(iColorPalette.getArgb32Color(n2));
        }
        return Color.getEmpty();
    }

    @Override
    public void setTransparentColor(Color color) {
        IColorPalette iColorPalette = this.q();
        int n2 = color.toArgb();
        this.a(n2, iColorPalette);
    }

    @Override
    public i h() {
        return this.getContainer() != null ? this.getContainer().h() : super.h();
    }

    @Override
    public Color getBackgroundColor() {
        return this.getContainer().getBackgroundColor();
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.getContainer().setBackgroundColor(color);
    }

    @Override
    public ImageOptionsBase getOriginalOptions() {
        if (this.getContainer() != null) {
            GifImage gifImage = (GifImage)this.getContainer();
            return gifImage.q();
        }
        return null;
    }

    @Override
    public void adjustBrightness(int n2) {
        if (this.getPalette() != null) {
            int[] nArray = this.getPalette().getArgb32Entries();
            com.aspose.imaging.internal.eX.g.a(nArray, n2);
            this.setPalette(new ColorPalette(nArray));
        }
    }

    @Override
    public void replaceColor(int n2, byte by2, int n3) {
        Image image = this.getContainer();
        F f2 = new F(n2, by2, n3, this, !((GifImage)((Object)com.aspose.imaging.internal.pI.d.a(image, GifImage.class))).hasTransparentColor());
        bk.a(this.getBounds(), f2, (b)image);
    }

    @Override
    public void replaceNonTransparentColors(int n2) {
        aZ aZ2 = new aZ(n2, this, !((GifImage)((Object)com.aspose.imaging.internal.pI.d.a(this.getContainer(), GifImage.class))).hasTransparentColor());
        bk.a(this.getBounds(), aZ2);
    }

    @Override
    public RasterImage getFullFrame() {
        GifFrameBlock gifFrameBlock = this.f(true);
        gifFrameBlock.o = new GifGraphicsControlBlock();
        gifFrameBlock.o.setFlags(GifGraphicsControlBlock.createFlags(false, false, 0));
        gifFrameBlock.o.setTransparentColor(false);
        return gifFrameBlock;
    }

    @Override
    public IColorPalette o() {
        return this.getContainer() != null ? this.getContainer().getPalette() : this.getPalette();
    }

    @Override
    public boolean a(IColorPalette iColorPalette) {
        boolean bl2;
        boolean bl3 = bl2 = this.getContainer() != null;
        if (bl2) {
            this.getContainer().setPalette(iColorPalette);
        }
        return bl2;
    }

    public void a(int n2, Size size) {
        int n3;
        int n4;
        switch (n2) {
            case 2: 
            case 12: {
                n4 = size.getWidth() - this.j - (this.getLeft() & 0xFFFF);
                n3 = size.getHeight() - this.k - (this.getTop() & 0xFFFF);
                break;
            }
            case 6: 
            case 8: {
                n4 = this.getLeft() & 0xFFFF;
                n3 = size.getHeight() - this.k - (this.getTop() & 0xFFFF);
                break;
            }
            case 4: 
            case 10: {
                n4 = size.getWidth() - this.j - (this.getLeft() & 0xFFFF);
                n3 = this.getTop() & 0xFFFF;
                break;
            }
            case 3: 
            case 13: {
                n4 = this.getTop() & 0xFFFF;
                n3 = size.getWidth() - this.j - (this.getLeft() & 0xFFFF);
                break;
            }
            case 7: 
            case 9: {
                n4 = size.getHeight() - this.k - (this.getTop() & 0xFFFF);
                n3 = size.getWidth() - this.j - (this.getLeft() & 0xFFFF);
                break;
            }
            case 1: 
            case 15: {
                n4 = size.getHeight() - this.k - (this.getTop() & 0xFFFF);
                n3 = this.getLeft() & 0xFFFF;
                break;
            }
            case 5: 
            case 11: {
                n4 = this.getTop() & 0xFFFF;
                n3 = this.getLeft() & 0xFFFF;
                break;
            }
            default: {
                return;
            }
        }
        this.setLeft(n4 & 0xFFFF);
        this.setTop(n3 & 0xFFFF);
    }

    @Override
    public void b(Stream stream) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveData(Stream stream) {
        this.verifyNotDisposed();
        StreamContainer streamContainer = new StreamContainer(stream);
        try {
            GifFrameBlock.a(streamContainer, new Rectangle(this.l & 0xFFFF, this.m & 0xFFFF, this.j, this.k), this.n);
            IColorPalette iColorPalette = this.getPalette();
            if (iColorPalette != null) {
                com.aspose.imaging.internal.eJ.c.a(streamContainer, iColorPalette);
            }
            GifFrameBlock.a(this, streamContainer, this.q(), this.i, this.getInterlaced(), this.getBounds(), 0);
        }
        finally {
            streamContainer.close();
        }
    }

    @Override
    protected void updateDimensions(int n2, int n3) {
        this.j = n2;
        this.k = n3;
    }

    @Override
    protected void onPaletteChanging(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
        if (this.hasTransparentColor()) {
            int n2 = this.getTransparentColor().toArgb();
            IColorPalette iColorPalette3 = iColorPalette2;
            if (iColorPalette3 == null) {
                iColorPalette3 = this.q();
            }
            this.a(n2, iColorPalette3);
        }
        super.onPaletteChanging(iColorPalette, iColorPalette2);
    }

    @Override
    protected void onPaletteChanged(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
        this.n = GifFrameBlock.createFlags(iColorPalette2, (this.n & 0x20) > 0, (this.n & 0x40) > 0);
        if (this.l()) {
            IColorPalette iColorPalette3 = iColorPalette2;
            if (iColorPalette3 == null) {
                iColorPalette3 = this.q();
            }
            this.setGifFrameBitsPerPixel((byte)com.aspose.imaging.internal.iL.c.a(iColorPalette3));
        }
        super.onPaletteChanged(iColorPalette, iColorPalette2);
    }

    private IColorPalette q() {
        IColorPalette iColorPalette = null;
        if (this.getContainer() != null) {
            iColorPalette = this.getContainer().getPalette();
        }
        return GifFrameBlock.getColorPalette(this.getPalette(), iColorPalette);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a(int n2, IColorPalette iColorPalette) {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock == null) {
            if (!(this.getContainer() instanceof GifImage)) throw new FrameworkException("The block does not belong to any image and transparent color could not be set.");
            IGifBlock[] iGifBlockArray = ((GifImage)this.getContainer()).r();
            for (int i2 = 0; i2 < iGifBlockArray.length; ++i2) {
                if (iGifBlockArray[i2] != this) continue;
                GifImage gifImage = (GifImage)this.getContainer();
                GifGraphicsControlBlock gifGraphicsControlBlock2 = new GifGraphicsControlBlock();
                gifGraphicsControlBlock2.setTransparentColorIndex((byte)iColorPalette.getNearestColorIndex(n2));
                gifGraphicsControlBlock2.setTransparentColor(true);
                gifImage.a(i2, gifGraphicsControlBlock2);
                return;
            }
            return;
        } else {
            gifGraphicsControlBlock.setTransparentColorIndex((byte)iColorPalette.getNearestColorIndex(n2));
            gifGraphicsControlBlock.setTransparentColor(true);
        }
    }

    private void a(IColorPalette iColorPalette, int n2, int n3, int n4, int n5, boolean bl2, boolean bl3, byte by2) {
        this.n = GifFrameBlock.createFlags(iColorPalette, bl2, bl3);
        this.l = n2;
        this.m = n3;
        this.i = (by2 & 0xFF) > 8 ? (byte)8 : ((by2 & 0xFF) < 2 ? (byte)2 : by2);
        this.j = n4;
        this.k = n5;
    }

    private void r() {
        GifImage gifImage = (GifImage)this.getContainer();
        int n2 = 0;
        int n3 = 0;
        for (Image image : gifImage.getPages()) {
            GifGraphicsControlBlock gifGraphicsControlBlock;
            GifFrameBlock gifFrameBlock = (GifFrameBlock)image;
            if (n3 > 0 && (gifGraphicsControlBlock = gifFrameBlock.getControlBlock()) != null) {
                switch (gifGraphicsControlBlock.getDisposalMethod()) {
                    case 0: 
                    case 2: {
                        n2 = n3;
                        break;
                    }
                    case 3: {
                        n2 = bB.d(0, n3 - 2);
                        break;
                    }
                }
            }
            gifFrameBlock.p = n2;
            gifFrameBlock.q = n3++;
        }
    }

    private GifFrameBlock f(boolean bl2) {
        GifFrameBlock gifFrameBlock;
        GifImage gifImage;
        if (bl2) {
            this.r();
        }
        if ((gifImage = (GifImage)this.getContainer()).getPageCount() < 2) {
            return this;
        }
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock != null && gifGraphicsControlBlock.getDisposalMethod() == 2) {
            gifFrameBlock = new GifFrameBlock(0, 0, gifImage.getWidth() & 0xFFFF, gifImage.getHeight() & 0xFFFF);
            int[] nArray = new int[gifFrameBlock.j];
            int n2 = this.getBackgroundColor().toArgb();
            Arrays.fill(nArray, n2);
            for (int i2 = 0; i2 < gifFrameBlock.k; ++i2) {
                gifFrameBlock.saveArgb32Pixels(new Rectangle(0, i2, gifFrameBlock.j, 1), nArray);
            }
        } else {
            gifFrameBlock = this.p == this.q ? new GifFrameBlock(0, 0, gifImage.getWidth() & 0xFFFF, gifImage.getHeight() & 0xFFFF) : ((GifFrameBlock)gifImage.getPages()[this.q - 1]).f(false);
        }
        gifFrameBlock.a(this.i());
        this.a(gifFrameBlock, this);
        return gifFrameBlock;
    }

    private void a(RasterImage rasterImage, RasterImage rasterImage2) {
        GifFrameBlock gifFrameBlock = (GifFrameBlock)rasterImage2;
        Rectangle rectangle = new Rectangle(gifFrameBlock.getLeft() & 0xFFFF, gifFrameBlock.getTop() & 0xFFFF, gifFrameBlock.j, gifFrameBlock.k);
        aA aA2 = new aA(rasterImage2, rectangle, rasterImage);
        rasterImage.a(this.getContainer());
        ((GifFrameBlock)rasterImage).o = this.getControlBlock();
        rasterImage.loadPartialArgb32Pixels(rectangle, aA2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(bv bv2, int n2, int n3, boolean bl2, boolean bl3, byte by2) {
        boolean bl4 = true;
        try {
            this.a(bv2.a().getPalette(), n2, n3, bv2.a().getWidth(), bv2.a().getHeight(), bl2, bl3, by2);
            this.setPalette(bv2.a().getPalette());
            this.setDataLoader(bv2);
            bl4 = false;
        }
        finally {
            if (bl4) {
                bv2.dispose();
            }
        }
    }

    private static class a
    extends DisposableObject
    implements IAdvancedBufferProcessor,
    IPartialArgb32PixelLoader,
    IPartialRawDataLoader,
    au {
        private final StreamContainer a;
        private final IColorPalette b;
        private final bI c;
        private final g d;
        private final Rectangle e = new Rectangle();
        private final RasterImage f;
        private final e<Byte> g;
        private byte[] h;
        private int i;
        private int j;
        private final be k;

        public a(RasterImage rasterImage, StreamContainer streamContainer, IColorPalette iColorPalette, int n2, Rectangle rectangle, int n3) {
            this.f = rasterImage;
            this.b = iColorPalette;
            this.a = new StreamContainer(streamContainer.a());
            this.a.seekBegin();
            if (n3 > 0) {
                GifGraphicsControlBlock gifGraphicsControlBlock;
                int n4 = -1;
                GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.pI.d.a(this.f, GifFrameBlock.class));
                if (gifFrameBlock != null && (gifGraphicsControlBlock = gifFrameBlock.getControlBlock()) != null) {
                    n4 = gifGraphicsControlBlock.getTransparentColorIndex() & 0xFF;
                }
                this.d = new n(this, n2, n3, iColorPalette, n4);
            } else {
                this.d = new g(this, n2);
            }
            this.d.d();
            rectangle.CloneTo(this.e);
            this.j = rectangle.getWidth() * rectangle.getHeight();
            if (this.f.h().c()) {
                this.g = com.aspose.imaging.internal.D.a.a(Byte.TYPE, 1);
                this.c = null;
            } else {
                this.h = (byte[])x.b(0).c(Byte.TYPE, (long)rectangle.getWidth() * (long)rectangle.getHeight());
                this.c = new bI(iColorPalette);
                this.g = null;
            }
            this.k = new be(this.f, this.e, this, iColorPalette, true);
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            if (this.g != null) {
                this.a(rectangle, nArray);
                return;
            }
            byte[] byArray = this.h;
            int n2 = this.i;
            bI bI2 = this.c;
            int n3 = bB.d(byArray.length - n2, nArray.length);
            int n4 = 0;
            int n5 = -1;
            GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.pI.d.a(this.f, GifFrameBlock.class));
            if (gifFrameBlock != null && gifFrameBlock.getControlBlock() != null) {
                n5 = gifFrameBlock.getControlBlock().getTransparentColorIndex() & 0xFF;
            }
            IInterruptMonitor iInterruptMonitor = InterruptMonitor.getThreadLocalInstance();
            do {
                int n6;
                int n7;
                if (n5 == -1) {
                    for (n7 = 0; n7 < n3; ++n7) {
                        if ((n7 & 0x270F) == 0 && iInterruptMonitor.isInterrupted()) {
                            throw new OperationInterruptedException("The operation has been interrupted.");
                        }
                        n6 = nArray[n4++];
                        byArray[n2++] = (byte)bI2.getNearestColorIndex(n6);
                    }
                } else {
                    for (n7 = 0; n7 < n3; ++n7) {
                        if ((n7 & 0x270F) == 0 && iInterruptMonitor.isInterrupted()) {
                            throw new OperationInterruptedException("The operation has been interrupted.");
                        }
                        n6 = nArray[n4++];
                        byArray[n2++] = n6 == 0 ? (byte)n5 : (byte)bI2.getNearestColorIndex(n6);
                    }
                }
                if (byArray.length - n2 != 0) continue;
                this.d.a(byArray, n2);
                n2 = 0;
            } while ((n3 = bB.d(byArray.length - n2, nArray.length - n4)) > 0);
            this.i = n2;
            this.j -= nArray.length;
            if (this.j == 0) {
                this.a(false);
            }
        }

        @Override
        public void process(Rectangle rectangle, byte[] byArray, Point point, Point point2) {
            this.d.a(byArray, byArray.length);
            this.j -= byArray.length;
            if (this.j == 0) {
                this.d.a(this.e.getHeight());
            }
        }

        @Override
        public void process(Rectangle rectangle, byte[] byArray, Point point, Point point2, LoadOptions loadOptions) {
            throw new NotImplementedException();
        }

        @Override
        public void processBuffer(byte[] byArray, int n2) {
            this.a.write(byArray, 0, n2);
        }

        @Override
        public void finishRow() {
        }

        @Override
        public void finishRows(int n2) {
        }

        @Override
        public void a(Rectangle rectangle) {
            this.f.loadPartialArgb32Pixels(rectangle, this.k);
        }

        public void a(boolean bl2) {
            if (!bl2 || this.j > 0) {
                this.k.a();
                this.d.a(this.h, this.i);
                this.d.a(this.e.getHeight());
            }
        }

        @Override
        protected void releaseManagedResources() {
            this.k.dispose();
            this.a.dispose();
            super.releaseManagedResources();
        }

        private void a(Rectangle rectangle, int[] nArray) {
            this.h = (byte[])this.g.a(rectangle.getWidth() * rectangle.getHeight());
            this.i = 0;
            byte[] byArray = this.h;
            int n2 = this.i;
            IColorPalette iColorPalette = this.b;
            int n3 = bB.d(byArray.length - n2, nArray.length);
            int n4 = 0;
            int n5 = -1;
            GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.pI.d.a(this.f, GifFrameBlock.class));
            if (gifFrameBlock != null && gifFrameBlock.getControlBlock() != null) {
                n5 = gifFrameBlock.getControlBlock().getTransparentColorIndex() & 0xFF;
            }
            IInterruptMonitor iInterruptMonitor = InterruptMonitor.getThreadLocalInstance();
            do {
                int n6;
                int n7;
                if (n5 == -1) {
                    for (n7 = 0; n7 < n3; ++n7) {
                        if ((n7 & 0x270F) == 0 && iInterruptMonitor.isInterrupted()) {
                            throw new OperationInterruptedException("The operation has been interrupted.");
                        }
                        n6 = nArray[n4++];
                        byArray[n2++] = (byte)iColorPalette.getNearestColorIndex(n6);
                    }
                } else {
                    for (n7 = 0; n7 < n3; ++n7) {
                        if ((n7 & 0x270F) == 0 && iInterruptMonitor.isInterrupted()) {
                            throw new OperationInterruptedException("The operation has been interrupted.");
                        }
                        n6 = nArray[n4++];
                        byArray[n2++] = n6 == 0 ? (byte)n5 : (byte)iColorPalette.getNearestColorIndex(n6);
                    }
                }
                if (byArray.length - n2 != 0) continue;
                this.d.a(byArray, n2);
                n2 = 0;
            } while ((n3 = bB.d(byArray.length - n2, nArray.length - n4)) > 0);
            this.i = n2;
            this.j -= nArray.length;
            if (this.j == 0) {
                this.a(false);
            } else {
                this.d.a(this.h, this.i);
            }
        }
    }
}

