/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.gif;

import com.aspose.imaging.Color;
import com.aspose.imaging.ColorPalette;
import com.aspose.imaging.ColorPaletteHelper;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IMultipageImageExt;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.IPartialRawDataLoader;
import com.aspose.imaging.IRasterImageArgb32PixelLoader;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.ImageResizeSettings;
import com.aspose.imaging.PageExportingAction;
import com.aspose.imaging.RasterCachedMultipageImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.RawDataSettings;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.Size;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.ImageException;
import com.aspose.imaging.coreexceptions.imageformats.GifImageException;
import com.aspose.imaging.fileformats.gif.IGifBlock;
import com.aspose.imaging.fileformats.gif.blocks.GifApplicationExtensionBlock;
import com.aspose.imaging.fileformats.gif.blocks.GifFrameBlock;
import com.aspose.imaging.fileformats.gif.blocks.GifGraphicsControlBlock;
import com.aspose.imaging.fileformats.gif.blocks.GifPlainTextRenderingBlock;
import com.aspose.imaging.fileformats.gif.c;
import com.aspose.imaging.fileformats.gif.d;
import com.aspose.imaging.fileformats.gif.e;
import com.aspose.imaging.fileformats.gif.f;
import com.aspose.imaging.fileformats.gif.g;
import com.aspose.imaging.fileformats.gif.h;
import com.aspose.imaging.fileformats.gif.i;
import com.aspose.imaging.imagefilters.filteroptions.FilterOptionsBase;
import com.aspose.imaging.imageoptions.GifOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.NotSupportedException;
import com.aspose.imaging.internal.at.bW;
import com.aspose.imaging.internal.at.bb;
import com.aspose.imaging.internal.iZ.j;
import com.aspose.imaging.internal.kE.aU;
import com.aspose.imaging.internal.kE.au;
import com.aspose.imaging.internal.lt.l;
import com.aspose.imaging.system.IDisposable;
import com.aspose.imaging.system.collections.Generic.IGenericEnumerator;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.MemoryStream;
import com.aspose.imaging.system.io.Stream;
import com.aspose.imaging.xmp.XmpPacketWrapper;
import java.lang.ref.WeakReference;

public final class GifImage
extends RasterCachedMultipageImage
implements IMultipageImageExt,
com.aspose.imaging.internal.J.a {
    private final com.aspose.imaging.internal.eJ.b i;
    private final List<IGifBlock> j = new List();
    private GifFrameBlock k;
    private boolean l;
    private static final String m = "XMP Data";
    private static final String n = "XMP";
    private static final int o = 258;
    private Image[] p;
    private GifOptions q;

    public GifImage(GifFrameBlock gifFrameBlock, IColorPalette iColorPalette) {
        this(gifFrameBlock, iColorPalette, false, 0, 0, 0, true);
    }

    public GifImage(GifFrameBlock gifFrameBlock) {
        this(gifFrameBlock, null);
    }

    public GifImage(GifFrameBlock gifFrameBlock, IColorPalette iColorPalette, boolean bl2, byte by2, byte by3, byte by4, boolean bl3) {
        byte by5;
        int n2;
        if (gifFrameBlock == null) {
            throw new ArgumentNullException("firstFrame");
        }
        if (gifFrameBlock.getContainer() != null) {
            throw new ArgumentException("The first frame already belongs to some other image. Check the Container property.", "firstFrame");
        }
        IColorPalette iColorPalette2 = gifFrameBlock.getPalette();
        int n3 = 0;
        if (iColorPalette != null) {
            n3 = n2 = iColorPalette.getEntriesCount();
            by5 = com.aspose.imaging.internal.eJ.b.a(n2, true, bl2, by2);
        } else if (iColorPalette2 == null) {
            iColorPalette2 = ColorPaletteHelper.create8Bit();
            n2 = iColorPalette2.getEntriesCount();
            by5 = com.aspose.imaging.internal.eJ.b.a(n2, true, false, (byte)0);
            n3 = n2;
            iColorPalette = iColorPalette2;
        } else {
            by5 = com.aspose.imaging.internal.eJ.b.a(0, false, false, (byte)0);
        }
        com.aspose.imaging.internal.eJ.b b2 = new com.aspose.imaging.internal.eJ.b(gifFrameBlock.getWidth(), gifFrameBlock.getHeight(), by5, by3, by4);
        if (b2.k() != n3 && n3 > 0) {
            throw new GifImageException("The palette specified should contain entries count equal to power of 2. Minimal palette size is 2, maximal is 256.");
        }
        this.i = b2;
        this.j.addItem(gifFrameBlock);
        gifFrameBlock.a(this);
        this.k = gifFrameBlock;
        this.l = bl3;
        this.setPalette(iColorPalette);
        this.setDataLoader(new a(this));
    }

    private GifImage(com.aspose.imaging.internal.eJ.b b2, IGifBlock[] iGifBlockArray, IColorPalette iColorPalette, boolean bl2, GifFrameBlock gifFrameBlock, int n2, GifOptions gifOptions) {
        this(b2, iGifBlockArray, iColorPalette, bl2, gifFrameBlock);
        this.setLoopsCount(n2);
        this.q = gifOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GifImage(com.aspose.imaging.internal.eJ.b b2, IGifBlock[] iGifBlockArray, IColorPalette iColorPalette, boolean bl2, GifFrameBlock gifFrameBlock) {
        super(iColorPalette);
        this.i = b2;
        for (IGifBlock iGifBlock : iGifBlockArray) {
            GifApplicationExtensionBlock gifApplicationExtensionBlock;
            Image image = (Image)((Object)com.aspose.imaging.internal.pI.d.a(iGifBlock, Image.class));
            if (image != null) {
                image.a(this);
            }
            if ((gifApplicationExtensionBlock = (GifApplicationExtensionBlock)((Object)com.aspose.imaging.internal.pI.d.a(iGifBlock, GifApplicationExtensionBlock.class))) == null) continue;
            try {
                byte[] byArray;
                int n2;
                byte[] byArray2 = gifApplicationExtensionBlock.getApplicationAuthenticationCode();
                byte[] byArray3 = com.aspose.imaging.internal.lt.l.t().c(n);
                if (!m.equals(gifApplicationExtensionBlock.getApplicationIdentifier()) || byArray2 == null || byArray2.length != n.length() || (byArray2[0] & 0xFFFF) != (byArray3[0] & 0xFFFF) || (byArray2[1] & 0xFFFF) != (byArray3[1] & 0xFFFF) || (byArray2[2] & 0xFFFF) != (byArray3[2] & 0xFFFF) || (n2 = (byArray = gifApplicationExtensionBlock.getApplicationData()).length - 257) <= 0) continue;
                com.aspose.imaging.internal.iY.a a2 = new com.aspose.imaging.internal.iY.a(com.aspose.imaging.internal.lt.l.x());
                MemoryStream memoryStream = new MemoryStream(byArray);
                try {
                    String string = a2.b(memoryStream, n2);
                    j j2 = new j(string);
                    this.xmpData = j2.a();
                }
                finally {
                    memoryStream.dispose();
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.j.addRange((IGifBlock[])iGifBlockArray);
        this.l = bl2;
        this.k = gifFrameBlock;
        this.setDataLoader(new a(this));
    }

    @Override
    public long getFileFormat() {
        return 4L;
    }

    @Override
    public XmpPacketWrapper getXmpData() {
        return this.xmpData;
    }

    @Override
    public void setXmpData(XmpPacketWrapper xmpPacketWrapper) {
        this.xmpData = xmpPacketWrapper;
    }

    public boolean hasTrailer() {
        return this.l;
    }

    public void setTrailer(boolean bl2) {
        this.l = bl2;
    }

    public boolean isPaletteSorted() {
        return this.i.i();
    }

    public void setPaletteSorted(boolean bl2) {
        this.i.b(bl2);
    }

    public final int getLoopsCount() {
        for (IGifBlock iGifBlock : this.r()) {
            GifApplicationExtensionBlock gifApplicationExtensionBlock;
            if (!(iGifBlock instanceof GifApplicationExtensionBlock) || !GifApplicationExtensionBlock.a(gifApplicationExtensionBlock = (GifApplicationExtensionBlock)((Object)com.aspose.imaging.internal.pI.d.a(iGifBlock, GifApplicationExtensionBlock.class)))) continue;
            return gifApplicationExtensionBlock.a();
        }
        return GifApplicationExtensionBlock.c;
    }

    public final void setLoopsCount(int n2) {
        GifApplicationExtensionBlock gifApplicationExtensionBlock = null;
        for (IGifBlock iGifBlock : this.r()) {
            GifApplicationExtensionBlock gifApplicationExtensionBlock2 = (GifApplicationExtensionBlock)((Object)com.aspose.imaging.internal.pI.d.a(iGifBlock, GifApplicationExtensionBlock.class));
            if (gifApplicationExtensionBlock2 == null || !GifApplicationExtensionBlock.a(gifApplicationExtensionBlock2)) continue;
            gifApplicationExtensionBlock = gifApplicationExtensionBlock2;
            break;
        }
        if (n2 == GifApplicationExtensionBlock.c && gifApplicationExtensionBlock != null) {
            this.b(gifApplicationExtensionBlock);
        }
        if (n2 < 0) {
            throw new GifImageException("Loops count must be positive");
        }
        if (n2 != GifApplicationExtensionBlock.c) {
            if (gifApplicationExtensionBlock == null) {
                GifApplicationExtensionBlock gifApplicationExtensionBlock3 = new GifApplicationExtensionBlock();
                gifApplicationExtensionBlock3.setApplicationIdentifier(GifApplicationExtensionBlock.a);
                gifApplicationExtensionBlock3.setApplicationAuthenticationCode(com.aspose.imaging.internal.lt.l.t().c(GifApplicationExtensionBlock.b));
                gifApplicationExtensionBlock3.a(n2);
                this.a(gifApplicationExtensionBlock3);
            } else {
                gifApplicationExtensionBlock.a(n2);
            }
        }
    }

    public byte getPaletteColorResolutionBits() {
        return this.i.j();
    }

    public void setPaletteColorResolutionBits(byte by2) {
        this.i.c(by2);
    }

    @Override
    public int getPageCount() {
        return this.getPages() != null ? this.getPages().length : 0;
    }

    @Override
    public Image[] getPages() {
        if (this.p != null) {
            return this.p;
        }
        List<Image> list = new List<Image>();
        for (IGifBlock iGifBlock : this.getBlocks()) {
            if (!com.aspose.imaging.internal.pI.d.b((Object)iGifBlock, Image.class)) continue;
            list.addItem((Image)((Object)iGifBlock));
        }
        this.p = list.toArray(new Image[0]);
        return this.p;
    }

    @Override
    @Deprecated
    public Image getDefaultPage() {
        return this.k;
    }

    public final IGifBlock[] getBlocks() {
        return this.r();
    }

    @Override
    public final boolean isInterlaced() {
        if (this.k != null) {
            return this.k.isInterlaced();
        }
        return false;
    }

    @Override
    public ImageOptionsBase getOriginalOptions() {
        return this.q;
    }

    @Override
    public final void addPage(RasterImage rasterImage) {
        if (rasterImage == null) {
            throw new ArgumentNullException("page");
        }
        this.addBlock(new GifGraphicsControlBlock());
        this.addBlock(new GifFrameBlock(rasterImage));
    }

    public final GifFrameBlock getActiveFrame() {
        return this.k;
    }

    public final void setActiveFrame(GifFrameBlock gifFrameBlock) {
        if (gifFrameBlock != null && (gifFrameBlock.getContainer() == null || gifFrameBlock.getContainer() != this)) {
            throw new GifImageException("The frame does not belong to the current GIF image.");
        }
        this.k = gifFrameBlock;
    }

    @Override
    public Color getBackgroundColor() {
        Color color = Color.getEmpty();
        if (this.getPalette() != null && (this.i.b() & 0xFF) < this.getPalette().getEntriesCount()) {
            this.getPalette().getColor(this.i.b() & 0xFF).CloneTo(color);
        }
        return color;
    }

    @Override
    public void setBackgroundColor(Color color) {
        if (this.getPalette() != null) {
            this.i.a((byte)this.getPalette().getNearestColorIndex(color));
        }
    }

    public final byte getBackgroundColorIndex() {
        return this.i.b();
    }

    public final void setBackgroundColorIndex(byte by2) {
        this.i.a(by2);
    }

    public final byte getPixelAspectRatio() {
        return this.i.g();
    }

    public final void setPixelAspectRatio(byte by2) {
        this.i.b(by2);
    }

    @Override
    public boolean hasTransparentColor() {
        return this.k.hasTransparentColor();
    }

    @Override
    public void setTransparentColor(boolean bl2) {
        this.k.setTransparentColor(bl2);
    }

    @Override
    public Color getTransparentColor() {
        return this.k.getTransparentColor();
    }

    @Override
    public boolean hasBackgroundColor() {
        return Color.op_Inequality(this.getBackgroundColor(), Color.getEmpty());
    }

    @Override
    public float getImageOpacity() {
        if (this.k != null) {
            return this.k.getImageOpacity();
        }
        return super.getImageOpacity();
    }

    @Override
    public PageExportingAction getPageExportingAction() {
        return null;
    }

    @Override
    public void setPageExportingAction(PageExportingAction pageExportingAction) {
        throw new NotSupportedException("GifImage does not support batch export mode.");
    }

    public GifOptions q() {
        return this.q;
    }

    public void a(GifOptions gifOptions) {
        this.q = gifOptions;
    }

    @Override
    public boolean f() {
        int n2 = this.getBlocks().length;
        for (int i2 = 0; i2 < n2; ++i2) {
            GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.pI.d.a(this.getBlocks()[i2], GifFrameBlock.class));
            if (gifFrameBlock == null || !gifFrameBlock.f()) continue;
            return true;
        }
        return super.f();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IGifBlock[] r() {
        Object object = this.c;
        synchronized (object) {
            return this.j.toArray((IGifBlock[])new IGifBlock[0]);
        }
    }

    @Override
    public void resize(int n2, int n3, int n4) {
        this.verifyNotDisposed();
        double d2 = (double)n2 / (double)this.getWidth();
        double d3 = (double)n3 / (double)this.getHeight();
        for (Image image : this.getPages()) {
            GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.pI.d.a(image, GifFrameBlock.class));
            if (gifFrameBlock == null) continue;
            gifFrameBlock.resize(com.aspose.imaging.internal.pI.d.e((double)gifFrameBlock.getWidth() * d2), com.aspose.imaging.internal.pI.d.e((double)gifFrameBlock.getHeight() * d3), n4);
            gifFrameBlock.setLeft(com.aspose.imaging.internal.pI.d.d((double)(gifFrameBlock.getLeft() & 0xFFFF) * d2));
            gifFrameBlock.setTop(com.aspose.imaging.internal.pI.d.d((double)(gifFrameBlock.getTop() & 0xFFFF) * d3));
        }
        this.updateDimensions(n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rotateFlip(int n2) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.doUseRecursion(15);
            try {
                this.b(bl2);
                this.verifyNotDisposed();
                Size size = this.getSize();
                for (Image image : this.getPages()) {
                    GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.pI.d.a(image, GifFrameBlock.class));
                    if (gifFrameBlock == null) continue;
                    gifFrameBlock.a(n2, size.Clone());
                    gifFrameBlock.rotateFlip(n2);
                }
                Image image = this.getDefaultPage();
                this.updateDimensions(image.getWidth(), image.getHeight());
            }
            finally {
                this.c(bl2);
            }
        }
    }

    @Override
    public void dither(int n2, int n3, IColorPalette iColorPalette) {
        super.dither(n2, n3, iColorPalette);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void crop(Rectangle rectangle) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.doUseRecursion(6);
            try {
                this.b(bl2);
                this.verifyNotDisposed();
                if (rectangle.isEmpty() || rectangle.getX() < 0 || rectangle.getY() < 0 || rectangle.getWidth() < 0 || rectangle.getHeight() < 0) {
                    throw new ArgumentException("Rectangle incorrect.", "rectangle");
                }
                if (!this.getBounds().contains(rectangle)) {
                    throw new ArgumentException("Rectangle must be contained in the image bounds.", "rectangle");
                }
                Image[] imageArray = this.getPages();
                boolean bl3 = false;
                if (imageArray.length > 0) {
                    int n2 = rectangle.getLeft() & 0xFFFF;
                    int n3 = rectangle.getTop() & 0xFFFF;
                    for (int i2 = imageArray.length - 1; i2 >= 0; --i2) {
                        GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.pI.d.a(imageArray[i2], GifFrameBlock.class));
                        if (gifFrameBlock == null) continue;
                        try {
                            GifGraphicsControlBlock gifGraphicsControlBlock;
                            Rectangle rectangle2 = Rectangle.intersect(rectangle, new Rectangle(gifFrameBlock.getLeft() & 0xFFFF, gifFrameBlock.getTop() & 0xFFFF, gifFrameBlock.getWidth(), gifFrameBlock.getHeight()));
                            if (!rectangle2.isEmpty()) {
                                rectangle2.offset(-(gifFrameBlock.getLeft() & 0xFFFF), -(gifFrameBlock.getTop() & 0xFFFF));
                                gifFrameBlock.crop(rectangle2);
                                if ((gifFrameBlock.getLeft() & 0xFFFF) > (n2 & 0xFFFF)) {
                                    gifFrameBlock.setLeft((gifFrameBlock.getLeft() & 0xFFFF) - (n2 & 0xFFFF) & 0xFFFF);
                                } else {
                                    gifFrameBlock.setLeft(0);
                                }
                                if ((gifFrameBlock.getTop() & 0xFFFF) > (n3 & 0xFFFF)) {
                                    gifFrameBlock.setTop((gifFrameBlock.getTop() & 0xFFFF) - (n3 & 0xFFFF) & 0xFFFF);
                                    continue;
                                }
                                gifFrameBlock.setTop(0);
                                continue;
                            }
                            GifGraphicsControlBlock gifGraphicsControlBlock2 = gifFrameBlock.getControlBlock();
                            int n4 = gifGraphicsControlBlock2 != null ? gifGraphicsControlBlock2.getDelayTime() : 0;
                            this.b(gifFrameBlock);
                            this.b(gifGraphicsControlBlock2);
                            bl3 = true;
                            GifFrameBlock gifFrameBlock2 = null;
                            for (int i3 = i2 - 1; i3 >= 0 && (gifFrameBlock2 = (GifFrameBlock)((Object)com.aspose.imaging.internal.pI.d.a(imageArray[i3], GifFrameBlock.class))) == null; --i3) {
                            }
                            if (gifFrameBlock2 == null || (gifGraphicsControlBlock = gifFrameBlock2.getControlBlock()) == null) continue;
                            gifGraphicsControlBlock.setDelayTime((gifGraphicsControlBlock.getDelayTime() & 0xFFFF) + (n4 & 0xFFFF) & 0xFFFF);
                            continue;
                        }
                        catch (RuntimeException runtimeException) {
                            throw new ImageException(aU.a(new String[]{"Can't crop image. Frame index: ", au.b(i2)}), runtimeException);
                        }
                    }
                    if (bl3) {
                        this.p = null;
                    }
                    this.updateDimensions(rectangle.getWidth(), rectangle.getHeight());
                }
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException("Can't crop image.", runtimeException);
            }
            finally {
                this.c(bl2);
            }
        }
    }

    @Override
    public void adjustGamma(float f2) {
        super.adjustGamma(f2);
    }

    @Override
    public void filter(Rectangle rectangle, FilterOptionsBase filterOptionsBase) {
        super.filter(rectangle, filterOptionsBase);
    }

    @Override
    public void resize(int n2, int n3, ImageResizeSettings imageResizeSettings) {
        super.resize(n2, n3, imageResizeSettings);
    }

    public final void setFrameTime(int n2) {
        for (Image image : this.getPages()) {
            ((GifFrameBlock)image).setFrameTime(n2 & 0xFFFF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustBrightness(int n2) {
        Object object = this.c;
        synchronized (object) {
            super.adjustBrightness(n2);
            try {
                this.b(true);
                this.verifyNotDisposed();
                if (this.getPalette() != null) {
                    int[] nArray = this.getPalette().getArgb32Entries();
                    com.aspose.imaging.internal.eX.g.a(nArray, n2);
                    this.setPalette(new ColorPalette(nArray));
                }
            }
            finally {
                this.c(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustContrast(float f2) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.b(true);
                this.verifyNotDisposed();
                int n2 = 0;
                boolean bl2 = false;
                IGenericEnumerator iGenericEnumerator = this.j.iterator();
                try {
                    while (iGenericEnumerator.hasNext()) {
                        IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                        GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.pI.d.a(iGifBlock, GifFrameBlock.class));
                        if (gifFrameBlock == null) continue;
                        try {
                            com.aspose.imaging.internal.iF.a a2 = new com.aspose.imaging.internal.iF.a(gifFrameBlock);
                            try {
                                IColorPalette[] iColorPaletteArray = new IColorPalette[]{gifFrameBlock.getPalette() != null ? gifFrameBlock.getPalette() : this.getPalette()};
                                int[] nArray = iColorPaletteArray[0].getArgb32Entries();
                                com.aspose.imaging.internal.eX.g.a(nArray, f2);
                                IColorPalette[] iColorPaletteArray2 = new IColorPalette[]{new ColorPalette(nArray)};
                                if (gifFrameBlock.getPalette() != null) {
                                    gifFrameBlock.setPalette(iColorPaletteArray2[0]);
                                    a2.a(new com.aspose.imaging.fileformats.gif.b(this, iColorPaletteArray, iColorPaletteArray2));
                                } else if (!bl2) {
                                    this.setPalette(iColorPaletteArray2[0]);
                                    a2.a(new c(this, iColorPaletteArray, iColorPaletteArray2));
                                    bl2 = true;
                                }
                            }
                            finally {
                                a2.close();
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            throw new ImageException(aU.a(new String[]{"Can't change contrast. Frame index: ", au.b(n2)}), runtimeException);
                        }
                        ++n2;
                    }
                }
                finally {
                    if (com.aspose.imaging.internal.pI.d.a(iGenericEnumerator, IDisposable.class) != false) {
                        ((IDisposable)iGenericEnumerator).dispose();
                    }
                }
            }
            finally {
                this.c(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustGamma(float f2, float f3, float f4) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.b(true);
                this.verifyNotDisposed();
                int n2 = 0;
                boolean bl2 = false;
                IGenericEnumerator iGenericEnumerator = this.j.iterator();
                try {
                    while (iGenericEnumerator.hasNext()) {
                        IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                        GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.pI.d.a(iGifBlock, GifFrameBlock.class));
                        if (gifFrameBlock == null) continue;
                        try {
                            com.aspose.imaging.internal.iF.a a2 = new com.aspose.imaging.internal.iF.a(gifFrameBlock);
                            try {
                                IColorPalette[] iColorPaletteArray = new IColorPalette[]{gifFrameBlock.getPalette() != null ? gifFrameBlock.getPalette() : this.getPalette()};
                                int[] nArray = iColorPaletteArray[0].getArgb32Entries();
                                com.aspose.imaging.internal.eX.g.a(nArray, f2, f3, f4);
                                IColorPalette[] iColorPaletteArray2 = new IColorPalette[]{new ColorPalette(nArray)};
                                if (gifFrameBlock.getPalette() != null) {
                                    gifFrameBlock.setPalette(iColorPaletteArray2[0]);
                                    a2.a(new d(this, iColorPaletteArray, iColorPaletteArray2));
                                } else if (!bl2) {
                                    this.setPalette(iColorPaletteArray2[0]);
                                    a2.a(new e(this, iColorPaletteArray, iColorPaletteArray2));
                                    bl2 = true;
                                }
                            }
                            finally {
                                a2.close();
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            throw new ImageException(aU.a(new String[]{"Can't change gamma. Frame index: ", au.b(n2)}), runtimeException);
                        }
                        ++n2;
                    }
                }
                finally {
                    if (com.aspose.imaging.internal.pI.d.a(iGenericEnumerator, IDisposable.class) != false) {
                        ((IDisposable)iGenericEnumerator).dispose();
                    }
                }
            }
            finally {
                this.c(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grayscale() {
        Object object = this.c;
        synchronized (object) {
            try {
                this.A_();
                this.a(new f(this), "Can't make image grayscale.");
            }
            finally {
                this.e();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binarizeFixed(byte by2) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.A_();
                this.a(new g(this, by2), "Can't make image binarization with predefined threshold.");
            }
            finally {
                this.e();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binarizeOtsu() {
        Object object = this.c;
        synchronized (object) {
            try {
                this.A_();
                this.a(new h(this), "Can't make image binarization with Otsu threshold.");
            }
            finally {
                this.e();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binarizeBradley(double d2) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.b(true);
                com.aspose.imaging.internal.id.d d3 = new com.aspose.imaging.internal.id.d(this, this.getBounds(), d2);
                try {
                    d3.a(new i(this));
                    bb bb2 = bb.a();
                    bb2.a(this, bb2.hashCode() ^ this.hashCode());
                    bb2.a(this, this.getBounds(), d3);
                }
                finally {
                    d3.close();
                }
            }
            finally {
                this.c(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void orderBlocks() {
        Object object = this.c;
        synchronized (object) {
            try {
                this.A_();
                this.s();
            }
            finally {
                this.e();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearBlocks() {
        Object object = this.c;
        synchronized (object) {
            try {
                this.A_();
                this.t();
            }
            finally {
                this.e();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void insertBlock(int n2, IGifBlock iGifBlock) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.A_();
                this.a(n2, iGifBlock);
            }
            finally {
                this.e();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addBlock(IGifBlock iGifBlock) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.A_();
                this.a(iGifBlock);
            }
            finally {
                this.e();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeBlock(IGifBlock iGifBlock) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.A_();
                this.b(iGifBlock);
            }
            finally {
                this.e();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resizeProportional(int n2, int n3, int n4) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.A_();
                this.verifyNotDisposed();
                double d2 = (double)n2 / (double)this.getWidth();
                double d3 = (double)n3 / (double)this.getHeight();
                IGenericEnumerator iGenericEnumerator = this.j.iterator();
                try {
                    while (iGenericEnumerator.hasNext()) {
                        IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                        GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.pI.d.a(iGifBlock, GifFrameBlock.class));
                        if (gifFrameBlock == null) continue;
                        int n5 = com.aspose.imaging.internal.pI.d.e(d2 * (double)gifFrameBlock.getWidth() + 0.5);
                        int n6 = com.aspose.imaging.internal.pI.d.e(d3 * (double)gifFrameBlock.getHeight() + 0.5);
                        gifFrameBlock.resize(n5, n6, n4);
                    }
                }
                finally {
                    if (com.aspose.imaging.internal.pI.d.a(iGenericEnumerator, IDisposable.class) != false) {
                        ((IDisposable)iGenericEnumerator).dispose();
                    }
                }
                this.i.a(n2 & 0xFFFF);
                this.i.b(n3 & 0xFFFF);
            }
            finally {
                this.e();
            }
        }
    }

    public final void s() {
        Object object;
        int n2;
        this.verifyNotDisposed();
        com.aspose.imaging.internal.ky.d d2 = new com.aspose.imaging.internal.ky.d();
        for (n2 = 0; n2 < this.j.size(); ++n2) {
            int n3;
            IGifBlock iGifBlock = this.j.get_Item(n2);
            if (!com.aspose.imaging.internal.pI.d.b((Object)iGifBlock, GifGraphicsControlBlock.class)) continue;
            object = new com.aspose.imaging.internal.ky.d();
            for (n3 = n2 + 1; n3 < this.j.size(); ++n3) {
                IGifBlock iGifBlock2 = this.j.get_Item(n3);
                if (com.aspose.imaging.internal.pI.d.b((Object)iGifBlock2, GifGraphicsControlBlock.class)) {
                    ((com.aspose.imaging.internal.ky.d)object).e(n3);
                    continue;
                }
                if (!com.aspose.imaging.internal.pI.d.b((Object)iGifBlock2, GifFrameBlock.class) && !com.aspose.imaging.internal.pI.d.b((Object)iGifBlock2, GifPlainTextRenderingBlock.class)) continue;
                d2.b(((com.aspose.imaging.internal.ky.d)object).f());
                n2 = n3;
                break;
            }
            if (n3 == this.j.size()) break;
        }
        for (n2 = d2.b() - 1; n2 >= 0; --n2) {
            int n4 = d2.k(n2);
            object = (Image)((Object)com.aspose.imaging.internal.pI.d.a(this.j.get_Item(n4), Image.class));
            if (object != null) {
                ((Image)object).a((Image)null);
            }
            this.j.removeAt(n4);
        }
    }

    public final void t() {
        this.verifyNotDisposed();
        this.j.clear();
        this.k = null;
    }

    public final void a(int n2, IGifBlock iGifBlock) {
        this.verifyNotDisposed();
        if (iGifBlock == null) {
            throw new ArgumentNullException("block");
        }
        Image image = (Image)((Object)com.aspose.imaging.internal.pI.d.a(iGifBlock, Image.class));
        if (image != null && image.getContainer() != null && image.getContainer() != this) {
            throw new ArgumentOutOfRangeException("block", "The block belongs to other image and cannot be inserted into this GIF image.");
        }
        this.j.insertItem(n2, iGifBlock);
        if (image != null) {
            image.a(this);
        }
    }

    private void a(IGifBlock iGifBlock) {
        this.verifyNotDisposed();
        if (iGifBlock == null) {
            throw new ArgumentNullException("block");
        }
        Image image = (Image)((Object)com.aspose.imaging.internal.pI.d.a(iGifBlock, Image.class));
        if (image != null && image.getContainer() != null && image.getContainer() != this) {
            throw new ArgumentOutOfRangeException("block", "The block belongs to other image and cannot be added to this GIF image.");
        }
        this.j.addItem(iGifBlock);
        if (image != null) {
            image.a(this);
        }
    }

    private void b(IGifBlock iGifBlock) {
        this.verifyNotDisposed();
        if (iGifBlock == null) {
            throw new ArgumentNullException("block");
        }
        Image image = (Image)((Object)com.aspose.imaging.internal.pI.d.a(iGifBlock, Image.class));
        if (image != null && image.getContainer() != this) {
            throw new ArgumentOutOfRangeException("block", "The block does not belong to the current GIF image.");
        }
        this.j.removeItem(iGifBlock);
        if (image != null) {
            image.a((Image)null);
        }
        if (this.k == iGifBlock) {
            this.k = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void u() {
        byte[] byArray;
        Object object;
        Object object2;
        List<Object> list = new List<Object>();
        byte[] byArray2 = com.aspose.imaging.internal.lt.l.t().c(n);
        IGenericEnumerator iGenericEnumerator = this.j.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                object2 = (IGifBlock)iGenericEnumerator.next();
                object = (GifApplicationExtensionBlock)((Object)com.aspose.imaging.internal.pI.d.a(object2, GifApplicationExtensionBlock.class));
                if (object == null) continue;
                byArray = ((GifApplicationExtensionBlock)object).getApplicationAuthenticationCode();
                if (!m.equals(((GifApplicationExtensionBlock)object).getApplicationIdentifier()) || byArray.length != n.length() || byArray[0] != byArray2[0] || byArray[1] != byArray2[1] || byArray[2] != byArray2[2]) continue;
                list.addItem(object);
            }
        }
        finally {
            if (com.aspose.imaging.internal.pI.d.a(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        object2 = list.iterator();
        try {
            while (object2.hasNext()) {
                object = (IGifBlock)object2.next();
                this.b((IGifBlock)object);
            }
        }
        finally {
            if (com.aspose.imaging.internal.pI.d.a(object2, IDisposable.class) != false) {
                ((IDisposable)object2).dispose();
            }
        }
        if (this.xmpData != null) {
            object = this.xmpData.b();
            byArray = com.aspose.imaging.internal.lt.l.x().c((String)object);
            GifApplicationExtensionBlock gifApplicationExtensionBlock = new GifApplicationExtensionBlock();
            gifApplicationExtensionBlock.setApplicationIdentifier(m);
            gifApplicationExtensionBlock.setApplicationAuthenticationCode(byArray2);
            gifApplicationExtensionBlock.setApplicationData(byArray);
            this.a(gifApplicationExtensionBlock);
        }
    }

    private static void a(int[] nArray, byte by2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            int n3 = com.aspose.imaging.internal.pI.d.b(0.2126 * (double)(n2 >> 16 & 0xFF) + 0.7152 * (double)(n2 >> 8 & 0xFF) + 0.0722 * (double)(n2 & 0xFF));
            n3 = (n3 & 0xFF) > (by2 & 0xFF) ? -1 : 0;
            nArray[i2] = n2 & 0xFF000000 | (n3 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n3 & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(b b2, String string) {
        if (b2 == null) {
            return;
        }
        this.verifyNotDisposed();
        int n2 = 0;
        boolean bl2 = false;
        IGenericEnumerator iGenericEnumerator = this.j.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.pI.d.a(iGifBlock, GifFrameBlock.class));
                if (gifFrameBlock == null || gifFrameBlock.getPalette() == null && bl2) continue;
                try {
                    IColorPalette iColorPalette;
                    int[] nArray;
                    if (gifFrameBlock.getPalette() != null) {
                        nArray = gifFrameBlock.getPalette().getArgb32Entries();
                        iColorPalette = gifFrameBlock.getPalette();
                    } else {
                        nArray = this.getPalette().getArgb32Entries();
                        iColorPalette = this.getPalette();
                    }
                    int[][] nArrayArray = new int[][]{nArray};
                    b2.a(nArrayArray, iColorPalette);
                    nArray = nArrayArray[0];
                    if (gifFrameBlock.getPalette() != null) {
                        gifFrameBlock.setPalette(new ColorPalette(nArray));
                    } else {
                        this.setPalette(new ColorPalette(nArray));
                        bl2 = true;
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw new ImageException(aU.a(new String[]{string, " Frame index: ", au.b(n2)}), runtimeException);
                }
                ++n2;
            }
        }
        finally {
            if (com.aspose.imaging.internal.pI.d.a(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    @Override
    protected boolean doUseRecursion(int n2) {
        if (n2 == 2 || n2 == 1 || n2 == 13) {
            return true;
        }
        return super.doUseRecursion(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveData(Stream stream) {
        this.verifyNotDisposed();
        this.updateMetadata();
        StreamContainer streamContainer = new StreamContainer(stream);
        try {
            try {
                this.i.a(streamContainer);
                if (this.getPalette() != null) {
                    com.aspose.imaging.internal.eJ.c.a(streamContainer, this.getPalette());
                }
                this.u();
                IGenericEnumerator iGenericEnumerator = this.j.iterator();
                try {
                    while (iGenericEnumerator.hasNext()) {
                        IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                        iGifBlock.a(streamContainer.a());
                    }
                }
                finally {
                    if (com.aspose.imaging.internal.pI.d.a(iGenericEnumerator, IDisposable.class) != false) {
                        ((IDisposable)iGenericEnumerator).dispose();
                    }
                }
                if (this.l) {
                    streamContainer.writeByte((byte)59);
                }
                streamContainer.setLength(streamContainer.getPosition());
            }
            finally {
                bW.a(streamContainer);
            }
        }
        finally {
            streamContainer.close();
        }
    }

    @Override
    public void rotate(float f2, boolean bl2, Color color) {
        super.rotate(f2, bl2, color);
        this.updateDimensions(this.k.getWidth(), this.k.getHeight());
    }

    @Override
    protected void updateDimensions(int n2, int n3) {
        this.i.a(n2 & 0xFFFF);
        this.i.b(n3 & 0xFFFF);
    }

    @Override
    protected void onPaletteChanging(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
        if (iColorPalette2 != null && iColorPalette2.getEntriesCount() != 2 && iColorPalette2.getEntriesCount() != 4 && iColorPalette2.getEntriesCount() != 8 && iColorPalette2.getEntriesCount() != 16 && iColorPalette2.getEntriesCount() != 32 && iColorPalette2.getEntriesCount() != 64 && iColorPalette2.getEntriesCount() != 128 && iColorPalette2.getEntriesCount() != 256) {
            throw new GifImageException("The color palette cannot be changed as palette specified should contain entries count equal to power of 2. Minimal palette size is 2, maximal is 256.");
        }
        super.onPaletteChanging(iColorPalette, iColorPalette2);
    }

    @Override
    protected void onPaletteChanged(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
        this.i.a(iColorPalette2);
        super.onPaletteChanged(iColorPalette, iColorPalette2);
    }

    public static GifImage a(com.aspose.imaging.internal.eJ.b b2, IGifBlock[] iGifBlockArray, IColorPalette iColorPalette, boolean bl2, GifFrameBlock gifFrameBlock) {
        return new GifImage(b2, iGifBlockArray, iColorPalette, bl2, gifFrameBlock);
    }

    public static GifImage a(com.aspose.imaging.internal.eJ.b b2, IGifBlock[] iGifBlockArray, IColorPalette iColorPalette, boolean bl2, GifFrameBlock gifFrameBlock, int n2, GifOptions gifOptions) {
        return new GifImage(b2, iGifBlockArray, iColorPalette, bl2, gifFrameBlock, n2, gifOptions);
    }

    private static void a(IColorPalette iColorPalette, IColorPalette iColorPalette2, int[] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = iColorPalette2.getArgb32Entries()[iColorPalette.getNearestColorIndex(nArray[i2])];
        }
    }

    static /* synthetic */ void access$000(IColorPalette iColorPalette, IColorPalette iColorPalette2, int[] nArray) {
        GifImage.a(iColorPalette, iColorPalette2, nArray);
    }

    static /* synthetic */ void access$100(int[] nArray, byte by2) {
        GifImage.a(nArray, by2);
    }

    static /* synthetic */ void access$200(GifImage gifImage, b b2, String string) {
        gifImage.a(b2, string);
    }

    private static class a
    implements IRasterImageArgb32PixelLoader {
        private final WeakReference<GifImage> a;

        public a(GifImage gifImage) {
            this.a = new WeakReference<GifImage>(gifImage);
        }

        @Override
        public final boolean isRawDataAvailable() {
            GifImage gifImage = (GifImage)this.a.get();
            if (gifImage != null) {
                return gifImage.k.isRawDataAvailable();
            }
            return false;
        }

        @Override
        public final RawDataSettings getRawDataSettings() {
            GifImage gifImage = (GifImage)this.a.get();
            if (gifImage != null) {
                return gifImage.k.getRawDataSettings();
            }
            return null;
        }

        @Override
        public final void loadPartialArgb32Pixels(Rectangle rectangle, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
            GifImage gifImage = (GifImage)this.a.get();
            if (gifImage == null || gifImage.k == null) {
                throw new GifImageException("Cannot load pixels as no active GIF frame exists. Select an active frame first.");
            }
            gifImage.k.loadPartialArgb32Pixels(rectangle, iPartialArgb32PixelLoader);
        }

        @Override
        public final void loadRawData(Rectangle rectangle, RawDataSettings rawDataSettings, IPartialRawDataLoader iPartialRawDataLoader) {
            GifImage gifImage = (GifImage)this.a.get();
            if (gifImage != null) {
                gifImage.k.loadRawData(rectangle, rawDataSettings, iPartialRawDataLoader);
            }
        }
    }

    static interface b {
        public void a(int[][] var1, IColorPalette var2);
    }
}

