/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.brushes;

import com.aspose.imaging.Image;
import com.aspose.imaging.ImageAttributes;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.RectangleF;
import com.aspose.imaging.brushes.TransformBrush;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.lh.G;
import com.aspose.imaging.internal.lh.M;
import com.aspose.imaging.system.SerializableAttribute;

@SerializableAttribute
public final class TextureBrush
extends TransformBrush {
    private final RectangleF a = new RectangleF();
    private Image b;
    private ImageAttributes c;

    public TextureBrush(Image image) {
        this(image, 0);
    }

    public TextureBrush(Image image, int n2) {
        this(image, n2, new RectangleF(0.0f, 0.0f, 2.1474836E9f, 2.1474836E9f));
    }

    public TextureBrush(Image image, int n2, RectangleF rectangleF) {
        this(image, rectangleF, n2, new ImageAttributes());
    }

    public TextureBrush(Image image, int n2, Rectangle rectangle) {
        this(image, n2, RectangleF.to_RectangleF(rectangle));
    }

    public TextureBrush(Image image, RectangleF rectangleF) {
        this(image, 0, rectangleF);
    }

    public TextureBrush(Image image, RectangleF rectangleF, ImageAttributes imageAttributes) {
        this(image, rectangleF, 0, imageAttributes);
    }

    public TextureBrush(Image image, Rectangle rectangle) {
        this(image, RectangleF.to_RectangleF(rectangle));
    }

    public TextureBrush(Image image, Rectangle rectangle, ImageAttributes imageAttributes) {
        this(image, RectangleF.to_RectangleF(rectangle), imageAttributes);
    }

    private TextureBrush(G g2, M m2) {
    }

    private TextureBrush(Image image, RectangleF rectangleF, int n2, ImageAttributes imageAttributes) {
        if (image == null) {
            throw new ArgumentNullException("image");
        }
        if (imageAttributes == null) {
            throw new ArgumentNullException("imageAttributes");
        }
        RectangleF rectangleF2 = RectangleF.intersect(RectangleF.to_RectangleF(image.getBounds()), rectangleF);
        if (rectangleF2.getWidth() == 0.0f || rectangleF2.getHeight() == 0.0f) {
            throw new ArgumentException("The destination rectangle does not intersect the image rectangle");
        }
        this.b = image;
        rectangleF2.CloneTo(this.a);
        this.c = imageAttributes;
        this.setWrapMode(n2);
    }

    public Image getImage() {
        return this.b;
    }

    public ImageAttributes getImageAttributes() {
        return this.c;
    }

    public RectangleF getImageRectangle() {
        return this.a;
    }

    @Override
    protected void releaseManagedResources() {
        Image image = this.b;
        if (image != null) {
            image.dispose();
        }
        super.releaseManagedResources();
    }
}

