/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.Color;
import com.aspose.imaging.DataStreamSupporter;
import com.aspose.imaging.FileStreamContainer;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IImageCreator;
import com.aspose.imaging.IImageExporter;
import com.aspose.imaging.IImageLoaderDescriptor;
import com.aspose.imaging.IObjectWithBounds;
import com.aspose.imaging.ImageCreatorsRegistry;
import com.aspose.imaging.ImageExportersRegistry;
import com.aspose.imaging.ImageLoadersRegistry;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.ImageResizeSettings;
import com.aspose.imaging.LoadOptions;
import com.aspose.imaging.Point;
import com.aspose.imaging.ProgressEventHandler;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.Size;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.coreexceptions.ImageCreateException;
import com.aspose.imaging.coreexceptions.ImageException;
import com.aspose.imaging.coreexceptions.ImageLoadException;
import com.aspose.imaging.coreexceptions.ImageSaveException;
import com.aspose.imaging.coreexceptions.OperationInterruptedException;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.at.aB;
import com.aspose.imaging.internal.at.aY;
import com.aspose.imaging.internal.at.bV;
import com.aspose.imaging.internal.at.bW;
import com.aspose.imaging.internal.at.d;
import com.aspose.imaging.internal.iB.g;
import com.aspose.imaging.internal.iB.i;
import com.aspose.imaging.internal.iM.b;
import com.aspose.imaging.internal.iT.a;
import com.aspose.imaging.internal.jV.l;
import com.aspose.imaging.internal.jX.D;
import com.aspose.imaging.internal.jo.c;
import com.aspose.imaging.internal.kE.aC;
import com.aspose.imaging.internal.kE.aU;
import com.aspose.imaging.internal.kE.bB;
import com.aspose.imaging.internal.kT.k;
import com.aspose.imaging.internal.ke.u;
import com.aspose.imaging.internal.ke.w;
import com.aspose.imaging.m;
import com.aspose.imaging.multithreading.InterruptMonitor;
import com.aspose.imaging.o;
import com.aspose.imaging.progressmanagement.EventType;
import com.aspose.imaging.progressmanagement.ProgressEventHandlerInfo;
import com.aspose.imaging.q;
import com.aspose.imaging.r;
import com.aspose.imaging.sources.StreamSource;
import com.aspose.imaging.system.Enum;
import com.aspose.imaging.system.Event;
import com.aspose.imaging.system.io.FileStream;
import com.aspose.imaging.system.io.Stream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicReference;

public abstract class Image
extends DataStreamSupporter
implements IObjectWithBounds,
b,
com.aspose.imaging.internal.iM.c {
    private static d i;
    public static final Event<d> e;
    private static com.aspose.imaging.internal.at.b j;
    public static final Event<com.aspose.imaging.internal.at.b> f;
    private WeakReference<Image> k = new WeakReference<Object>(null);
    private IColorPalette l;
    private Object m;
    private boolean n = false;
    private boolean o;
    private InterruptMonitor p;
    private final AtomicReference<i> q = new AtomicReference<Object>(null);
    private ProgressEventHandlerInfo r;
    private u s;
    private boolean t = false;
    private final Color u = Color.getWhite();
    protected StreamContainer g;
    public l h;
    private static final String v = "Cannot open an image. The image file format may be not supported at the moment.";
    private boolean w;

    protected Image() {
    }

    protected Image(IColorPalette iColorPalette) {
        this.l = iColorPalette;
    }

    public static boolean canLoad(String string) {
        return Image.canLoad(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canLoad(String string, LoadOptions loadOptions) {
        Object object = SyncOperation;
        synchronized (object) {
            boolean bl2;
            FileStream fileStream = com.aspose.imaging.internal.kT.k.a(string, 3, 3, 3);
            try {
                bl2 = Image.a((Stream)fileStream, loadOptions);
            }
            catch (Throwable throwable) {
                fileStream.dispose();
                throw throwable;
            }
            fileStream.dispose();
            return bl2;
        }
    }

    public static boolean canLoad(InputStream inputStream) {
        return Image.c(Stream.fromJava(inputStream));
    }

    public static boolean c(Stream stream) {
        return Image.a(stream, null);
    }

    public static boolean canLoad(InputStream inputStream, LoadOptions loadOptions) {
        return Image.a(Stream.fromJava(inputStream), loadOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean a(Stream stream, LoadOptions loadOptions) {
        boolean bl2;
        bV bV2 = bW.a().a(stream);
        try {
            bl2 = ImageLoadersRegistry.a(bV2, loadOptions) != null;
        }
        finally {
            bW.a().a(bV2);
        }
        return bl2;
    }

    public static Image create(ImageOptionsBase imageOptionsBase, int n2, int n3) {
        if (imageOptionsBase == null) {
            throw new ArgumentNullException("imageOptions");
        }
        if (imageOptionsBase.getSource() == null) {
            throw new ArgumentNullException("imageOptions", "Please specify source for the image creation.");
        }
        if (n2 <= 0) {
            throw new ArgumentOutOfRangeException("width", "Expected positive width value.");
        }
        if (n3 <= 0) {
            throw new ArgumentOutOfRangeException("height", "Expected positive height value.");
        }
        return Image.a(imageOptionsBase, n2, n3);
    }

    public static Image create(Image[] imageArray) {
        return new aY(imageArray, false);
    }

    public static Image create(Image[] imageArray, boolean bl2) {
        return new aY(imageArray, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFileFormat(String string) {
        FileStream fileStream = com.aspose.imaging.internal.kT.k.a(string, 3, 1, 1);
        bV bV2 = bW.a().a(fileStream, false, true);
        Object object = bV2.getSyncRoot();
        synchronized (object) {
            long l2;
            block7: {
                try {
                    l2 = Image.f(bV2);
                    if (bV2.a() > 0) break block7;
                    bV2.dispose();
                }
                catch (Throwable throwable) {
                    if (bV2.a() <= 0) {
                        bV2.dispose();
                    }
                    throw throwable;
                }
            }
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image load(String string, LoadOptions loadOptions) {
        FileStreamContainer fileStreamContainer = FileStreamContainer.openFileStream(string, true);
        boolean bl2 = true;
        try {
            Image image = Image.a(fileStreamContainer, loadOptions);
            bl2 = false;
            Image image2 = image;
            return image2;
        }
        finally {
            if (bl2) {
                fileStreamContainer.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image load(String string) {
        FileStreamContainer fileStreamContainer = FileStreamContainer.openFileStream(string, true);
        boolean bl2 = true;
        try {
            Image image = Image.a(fileStreamContainer, null);
            bl2 = false;
            Image image2 = image;
            return image2;
        }
        finally {
            if (bl2) {
                fileStreamContainer.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image load(RandomAccessFile randomAccessFile, LoadOptions loadOptions) {
        a a2 = new a(randomAccessFile);
        boolean bl2 = true;
        try {
            Image image = Image.b(a2, loadOptions);
            bl2 = false;
            Image image2 = image;
            return image2;
        }
        finally {
            if (bl2) {
                a2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image load(RandomAccessFile randomAccessFile) {
        a a2 = new a(randomAccessFile);
        boolean bl2 = true;
        try {
            Image image = Image.b(a2, null);
            bl2 = false;
            Image image2 = image;
            return image2;
        }
        finally {
            if (bl2) {
                a2.close();
            }
        }
    }

    public static Image load(InputStream inputStream, LoadOptions loadOptions) {
        return Image.b(Stream.fromJava(inputStream), loadOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image b(Stream stream, LoadOptions loadOptions) {
        StreamContainer streamContainer = new StreamContainer(stream, 0L, false);
        boolean bl2 = true;
        try {
            Image image = Image.a(streamContainer, loadOptions);
            bl2 = false;
            Image image2 = image;
            return image2;
        }
        finally {
            if (bl2) {
                streamContainer.dispose();
            }
        }
    }

    public static Image load(InputStream inputStream) {
        return Image.d(Stream.fromJava(inputStream));
    }

    public static Image d(Stream stream) {
        return Image.b(stream, null);
    }

    public static Image a(Stream stream, long l2, LoadOptions loadOptions) {
        StreamContainer streamContainer = new StreamContainer(stream, l2, false);
        return Image.a(streamContainer, loadOptions);
    }

    public static Image a(Stream stream, long l2) {
        return Image.a(stream, l2, null);
    }

    public static Image e(Stream stream) {
        return Image.a(stream, 0L, null);
    }

    public static long getFileFormat(InputStream inputStream) {
        return Image.f(Stream.fromJava(inputStream));
    }

    public static long f(Stream stream) {
        long l2 = 0L;
        IImageLoaderDescriptor iImageLoaderDescriptor = ImageLoadersRegistry.a(stream, null);
        if (iImageLoaderDescriptor != null) {
            l2 = iImageLoaderDescriptor.getSupportedFormat();
        }
        return l2;
    }

    public static Rectangle getFittingRectangle(Rectangle rectangle, int n2, int n3) {
        Rectangle rectangle2 = Rectangle.intersect(rectangle, new Rectangle(new Point(), new Size(bB.a(n2), bB.a(n3))));
        if (rectangle2.getWidth() <= 0 || rectangle2.getHeight() <= 0) {
            throw new ArgumentException("The rectangle has no common processing area. Cannot proceed.");
        }
        return rectangle2;
    }

    public static Rectangle getFittingRectangle(Rectangle rectangle, int[] nArray, int n2, int n3) {
        if (nArray == null) {
            throw new ArgumentNullException("pixels");
        }
        Rectangle rectangle2 = Image.getFittingRectangle(rectangle, n2, n3);
        if (nArray.length < rectangle2.getWidth() * rectangle2.getHeight()) {
            String string = aU.a("The passed rectangle does not correspond to pixels array size. Expected: {0} pixels, passed: {1} pixels.", new Object[]{rectangle2.getWidth() * rectangle2.getHeight(), nArray.length});
            throw new ImageException(string);
        }
        return rectangle2;
    }

    public static int getProportionalWidth(int n2, int n3, int n4) {
        double d2 = (double)n4 / (double)n3;
        return com.aspose.imaging.internal.pI.d.e(d2 * (double)n2 + 0.5);
    }

    public static int getProportionalHeight(int n2, int n3, int n4) {
        double d2 = (double)n4 / (double)n2;
        return com.aspose.imaging.internal.pI.d.e(d2 * (double)n3 + 0.5);
    }

    public abstract D a(ImageOptionsBase var1, int var2, Rectangle var3);

    protected static void doAfterLoad(long[] lArray, InputStream inputStream) {
        Image.a(lArray, Stream.fromJava(inputStream));
    }

    protected static void a(long[] lArray, Stream stream) {
        if (i != null) {
            i.a(lArray, stream);
        }
    }

    protected static void doAfterCreate(long[] lArray, long l2) {
        if (j != null) {
            j.a(lArray, l2);
        }
    }

    private static void a(ProgressEventHandlerInfo progressEventHandlerInfo, EventType eventType) {
        if (progressEventHandlerInfo != null) {
            progressEventHandlerInfo.a(eventType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static Image a(ImageOptionsBase imageOptionsBase, int n2, int n3) {
        Object object;
        StreamSource streamSource = (StreamSource)((Object)com.aspose.imaging.internal.pI.d.a(imageOptionsBase.getSource(), StreamSource.class));
        Stream stream = streamSource != null ? streamSource.getStream() : null;
        Object object2 = object = bV.a(stream, stream == null ? new Object() : stream);
        synchronized (object2) {
            ProgressEventHandlerInfo progressEventHandlerInfo = null;
            if (imageOptionsBase.getProgressEventHandler() != null) {
                progressEventHandlerInfo = ProgressEventHandlerInfo.a(4);
                progressEventHandlerInfo.a(imageOptionsBase.getProgressEventHandler());
            }
            Image.a(progressEventHandlerInfo, EventType.Initialization);
            StreamContainer streamContainer = imageOptionsBase.getSource().getStreamContainer();
            boolean bl2 = true;
            try {
                Object object3;
                block17: {
                    IImageCreator iImageCreator = ImageCreatorsRegistry.createFirstSupportedCreator(imageOptionsBase);
                    if (iImageCreator == null) {
                        throw new ImageLoadException("Cannot create a new image. The image file format may be not supported at the moment.");
                    }
                    Image.a(progressEventHandlerInfo, EventType.PreProcessing);
                    Image image = iImageCreator.create(streamContainer, imageOptionsBase, n2, n3);
                    try {
                        image.r = progressEventHandlerInfo;
                        Image.a(progressEventHandlerInfo, EventType.Processing);
                        image.a(streamContainer);
                        image.a(com.aspose.imaging.internal.iB.g.a(imageOptionsBase), true);
                        Image.a(progressEventHandlerInfo, EventType.Finalization);
                        if (!imageOptionsBase.a()) {
                            object3 = new long[]{image.d};
                            Image.doAfterCreate((long[])object3, (long)image.getWidth() * (long)image.getHeight());
                            image.d = (long)object3[0];
                        }
                        bl2 = false;
                        object3 = image;
                        if (!bl2) break block17;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (bl2) {
                                image.close();
                            }
                            throw throwable;
                        }
                        catch (RuntimeException runtimeException) {
                            throw new ImageCreateException("Image creation failed.", runtimeException);
                        }
                        catch (Error error) {
                            throw new ImageCreateException("Image creation failed.", error);
                        }
                    }
                    image.close();
                }
                return object3;
            }
            finally {
                if (bl2) {
                    streamContainer.close();
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static Image a(StreamContainer var0, LoadOptions var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public abstract int getBitsPerPixel();

    @Override
    public Rectangle getBounds() {
        this.verifyNotDisposed();
        return new Rectangle(Point.getEmpty(), this.getSize());
    }

    public Image getContainer() {
        return (Image)this.k.get();
    }

    @Override
    public abstract int getHeight();

    public IColorPalette getPalette() {
        return this.l;
    }

    public void setPalette(IColorPalette iColorPalette) {
        if (this.l != iColorPalette) {
            IColorPalette iColorPalette2 = this.l;
            this.onPaletteChanging(iColorPalette2, iColorPalette);
            this.l = iColorPalette;
            this.onPaletteChanged(iColorPalette2, iColorPalette);
        }
    }

    public boolean isUsePalette() {
        return false;
    }

    @Override
    public Size getSize() {
        this.verifyNotDisposed();
        return new Size(this.getWidth(), this.getHeight());
    }

    @Override
    public abstract int getWidth();

    public InterruptMonitor getInterruptMonitor() {
        return this.p;
    }

    public void setInterruptMonitor(InterruptMonitor interruptMonitor) {
        this.p = interruptMonitor;
    }

    public final int getBufferSizeHint() {
        return this.h().b();
    }

    public final void setBufferSizeHint(int n2) {
        i i2 = this.h();
        if (!aC.a(i2, com.aspose.imaging.internal.iB.i.a)) {
            i2.c(n2);
        }
    }

    public boolean isAutoAdjustPalette() {
        return this.o;
    }

    public void setAutoAdjustPalette(boolean bl2) {
        this.o = bl2;
    }

    public boolean hasBackgroundColor() {
        return this.t;
    }

    public long getFileFormat() {
        return 0L;
    }

    public Color getBackgroundColor() {
        return this.u;
    }

    public void setBackgroundColor(boolean bl2) {
        this.t = bl2;
    }

    public void setBackgroundColor(Color color) {
        color.CloneTo(this.u);
    }

    public boolean f() {
        return this.n;
    }

    public void d(boolean bl2) {
        this.n = bl2;
    }

    public final l g() {
        if (this.h == null) {
            this.h = new l();
        }
        return this.h;
    }

    public i h() {
        i i2 = this.q.get();
        return i2 != null ? i2 : com.aspose.imaging.internal.iB.i.a;
    }

    @Override
    public boolean z_() {
        return this.h().c();
    }

    @Override
    @com.aspose.imaging.internal.pI.g
    public final ProgressEventHandler getProgressEventHandler() {
        if (this.r == null) {
            return null;
        }
        return this.r.a();
    }

    @Override
    @com.aspose.imaging.internal.pI.g
    public final ProgressEventHandlerInfo getProgressEventHandlerInfo() {
        return this.r;
    }

    public boolean canSave(ImageOptionsBase imageOptionsBase) {
        if (imageOptionsBase == null) {
            throw new ArgumentNullException("options");
        }
        this.verifyNotDisposed();
        return ImageExportersRegistry.getFirstSupportedDescriptor(this, imageOptionsBase) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int n2, int n3) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.b(true);
                this.resize(n2, n3, 7);
            }
            finally {
                this.c(true);
            }
        }
    }

    public abstract void resize(int var1, int var2, int var3);

    public abstract void resize(int var1, int var2, ImageResizeSettings var3);

    public ImageOptionsBase getDefaultOptions(Object[] objectArray) {
        return null;
    }

    public ImageOptionsBase getOriginalOptions() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeWidthProportionally(int n2) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.doUseRecursion(1);
            try {
                this.b(bl2);
                this.resizeWidthProportionally(n2, 7);
            }
            finally {
                this.c(bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeHeightProportionally(int n2) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.doUseRecursion(2);
            try {
                this.b(bl2);
                this.resizeHeightProportionally(n2, 7);
            }
            finally {
                this.c(bl2);
            }
        }
    }

    public void resizeWidthProportionally(int n2, int n3) {
        int n4 = Image.getProportionalHeight(this.getWidth(), this.getHeight(), n2);
        this.resize(n2, n4, n3);
    }

    public void resizeHeightProportionally(int n2, int n3) {
        int n4 = Image.getProportionalWidth(this.getWidth(), this.getHeight(), n2);
        this.resize(n4, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeWidthProportionally(int n2, ImageResizeSettings imageResizeSettings) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.b(true);
                int n3 = Image.getProportionalHeight(this.getWidth(), this.getHeight(), n2);
                this.resize(n2, n3, imageResizeSettings);
            }
            finally {
                this.c(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeHeightProportionally(int n2, ImageResizeSettings imageResizeSettings) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.b(true);
                int n3 = Image.getProportionalWidth(this.getWidth(), this.getHeight(), n2);
                this.resize(n3, n2, imageResizeSettings);
            }
            finally {
                this.c(true);
            }
        }
    }

    public abstract void rotateFlip(int var1);

    @Override
    public final void save() {
        if (this.k.get() != null) {
            throw new FrameworkException("The result of this method is unpredictable since the current image has Container defined. Use the parent Container's Save() method instead.");
        }
        super.save();
        if (this.g != null) {
            this.g.setPosition(0L);
            Stream stream = this.getDataStreamContainer().a();
            stream.setPosition(0L);
            com.aspose.imaging.internal.jo.c.a(stream, this.g.a());
        }
    }

    public void save(String string, ImageOptionsBase imageOptionsBase) {
        this.save(string, imageOptionsBase, Rectangle.getEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String string, ImageOptionsBase imageOptionsBase, Rectangle rectangle) {
        this.verifyNotDisposed();
        if (imageOptionsBase == null) {
            throw new ArgumentNullException("options");
        }
        try {
            FileStream fileStream = com.aspose.imaging.internal.kT.k.b(string);
            try {
                this.a(fileStream, imageOptionsBase, rectangle);
                fileStream.flush();
            }
            finally {
                fileStream.dispose();
            }
        }
        catch (OperationInterruptedException operationInterruptedException) {
            throw operationInterruptedException;
        }
        catch (Error error) {
            throw new ImageLoadException("Image saving failed.", error);
        }
        catch (ImageSaveException imageSaveException) {
            throw imageSaveException;
        }
        catch (RuntimeException runtimeException) {
            throw new ImageSaveException("Image saving failed.", runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(RandomAccessFile randomAccessFile, ImageOptionsBase imageOptionsBase) {
        a a2 = new a(randomAccessFile);
        try {
            this.a(a2, imageOptionsBase, Rectangle.getEmpty());
        }
        finally {
            a2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(RandomAccessFile randomAccessFile, ImageOptionsBase imageOptionsBase, Rectangle rectangle) {
        a a2 = new a(randomAccessFile);
        try {
            this.a(a2, imageOptionsBase, rectangle);
        }
        finally {
            a2.dispose();
        }
    }

    public void save(OutputStream outputStream, ImageOptionsBase imageOptionsBase) {
        if (outputStream instanceof com.aspose.imaging.internal.oW.d) {
            this.a(((com.aspose.imaging.internal.oW.d)outputStream).a(), imageOptionsBase, Rectangle.getEmpty());
        } else {
            com.aspose.imaging.internal.pH.c.a(new q(this, outputStream, imageOptionsBase));
        }
    }

    public void save(OutputStream outputStream, ImageOptionsBase imageOptionsBase, Rectangle rectangle) {
        if (outputStream instanceof com.aspose.imaging.internal.oW.d) {
            this.a(((com.aspose.imaging.internal.oW.d)outputStream).a(), imageOptionsBase, rectangle);
        } else {
            com.aspose.imaging.internal.pH.c.a(new r(this, outputStream, imageOptionsBase, rectangle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(Stream stream, ImageOptionsBase imageOptionsBase, Rectangle rectangle) {
        this.verifyNotDisposed();
        if (imageOptionsBase == null) {
            throw new ArgumentNullException("optionsBase");
        }
        if (!(rectangle.isEmpty() || rectangle.getWidth() > 0 && rectangle.getHeight() > 0)) {
            throw new ArgumentOutOfRangeException("boundsRectangle", "Rectangle should have positive width and height");
        }
        boolean bl2 = false;
        try {
            Object object;
            Object object2 = this.c;
            synchronized (object2) {
                this.isRecursiveCall = bl2 = this.isSameSourceStream_internalized(stream);
                this.MutuallyExclusiveOperationIsNotRunningEvent_internalized.waitOne();
                if (imageOptionsBase.getProgressEventHandler() != null) {
                    this.r = ProgressEventHandlerInfo.a(4);
                    this.r.a(imageOptionsBase.getProgressEventHandler());
                } else if (this.r != null) {
                    this.r.b(this.r.getMaxValue() + 4);
                    imageOptionsBase.setProgressEventHandler(this.r.a());
                }
                object = this.SyncNonExclusiveOperation_internalized;
                synchronized (object) {
                    if (this.NonExclusiveRunningOperationsCount_internalized.incrementAndGet() > 0) {
                        this.NonMutuallyExclusiveOperationIsNotRunningEvent_internalized.reset();
                    }
                }
            }
            Image.a(this.r, EventType.Initialization);
            object2 = ImageExportersRegistry.createFirstSupportedExporter(this, imageOptionsBase);
            if (object2 == null) {
                object = this.getCanNotSaveMessage(imageOptionsBase);
                throw new ArgumentException((String)object, "optionsBase");
            }
            object = this.a(imageOptionsBase, rectangle, (IImageExporter)object2);
            Image image = ((aB)object).c();
            bV bV2 = null;
            try {
                Image.a(this.r, EventType.PreProcessing);
                bV2 = bW.a().a(stream);
                Object object3 = bV2.getSyncRoot();
                synchronized (object3) {
                    bV2.setPosition(0L);
                    image.tryCacheImage(bV2);
                    Image.a(this.r, EventType.Processing);
                    object2.export(image, bV2.toOutputStream(), imageOptionsBase, rectangle);
                    Image.a(this.r, EventType.Finalization);
                    this.b(bV2);
                }
                bW.a().a(bV2);
                ((aB)object).a();
            }
            catch (Throwable throwable) {
                bW.a().a(bV2);
                ((aB)object).a();
                throw throwable;
            }
        }
        catch (OperationInterruptedException operationInterruptedException) {
            throw operationInterruptedException;
        }
        catch (RuntimeException runtimeException) {
            throw new ImageSaveException("Image export failed.", runtimeException);
        }
        finally {
            Object object = this.SyncNonExclusiveOperation_internalized;
            synchronized (object) {
                if (bl2) {
                    this.isRecursiveCall = false;
                }
                if (this.NonExclusiveRunningOperationsCount_internalized.decrementAndGet() <= 0) {
                    this.NonMutuallyExclusiveOperationIsNotRunningEvent_internalized.set();
                }
            }
        }
    }

    public abstract void setPalette(IColorPalette var1, boolean var2);

    public Object i() {
        return this.m;
    }

    public void a(Object object) {
        this.m = object;
    }

    public void a(Image image) {
        this.k = new WeakReference<Image>(image);
        this.j();
    }

    public final void a(EventType eventType) {
        if (this.r != null) {
            this.r.c(this.r.getValue() + 1);
            this.r.a(eventType, this.r.getValue());
        }
    }

    public final void a(int n2) {
        if (this.r != null) {
            this.r.b(this.r.getMaxValue() + n2);
        }
    }

    public void j() {
    }

    public void a(i i2, boolean bl2) {
        if (this.w) {
            i i3 = this.q.getAndSet(aC.a(i2, com.aspose.imaging.internal.iB.i.a) ? null : i2);
            if (i3 != null && !aC.a(i3, i2)) {
                i3.dispose();
            }
        } else {
            this.q.set(aC.a(i2, com.aspose.imaging.internal.iB.i.a) ? null : i2);
        }
        this.w = bl2;
    }

    protected boolean doUseRecursion(int n2) {
        return false;
    }

    protected String getCanNotSaveMessage(ImageOptionsBase imageOptionsBase) {
        return "Cannot save to the specified format as it is not supported at the moment";
    }

    public Image k() {
        return this;
    }

    public boolean l() {
        Image image = (Image)this.k.get();
        return this.o || image != null && image.l();
    }

    public final boolean m() {
        return this.s != null;
    }

    protected Rectangle getFitRectangle(Rectangle rectangle) {
        return Image.getFittingRectangle(rectangle, this.getWidth(), this.getHeight());
    }

    protected Image getImage2Export(ImageOptionsBase imageOptionsBase, Rectangle rectangle, IImageExporter iImageExporter) {
        return this;
    }

    public aB a(ImageOptionsBase imageOptionsBase, Rectangle rectangle, IImageExporter iImageExporter) {
        return new aB(this.getImage2Export(imageOptionsBase, rectangle, iImageExporter), false);
    }

    protected Rectangle getFitRectangle(Rectangle rectangle, int[] nArray) {
        return Image.getFittingRectangle(rectangle, nArray, this.getWidth(), this.getHeight());
    }

    protected void onPaletteChanged(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
    }

    protected void onPaletteChanging(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
    }

    @Override
    protected void releaseManagedResources() {
        this.l = null;
        i i2 = this.q.getAndSet(null);
        if (i2 != null && this.w) {
            i2.dispose();
        }
        if (this.g != null) {
            try {
                this.g.a().dispose();
                this.g.dispose();
                Stream stream = this.getDataStreamContainer().a();
                if (stream instanceof bV) {
                    bV bV2 = (bV)stream;
                    String string = ((FileStream)bV2.b()).getName();
                    stream.dispose();
                    this.getDataStreamContainer().dispose();
                    com.aspose.imaging.internal.kT.k.d(string);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.h != null) {
            this.h.dispose();
        }
        if (this.s != null) {
            com.aspose.imaging.internal.ke.w.b().b(this.s);
        }
        super.releaseManagedResources();
    }

    static /* synthetic */ d access$002(d d2) {
        i = d2;
        return i;
    }

    static /* synthetic */ com.aspose.imaging.internal.at.b access$202(com.aspose.imaging.internal.at.b b2) {
        j = b2;
        return j;
    }

    static {
        e = new m();
        f = new o();
        new com.aspose.imaging.internal.jp.b().run();
    }

    protected static final class ImageOperation
    extends Enum {
        public static final int Resize = 0;
        public static final int ResizeWidthProportionally = 1;
        public static final int ResizeHeightProportionally = 2;
        public static final int Filter = 3;
        public static final int LoadPixels = 4;
        public static final int SavePixels = 5;
        public static final int Crop = 6;
        public static final int BinarizeFixed = 7;
        public static final int BinarizeOtsu = 8;
        public static final int BinarizeBradley = 9;
        public static final int Grayscale = 10;
        public static final int AdjustBrightness = 11;
        public static final int AdjustContrast = 12;
        public static final int AdjustGamma = 13;
        public static final int Rotate = 14;
        public static final int RotateFlip = 15;

        private ImageOperation() {
        }

        static {
            Enum.register(new a());
        }

        private static final class a
        extends Enum.SimpleEnum {
            a() {
                super(ImageOperation.class, Integer.class);
                this.addConstant("Resize", 0L);
                this.addConstant("ResizeWidthProportionally", 1L);
                this.addConstant("ResizeHeightProportionally", 2L);
                this.addConstant("Filter", 3L);
                this.addConstant("LoadPixels", 4L);
                this.addConstant("SavePixels", 5L);
                this.addConstant("Crop", 6L);
                this.addConstant("BinarizeFixed", 7L);
                this.addConstant("BinarizeOtsu", 8L);
                this.addConstant("BinarizeBradley", 9L);
                this.addConstant("Grayscale", 10L);
                this.addConstant("AdjustBrightness", 11L);
                this.addConstant("AdjustContrast", 12L);
                this.addConstant("AdjustGamma", 13L);
                this.addConstant("Rotate", 14L);
                this.addConstant("RotateFlip", 15L);
            }
        }
    }
}

