/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.Color;
import com.aspose.imaging.internal.kE.I;
import com.aspose.imaging.internal.kE.aU;
import com.aspose.imaging.internal.kE.au;
import com.aspose.imaging.internal.kE.y;

public final class ColorTranslator {
    private ColorTranslator() {
    }

    public static Color fromHtml(String string) {
        Color color = Color.getEmpty();
        if (string != null && string.length() != 0) {
            if (string.charAt(0) == '#' && (string.length() == 7 || string.length() == 4)) {
                if (string.length() == 7) {
                    Color.fromArgb(I.e(aU.b(string, 1, 2), 16), I.e(aU.b(string, 3, 2), 16), I.e(aU.b(string, 5, 2), 16)).CloneTo(color);
                } else {
                    String string2 = y.t(string.charAt(1));
                    String string3 = y.t(string.charAt(2));
                    String string4 = y.t(string.charAt(3));
                    Color.fromArgb(I.e(aU.a(new String[]{string2, string2}), 16), I.e(aU.a(new String[]{string3, string3}), 16), I.e(aU.a(new String[]{string4, string4}), 16)).CloneTo(color);
                }
            }
            if (color.isEmpty() && aU.d(string, "LightGray", (short)5)) {
                Color.getLightGray().CloneTo(color);
            }
        }
        return color.Clone();
    }

    public static Color fromOle(int n2) {
        return Color.fromArgb(n2 & 0xFF, n2 >> 8 & 0xFF, n2 >> 16 & 0xFF);
    }

    public static Color fromWin32(int n2) {
        return ColorTranslator.fromOle(n2);
    }

    public static String toHtml(Color color) {
        String string = aU.a;
        if (!color.isEmpty()) {
            if (color.isNamedColor()) {
                if (Color.op_Equality(color, Color.getLightGray())) {
                    return "LightGray";
                }
                return color.getName();
            }
            int n2 = color.toArgb();
            int n3 = n2 >> 16 & 0xFF;
            int n4 = n2 >> 8 & 0xFF;
            int n5 = n2 & 0xFF;
            return aU.a("#", au.a(n3, "X2", null), au.a(n4, "X2", null), au.a(n5, "X2", null));
        }
        return string;
    }

    public static int toOle(Color color) {
        return ColorTranslator.toWin32(color);
    }

    public static int toWin32(Color color) {
        int n2 = color.toArgb();
        int n3 = n2 >> 16 & 0xFF;
        int n4 = n2 >> 8 & 0xFF;
        int n5 = n2 & 0xFF;
        return n3 | n4 << 8 | n5 << 16;
    }
}

