/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.Color;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.at.E;
import com.aspose.imaging.internal.at.l;

public final class ColorPalette
implements IColorPalette {
    private final int[] a;
    private final E b;
    private final boolean c;

    public ColorPalette(int[] nArray, boolean bl2) {
        if (nArray == null) {
            throw new ArgumentNullException("argb32Entries");
        }
        this.a = nArray;
        this.b = new E(nArray);
        this.c = bl2;
    }

    public ColorPalette(int[] nArray) {
        this(nArray, false);
    }

    public ColorPalette(Color[] colorArray, boolean bl2) {
        this(l.a(colorArray), bl2);
    }

    public ColorPalette(Color[] colorArray) {
        this(colorArray, false);
    }

    @Override
    public int getEntriesCount() {
        return this.a.length;
    }

    @Override
    public int[] getArgb32Entries() {
        return (int[])this.a.clone();
    }

    @Override
    public Color[] getEntries() {
        Color[] colorArray = new Color[this.a.length];
        for (int i2 = 0; i2 < colorArray.length; ++i2) {
            colorArray[i2] = Color.fromArgb(this.a[i2]);
        }
        return colorArray;
    }

    @Override
    public boolean isCompactPalette() {
        return this.c;
    }

    public static ColorPalette copyPalette(IColorPalette iColorPalette, boolean bl2) {
        ColorPalette colorPalette = null;
        if (iColorPalette != null) {
            int[] nArray = new int[iColorPalette.getEntriesCount()];
            System.arraycopy(iColorPalette.getArgb32Entries(), 0, nArray, 0, nArray.length);
            colorPalette = new ColorPalette(nArray, bl2);
        }
        return colorPalette;
    }

    public static ColorPalette copyPalette(IColorPalette iColorPalette) {
        return ColorPalette.copyPalette(iColorPalette, iColorPalette != null && iColorPalette.isCompactPalette());
    }

    @Override
    public int getNearestColorIndex(int n2) {
        return this.b.a(n2);
    }

    @Override
    public int getNearestColorIndex(Color color) {
        return this.b.a(color.toArgb());
    }

    @Override
    public int getArgb32Color(int n2) {
        if (n2 >= this.a.length || n2 < 0) {
            throw new ArgumentOutOfRangeException("index", "The specified index lies out of the entries length.");
        }
        return this.a[n2];
    }

    @Override
    public Color getColor(int n2) {
        return Color.fromArgb(this.getArgb32Color(n2));
    }
}

