/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.system.SerializableAttribute;
import java.util.Arrays;

@SerializableAttribute
public final class Blend {
    private float[] a;
    private float[] b;

    public Blend() {
        this.a = new float[1];
        this.b = new float[1];
    }

    public Blend(int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("count");
        }
        this.a = new float[n2];
        this.b = new float[n2];
    }

    public float[] getFactors() {
        return this.a;
    }

    public void setFactors(float[] fArray) {
        if (fArray == null) {
            throw new ArgumentNullException("value");
        }
        this.a = fArray;
    }

    public float[] getPositions() {
        return this.b;
    }

    public void setPositions(float[] fArray) {
        if (fArray == null) {
            throw new ArgumentNullException("value");
        }
        this.b = fArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Blend)) {
            return false;
        }
        Blend blend = (Blend)object;
        return Arrays.equals(blend.a, this.a) && Arrays.equals(blend.b, this.b);
    }

    public int hashCode() {
        return Arrays.hashCode(this.a) ^ Arrays.hashCode(this.b);
    }
}

