/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.pkcs.jcajce;

import com.aspose.html.utils.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.DERNull;
import com.aspose.html.utils.ms.core.bc.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.pkcs.PKCS12PBEParams;
import com.aspose.html.utils.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.utils.ms.core.bc.jcajce.PKCS12Key;
import com.aspose.html.utils.ms.core.bc.jcajce.io.MacOutputStream;
import com.aspose.html.utils.ms.core.bc.jcajce.util.DefaultJcaJceHelper;
import com.aspose.html.utils.ms.core.bc.jcajce.util.JcaJceHelper;
import com.aspose.html.utils.ms.core.bc.jcajce.util.NamedJcaJceHelper;
import com.aspose.html.utils.ms.core.bc.jcajce.util.ProviderJcaJceHelper;
import com.aspose.html.utils.ms.core.bc.operator.GenericKey;
import com.aspose.html.utils.ms.core.bc.operator.MacCalculator;
import com.aspose.html.utils.ms.core.bc.operator.OperatorCreationException;
import com.aspose.html.utils.ms.core.bc.pkcs.PKCS12MacCalculatorBuilder;
import java.io.OutputStream;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Mac;
import javax.crypto.spec.PBEParameterSpec;

public class JcePKCS12MacCalculatorBuilder
implements PKCS12MacCalculatorBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private ASN1ObjectIdentifier algorithm;
    private SecureRandom random;
    private int saltLength;
    private int iterationCount = 1024;

    public JcePKCS12MacCalculatorBuilder() {
        this(OIWObjectIdentifiers.idSHA1);
    }

    public JcePKCS12MacCalculatorBuilder(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.algorithm = aSN1ObjectIdentifier;
    }

    public JcePKCS12MacCalculatorBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePKCS12MacCalculatorBuilder setProvider(String string) {
        this.helper = new NamedJcaJceHelper(string);
        return this;
    }

    public JcePKCS12MacCalculatorBuilder setIterationCount(int n2) {
        this.iterationCount = n2;
        return this;
    }

    public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
        return new AlgorithmIdentifier(this.algorithm, DERNull.INSTANCE);
    }

    public MacCalculator build(char[] cArray) throws OperatorCreationException {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        try {
            final Mac mac = this.helper.createMac(this.algorithm.getId());
            this.saltLength = mac.getMacLength();
            final byte[] byArray = new byte[this.saltLength];
            this.random.nextBytes(byArray);
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, this.iterationCount);
            final PKCS12Key pKCS12Key = new PKCS12Key(cArray);
            mac.init(pKCS12Key, pBEParameterSpec);
            return new MacCalculator(){

                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return new AlgorithmIdentifier(JcePKCS12MacCalculatorBuilder.this.algorithm, new PKCS12PBEParams(byArray, JcePKCS12MacCalculatorBuilder.this.iterationCount));
                }

                public OutputStream getOutputStream() {
                    return new MacOutputStream(mac);
                }

                public byte[] getMac() {
                    return mac.doFinal();
                }

                public GenericKey getKey() {
                    return new GenericKey(this.getAlgorithmIdentifier(), pKCS12Key.getEncoded());
                }
            };
        }
        catch (Exception exception) {
            throw new OperatorCreationException("unable to create MAC calculator: " + exception.getMessage(), exception);
        }
    }
}

