/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.est;

import com.aspose.html.utils.ms.core.bc.est.CTEBase64InputStream;
import com.aspose.html.utils.ms.core.bc.est.ESTRequest;
import com.aspose.html.utils.ms.core.bc.est.HttpUtil;
import com.aspose.html.utils.ms.core.bc.est.LimitedSource;
import com.aspose.html.utils.ms.core.bc.est.Source;
import com.aspose.html.utils.ms.core.bc.est.Utils;
import com.aspose.html.utils.ms.core.bc.util.Strings;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;

public class ESTResponse {
    private final ESTRequest originalRequest;
    private final HttpUtil.Headers headers;
    private final byte[] lineBuffer;
    private final Source source;
    private String HttpVersion;
    private int statusCode;
    private String statusMessage;
    private InputStream inputStream;
    private Long contentLength;
    private long read = 0L;
    private Long absoluteReadLimit;
    private static final Long ZERO = 0L;

    public ESTResponse(ESTRequest eSTRequest, Source source) throws IOException {
        Set<String> set;
        this.originalRequest = eSTRequest;
        this.source = source;
        if (source instanceof LimitedSource) {
            this.absoluteReadLimit = ((LimitedSource)((Object)source)).getAbsoluteReadLimit();
        }
        this.inputStream = (set = Utils.asKeySet("com.aspose.html.utils.ms.core.bc.debug.est")).contains("input") || set.contains("all") ? new PrintingInputStream(source.getInputStream()) : source.getInputStream();
        this.headers = new HttpUtil.Headers();
        this.lineBuffer = new byte[1024];
        this.process();
    }

    private void process() throws IOException {
        this.HttpVersion = this.readStringIncluding(' ');
        this.statusCode = Integer.parseInt(this.readStringIncluding(' '));
        this.statusMessage = this.readStringIncluding('\n');
        String string = this.readStringIncluding('\n');
        while (string.length() > 0) {
            int n2 = string.indexOf(58);
            if (n2 > -1) {
                String string2 = Strings.toLowerCase(string.substring(0, n2).trim());
                this.headers.add(string2, string.substring(n2 + 1).trim());
            }
            string = this.readStringIncluding('\n');
        }
        this.contentLength = this.getContentLength();
        if (this.statusCode == 204 || this.statusCode == 202) {
            if (this.contentLength == null) {
                this.contentLength = 0L;
            } else if (this.statusCode == 204 && this.contentLength > 0L) {
                throw new IOException("Got HTTP status 204 but Content-length > 0.");
            }
        }
        if (this.contentLength == null) {
            throw new IOException("No Content-length header.");
        }
        if (this.contentLength.equals(ZERO)) {
            this.inputStream = new InputStream(){

                public int read() throws IOException {
                    return -1;
                }
            };
        }
        if (this.contentLength < 0L) {
            throw new IOException("Server returned negative content length: " + this.absoluteReadLimit);
        }
        if (this.absoluteReadLimit != null && this.contentLength >= this.absoluteReadLimit) {
            throw new IOException("Content length longer than absolute read limit: " + this.absoluteReadLimit + " Content-Length: " + this.contentLength);
        }
        this.inputStream = this.wrapWithCounter(this.inputStream, this.absoluteReadLimit);
        if ("base64".equalsIgnoreCase(this.getHeader("content-transfer-encoding"))) {
            this.inputStream = new CTEBase64InputStream(this.inputStream, this.getContentLength());
        }
    }

    public String getHeader(String string) {
        return this.headers.getFirstValue(string);
    }

    protected InputStream wrapWithCounter(final InputStream inputStream, final Long l2) {
        return new InputStream(){

            public int read() throws IOException {
                int n2 = inputStream.read();
                if (n2 > -1) {
                    ESTResponse.this.read++;
                    if (l2 != null && ESTResponse.this.read >= l2) {
                        throw new IOException("Absolute Read Limit exceeded: " + l2);
                    }
                }
                return n2;
            }

            public void close() throws IOException {
                if (ESTResponse.this.contentLength != null && ESTResponse.this.contentLength - 1L > ESTResponse.this.read) {
                    throw new IOException("Stream closed before limit fully read, Read: " + ESTResponse.this.read + " ContentLength: " + ESTResponse.this.contentLength);
                }
                if (inputStream.available() > 0) {
                    throw new IOException("Stream closed with extra content in pipe that exceeds content length.");
                }
                inputStream.close();
            }
        };
    }

    protected String readStringIncluding(char c2) throws IOException {
        int n2;
        int n3 = 0;
        do {
            n2 = this.inputStream.read();
            this.lineBuffer[n3++] = (byte)n2;
            if (n3 < this.lineBuffer.length) continue;
            throw new IOException("Server sent line > " + this.lineBuffer.length);
        } while (n2 != c2 && n2 > -1);
        if (n2 == -1) {
            throw new EOFException();
        }
        return new String(this.lineBuffer, 0, n3).trim();
    }

    public ESTRequest getOriginalRequest() {
        return this.originalRequest;
    }

    public HttpUtil.Headers getHeaders() {
        return this.headers;
    }

    public String getHttpVersion() {
        return this.HttpVersion;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public Source getSource() {
        return this.source;
    }

    public Long getContentLength() {
        String string = this.headers.getFirstValue("Content-Length");
        if (string == null) {
            return null;
        }
        try {
            return Long.parseLong(string);
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Content Length: '" + string + "' invalid. " + runtimeException.getMessage());
        }
    }

    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        this.source.close();
    }

    class PrintingInputStream
    extends InputStream {
        private final InputStream src;

        private PrintingInputStream(InputStream inputStream) {
            this.src = inputStream;
        }

        public int read() throws IOException {
            int n2 = this.src.read();
            return n2;
        }

        public int available() throws IOException {
            return this.src.available();
        }

        public void close() throws IOException {
            this.src.close();
        }
    }
}

