/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.internal.io;

import com.aspose.html.utils.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.utils.ms.core.bc.crypto.UpdateOutputStream;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Xof;
import com.aspose.html.utils.ms.core.bc.crypto.internal.io.Utils;
import java.io.IOException;

public class XofOutputStream
extends UpdateOutputStream {
    private final String algorithmName;
    private final boolean isApprovedMode;
    protected Xof digest;

    public XofOutputStream(Xof xof) {
        this.algorithmName = xof.getAlgorithmName();
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.digest = xof;
    }

    public void write(int n2) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.digest.update((byte)n2);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.digest.update(byArray, n2, n3);
    }

    public final int getOutput(byte[] byArray, int n2, int n3) {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        return this.digest.doOutput(byArray, n2, n3);
    }

    public void reset() {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.digest.reset();
    }
}

