/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.general;

import com.aspose.html.utils.ms.core.bc.crypto.general.CipherKeyGenerator;
import com.aspose.html.utils.ms.core.bc.crypto.internal.KeyGenerationParameters;

class Poly1305KeyGenerator
extends CipherKeyGenerator {
    private static final byte R_MASK_LOW_2 = -4;
    private static final byte R_MASK_HIGH_4 = 15;

    Poly1305KeyGenerator() {
    }

    public void init(KeyGenerationParameters keyGenerationParameters) {
        super.init(new KeyGenerationParameters(keyGenerationParameters.getRandom(), 256));
    }

    public byte[] generateKey() {
        byte[] byArray = super.generateKey();
        Poly1305KeyGenerator.clamp(byArray);
        return byArray;
    }

    static byte[] clamp(byte[] byArray) {
        if (byArray.length != 32) {
            throw new IllegalArgumentException("Poly1305 key must be 256 bits.");
        }
        byArray[3] = (byte)(byArray[3] & 0xF);
        byArray[7] = (byte)(byArray[7] & 0xF);
        byArray[11] = (byte)(byArray[11] & 0xF);
        byArray[15] = (byte)(byArray[15] & 0xF);
        byArray[4] = (byte)(byArray[4] & 0xFFFFFFFC);
        byArray[8] = (byte)(byArray[8] & 0xFFFFFFFC);
        byArray[12] = (byte)(byArray[12] & 0xFFFFFFFC);
        return byArray;
    }
}

