/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.general;

import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsSHS;
import com.aspose.html.utils.ms.core.bc.crypto.general.Ed25519PrivateKeyParameters;
import com.aspose.html.utils.ms.core.bc.crypto.general.Ed25519PublicKeyParameters;
import com.aspose.html.utils.ms.core.bc.crypto.general.Register;
import com.aspose.html.utils.ms.core.bc.crypto.internal.CipherParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Digest;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Signer;
import com.aspose.html.utils.ms.core.bc.math.ec.rfc8032.Ed25519;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import java.io.ByteArrayOutputStream;

class Ed25519Signer
implements Signer {
    private final Buffer buffer = new Buffer();
    private boolean forSigning;
    private Ed25519PrivateKeyParameters privateKey;
    private Ed25519PublicKeyParameters publicKey;

    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.forSigning = bl2;
        if (bl2) {
            this.privateKey = (Ed25519PrivateKeyParameters)cipherParameters;
            this.publicKey = this.privateKey.generatePublicKey();
        } else {
            this.privateKey = null;
            this.publicKey = (Ed25519PublicKeyParameters)cipherParameters;
        }
        this.reset();
    }

    public void update(byte by2) {
        this.buffer.write(by2);
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.buffer.write(byArray, n2, n3);
    }

    public byte[] generateSignature() {
        if (!this.forSigning || null == this.privateKey) {
            throw new IllegalStateException("Ed25519Signer not initialised for signature generation.");
        }
        return this.buffer.generateSignature(this.privateKey, this.publicKey);
    }

    public boolean verifySignature(byte[] byArray) {
        if (this.forSigning || null == this.publicKey) {
            throw new IllegalStateException("Ed25519Signer not initialised for verification");
        }
        return this.buffer.verifySignature(this.publicKey, byArray);
    }

    public void reset() {
        this.buffer.reset();
    }

    static class Buffer
    extends ByteArrayOutputStream {
        private final Ed25519 ed25519 = new Ed25519(){

            public Digest createDigest() {
                return Register.createDigest(FipsSHS.Algorithm.SHA512);
            }
        };

        private Buffer() {
        }

        synchronized byte[] generateSignature(Ed25519PrivateKeyParameters ed25519PrivateKeyParameters, Ed25519PublicKeyParameters ed25519PublicKeyParameters) {
            byte[] byArray = new byte[64];
            ed25519PrivateKeyParameters.sign(0, ed25519PublicKeyParameters, null, this.buf, 0, this.count, byArray, 0);
            this.reset();
            return byArray;
        }

        synchronized boolean verifySignature(Ed25519PublicKeyParameters ed25519PublicKeyParameters, byte[] byArray) {
            byte[] byArray2 = ed25519PublicKeyParameters.getEncoded();
            boolean bl2 = this.ed25519.verify(byArray, 0, byArray2, 0, this.buf, 0, this.count);
            this.reset();
            return bl2;
        }

        public synchronized void reset() {
            Arrays.fill(this.buf, 0, this.count, (byte)0);
            this.count = 0;
        }
    }
}

