/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.asymmetric;

import com.aspose.html.utils.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.utils.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.utils.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.utils.ms.core.bc.asn1.sec.ECPrivateKey;
import com.aspose.html.utils.ms.core.bc.asn1.ua.DSTU4145ECBinary;
import com.aspose.html.utils.ms.core.bc.asn1.ua.DSTU4145Params;
import com.aspose.html.utils.ms.core.bc.asn1.ua.UAObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.utils.ms.core.bc.crypto.Algorithm;
import com.aspose.html.utils.ms.core.bc.crypto.AsymmetricPrivateKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricDSTU4145Key;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.DSTU4145Parameters;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.KeyUtils;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.NamedECDomainParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Permissions;
import com.aspose.html.utils.ms.core.bc.math.ec.ECCurve;
import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;

public final class AsymmetricDSTU4145PrivateKey
extends AsymmetricDSTU4145Key
implements AsymmetricPrivateKey {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private int hashCode;
    private PrivateKeyInfo privKeyInfo;
    private BigInteger d;

    public AsymmetricDSTU4145PrivateKey(Algorithm algorithm, DSTU4145Parameters dSTU4145Parameters, BigInteger bigInteger) {
        super(algorithm, dSTU4145Parameters);
        this.d = bigInteger;
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricDSTU4145PrivateKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, PrivateKeyInfo.getInstance(byArray));
    }

    public AsymmetricDSTU4145PrivateKey(Algorithm algorithm, PrivateKeyInfo privateKeyInfo) {
        super(algorithm, privateKeyInfo.getPrivateKeyAlgorithm());
        this.privKeyInfo = privateKeyInfo;
        this.d = AsymmetricDSTU4145PrivateKey.parsePrivateKey(privateKeyInfo);
        this.hashCode = this.calculateHashCode();
    }

    private static BigInteger parsePrivateKey(PrivateKeyInfo privateKeyInfo) {
        try {
            ASN1Encodable aSN1Encodable = privateKeyInfo.parsePrivateKey();
            if (aSN1Encodable instanceof ASN1Integer) {
                ASN1Integer aSN1Integer = ASN1Integer.getInstance(aSN1Encodable);
                return aSN1Integer.getValue();
            }
            return ECPrivateKey.getInstance(aSN1Encodable).getKey();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid info structure in DSTU4145 private key");
        }
    }

    public final byte[] getEncoded() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        if (this.privKeyInfo != null) {
            return KeyUtils.getEncodedInfo(this.privKeyInfo);
        }
        DSTU4145Parameters dSTU4145Parameters = this.getParameters();
        int n2 = KeyUtils.getOrderBitLength(dSTU4145Parameters.getDomainParameters());
        if (dSTU4145Parameters.getDomainParameters() instanceof NamedECDomainParameters) {
            NamedECDomainParameters namedECDomainParameters = (NamedECDomainParameters)dSTU4145Parameters.getDomainParameters();
            DSTU4145Params dSTU4145Params = new DSTU4145Params(namedECDomainParameters.getID(), dSTU4145Parameters.getDKE());
            ECPrivateKey eCPrivateKey = new ECPrivateKey(n2, this.getS(), dSTU4145Params);
            return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(UAObjectIdentifiers.dstu4145be, dSTU4145Params), eCPrivateKey);
        }
        if (dSTU4145Parameters.getDomainParameters().getCurve() instanceof ECCurve.AbstractF2m) {
            DSTU4145ECBinary dSTU4145ECBinary = new DSTU4145ECBinary(dSTU4145Parameters.getDomainParameters());
            DSTU4145Params dSTU4145Params = new DSTU4145Params(dSTU4145ECBinary);
            ECPrivateKey eCPrivateKey = new ECPrivateKey(n2, this.getS(), dSTU4145Params);
            return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(UAObjectIdentifiers.dstu4145be, dSTU4145Params), eCPrivateKey);
        }
        throw new IllegalArgumentException("Unable to encode binary parameters");
    }

    public final Algorithm getAlgorithm() {
        KeyUtils.checkDestroyed(this);
        return super.getAlgorithm();
    }

    public final DSTU4145Parameters getParameters() {
        KeyUtils.checkDestroyed(this);
        return super.getParameters();
    }

    public final BigInteger getS() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        KeyUtils.checkDestroyed(this);
        return this.d;
    }

    public void destroy() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            this.d = null;
            this.hashCode = -1;
            super.zeroize();
        }
    }

    public boolean isDestroyed() {
        this.checkApprovedOnlyModeStatus();
        return this.hasBeenDestroyed.get();
    }

    public boolean equals(Object object) {
        this.checkApprovedOnlyModeStatus();
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricDSTU4145PrivateKey)) {
            return false;
        }
        AsymmetricDSTU4145PrivateKey asymmetricDSTU4145PrivateKey = (AsymmetricDSTU4145PrivateKey)object;
        if (this.isDestroyed() || asymmetricDSTU4145PrivateKey.isDestroyed()) {
            return false;
        }
        if (this.d == null ? asymmetricDSTU4145PrivateKey.d != null : !this.d.equals(asymmetricDSTU4145PrivateKey.d)) {
            return false;
        }
        return this.getParameters().equals(asymmetricDSTU4145PrivateKey.getParameters());
    }

    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int n2 = this.d.hashCode();
        n2 = 31 * n2 + this.getParameters().hashCode();
        return n2;
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }
}

