/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.cms.jcajce;

import com.aspose.html.utils.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.utils.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.DERNull;
import com.aspose.html.utils.ms.core.bc.asn1.cms.GCMParameters;
import com.aspose.html.utils.ms.core.bc.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.utils.ms.core.bc.cms.CMSException;
import com.aspose.html.utils.ms.core.bc.cms.jcajce.DefaultJcaJceExtHelper;
import com.aspose.html.utils.ms.core.bc.cms.jcajce.EnvelopedDataHelper;
import com.aspose.html.utils.ms.core.bc.cms.jcajce.JceAADStream;
import com.aspose.html.utils.ms.core.bc.cms.jcajce.NamedJcaJceExtHelper;
import com.aspose.html.utils.ms.core.bc.cms.jcajce.ProviderJcaJceExtHelper;
import com.aspose.html.utils.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.utils.ms.core.bc.jcajce.io.CipherOutputStream;
import com.aspose.html.utils.ms.core.bc.operator.DefaultSecretKeySizeProvider;
import com.aspose.html.utils.ms.core.bc.operator.GenericKey;
import com.aspose.html.utils.ms.core.bc.operator.MacCaptureStream;
import com.aspose.html.utils.ms.core.bc.operator.OutputAEADEncryptor;
import com.aspose.html.utils.ms.core.bc.operator.OutputEncryptor;
import com.aspose.html.utils.ms.core.bc.operator.SecretKeySizeProvider;
import com.aspose.html.utils.ms.core.bc.operator.jcajce.JceGenericKey;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class JceCMSContentEncryptorBuilder {
    private static final SecretKeySizeProvider KEY_SIZE_PROVIDER = DefaultSecretKeySizeProvider.INSTANCE;
    private final ASN1ObjectIdentifier encryptionOID;
    private final int keySize;
    private EnvelopedDataHelper helper = new EnvelopedDataHelper(new DefaultJcaJceExtHelper());
    private SecureRandom random;
    private AlgorithmIdentifier algorithmIdentifier;
    private AlgorithmParameters algorithmParameters;

    public JceCMSContentEncryptorBuilder(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this(aSN1ObjectIdentifier, KEY_SIZE_PROVIDER.getKeySize(aSN1ObjectIdentifier));
    }

    public JceCMSContentEncryptorBuilder(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n2) {
        this.encryptionOID = aSN1ObjectIdentifier;
        int n3 = KEY_SIZE_PROVIDER.getKeySize(aSN1ObjectIdentifier);
        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.des_EDE3_CBC)) {
            if (n2 != 168 && n2 != n3) {
                throw new IllegalArgumentException("incorrect keySize for encryptionOID passed to builder.");
            }
            this.keySize = 168;
        } else if (aSN1ObjectIdentifier.equals(OIWObjectIdentifiers.desCBC)) {
            if (n2 != 56 && n2 != n3) {
                throw new IllegalArgumentException("incorrect keySize for encryptionOID passed to builder.");
            }
            this.keySize = 56;
        } else {
            if (n3 > 0 && n3 != n2) {
                throw new IllegalArgumentException("incorrect keySize for encryptionOID passed to builder.");
            }
            this.keySize = n2;
        }
    }

    public JceCMSContentEncryptorBuilder(AlgorithmIdentifier algorithmIdentifier) {
        this(algorithmIdentifier.getAlgorithm(), KEY_SIZE_PROVIDER.getKeySize(algorithmIdentifier.getAlgorithm()));
        this.algorithmIdentifier = algorithmIdentifier;
    }

    public JceCMSContentEncryptorBuilder setProvider(Provider provider) {
        this.helper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        return this;
    }

    public JceCMSContentEncryptorBuilder setProvider(String string) {
        this.helper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(string));
        return this;
    }

    public JceCMSContentEncryptorBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public JceCMSContentEncryptorBuilder setAlgorithmParameters(AlgorithmParameters algorithmParameters) {
        this.algorithmParameters = algorithmParameters;
        return this;
    }

    public OutputEncryptor build() throws CMSException {
        ASN1Encodable aSN1Encodable;
        if (this.algorithmParameters != null) {
            if (this.helper.isAuthEnveloped(this.encryptionOID)) {
                return new CMSAuthOutputEncryptor(this.encryptionOID, this.keySize, this.algorithmParameters, this.random);
            }
            return new CMSOutputEncryptor(this.encryptionOID, this.keySize, this.algorithmParameters, this.random);
        }
        if (this.algorithmIdentifier != null && (aSN1Encodable = this.algorithmIdentifier.getParameters()) != null && !aSN1Encodable.equals(DERNull.INSTANCE)) {
            try {
                this.algorithmParameters = this.helper.createAlgorithmParameters(this.algorithmIdentifier.getAlgorithm());
                this.algorithmParameters.init(aSN1Encodable.toASN1Primitive().getEncoded());
            }
            catch (Exception exception) {
                throw new CMSException("unable to process provided algorithmIdentifier: " + exception.toString(), exception);
            }
        }
        if (this.helper.isAuthEnveloped(this.encryptionOID)) {
            return new CMSAuthOutputEncryptor(this.encryptionOID, this.keySize, this.algorithmParameters, this.random);
        }
        return new CMSOutputEncryptor(this.encryptionOID, this.keySize, this.algorithmParameters, this.random);
    }

    private static boolean checkForAEAD() {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Cipher.class.getMethod("updateAAD", byte[].class) != null;
                }
                catch (Exception exception) {
                    return Boolean.FALSE;
                }
            }
        });
    }

    private static SecureRandom getSecureRandom(SecureRandom secureRandom) {
        return null == secureRandom ? CryptoServicesRegistrar.getSecureRandom() : secureRandom;
    }

    class CMSAuthOutputEncryptor
    implements OutputAEADEncryptor {
        private SecretKey encKey;
        private AlgorithmIdentifier algorithmIdentifier;
        private Cipher cipher;
        private MacCaptureStream macOut;

        CMSAuthOutputEncryptor(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n2, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws CMSException {
            KeyGenerator keyGenerator = JceCMSContentEncryptorBuilder.this.helper.createKeyGenerator(aSN1ObjectIdentifier);
            secureRandom = JceCMSContentEncryptorBuilder.getSecureRandom(secureRandom);
            if (n2 < 0) {
                keyGenerator.init(secureRandom);
            } else {
                keyGenerator.init(n2, secureRandom);
            }
            this.cipher = JceCMSContentEncryptorBuilder.this.helper.createCipher(aSN1ObjectIdentifier);
            this.encKey = keyGenerator.generateKey();
            if (algorithmParameters == null) {
                algorithmParameters = JceCMSContentEncryptorBuilder.this.helper.generateParameters(aSN1ObjectIdentifier, this.encKey, secureRandom);
            }
            try {
                this.cipher.init(1, (Key)this.encKey, algorithmParameters, secureRandom);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CMSException("unable to initialize cipher: " + generalSecurityException.getMessage(), generalSecurityException);
            }
            if (algorithmParameters == null) {
                algorithmParameters = this.cipher.getParameters();
            }
            this.algorithmIdentifier = JceCMSContentEncryptorBuilder.this.helper.getAlgorithmIdentifier(aSN1ObjectIdentifier, algorithmParameters);
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algorithmIdentifier;
        }

        public OutputStream getOutputStream(OutputStream outputStream) {
            GCMParameters gCMParameters = GCMParameters.getInstance(this.algorithmIdentifier.getParameters());
            this.macOut = new MacCaptureStream(outputStream, gCMParameters.getIcvLen());
            return new CipherOutputStream(this.macOut, this.cipher);
        }

        public GenericKey getKey() {
            return new JceGenericKey(this.algorithmIdentifier, this.encKey);
        }

        public OutputStream getAADStream() {
            if (JceCMSContentEncryptorBuilder.checkForAEAD()) {
                return new JceAADStream(this.cipher);
            }
            return null;
        }

        public byte[] getMAC() {
            return this.macOut.getMac();
        }
    }

    class CMSOutputEncryptor
    implements OutputEncryptor {
        private SecretKey encKey;
        private AlgorithmIdentifier algorithmIdentifier;
        private Cipher cipher;

        CMSOutputEncryptor(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n2, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws CMSException {
            KeyGenerator keyGenerator = JceCMSContentEncryptorBuilder.this.helper.createKeyGenerator(aSN1ObjectIdentifier);
            secureRandom = JceCMSContentEncryptorBuilder.getSecureRandom(secureRandom);
            if (n2 < 0) {
                keyGenerator.init(secureRandom);
            } else {
                keyGenerator.init(n2, secureRandom);
            }
            this.cipher = JceCMSContentEncryptorBuilder.this.helper.createCipher(aSN1ObjectIdentifier);
            this.encKey = keyGenerator.generateKey();
            if (algorithmParameters == null) {
                algorithmParameters = JceCMSContentEncryptorBuilder.this.helper.generateParameters(aSN1ObjectIdentifier, this.encKey, secureRandom);
            }
            try {
                this.cipher.init(1, (Key)this.encKey, algorithmParameters, secureRandom);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CMSException("unable to initialize cipher: " + generalSecurityException.getMessage(), generalSecurityException);
            }
            if (algorithmParameters == null) {
                algorithmParameters = this.cipher.getParameters();
            }
            this.algorithmIdentifier = JceCMSContentEncryptorBuilder.this.helper.getAlgorithmIdentifier(aSN1ObjectIdentifier, algorithmParameters);
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algorithmIdentifier;
        }

        public OutputStream getOutputStream(OutputStream outputStream) {
            return new CipherOutputStream(outputStream, this.cipher);
        }

        public GenericKey getKey() {
            return new JceGenericKey(this.algorithmIdentifier, this.encKey);
        }
    }
}

