/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.asn1;

import com.aspose.html.utils.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.utils.ms.core.bc.asn1.ASN1OutputStream;
import com.aspose.html.utils.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.utils.ms.core.bc.asn1.ASN1TaggedObject;
import com.aspose.html.utils.ms.core.bc.asn1.StreamUtil;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import java.io.IOException;
import java.math.BigInteger;

public class ASN1Integer
extends ASN1Primitive {
    byte[] bytes;

    public static ASN1Integer getInstance(Object object) {
        if (object == null || object instanceof ASN1Integer) {
            return (ASN1Integer)object;
        }
        if (object instanceof byte[]) {
            try {
                return (ASN1Integer)ASN1Integer.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("Illegal object in getInstance: " + object.getClass().getName());
    }

    public static ASN1Integer getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        ASN1Primitive aSN1Primitive = aSN1TaggedObject.getObject();
        if (bl2 || aSN1Primitive instanceof ASN1Integer) {
            return ASN1Integer.getInstance(aSN1Primitive);
        }
        return new ASN1Integer(ASN1OctetString.getInstance(aSN1TaggedObject.getObject()).getOctets());
    }

    public ASN1Integer(long l2) {
        this.bytes = BigInteger.valueOf(l2).toByteArray();
    }

    public ASN1Integer(BigInteger bigInteger) {
        this.bytes = bigInteger.toByteArray();
    }

    public ASN1Integer(byte[] byArray) {
        this(byArray, true);
    }

    ASN1Integer(byte[] byArray, boolean bl2) {
        if (byArray.length > 1) {
            if (byArray[0] == 0 && (byArray[1] & 0x80) == 0) {
                throw new IllegalArgumentException("malformed integer");
            }
            if (byArray[0] == -1 && (byArray[1] & 0x80) != 0) {
                throw new IllegalArgumentException("malformed integer");
            }
        }
        this.bytes = bl2 ? Arrays.clone(byArray) : byArray;
    }

    public BigInteger getValue() {
        return new BigInteger(this.bytes);
    }

    public BigInteger getPositiveValue() {
        return new BigInteger(1, this.bytes);
    }

    boolean isConstructed() {
        return false;
    }

    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.bytes.length) + this.bytes.length;
    }

    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        aSN1OutputStream.writeEncoded(2, this.bytes);
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 != this.bytes.length; ++i2) {
            n2 ^= (this.bytes[i2] & 0xFF) << i2 % 4;
        }
        return n2;
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1Integer)) {
            return false;
        }
        ASN1Integer aSN1Integer = (ASN1Integer)aSN1Primitive;
        return Arrays.areEqual(this.bytes, aSN1Integer.bytes);
    }

    public String toString() {
        return this.getValue().toString();
    }
}

