/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks;

import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.ImageInfo;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.PngHelperInternal;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.PngjException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkRaw;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunk;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkSingle;

public class PngChunkTRNS
extends PngChunkSingle {
    public static final String ID = "tRNS";
    private int a;
    private int b;
    private int c;
    private int d;
    private int[] e = new int[0];

    public PngChunkTRNS(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.AFTER_PLTE_BEFORE_IDAT;
    }

    @Override
    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = null;
        if (this.imgInfo.greyscale) {
            chunkRaw = this.createEmptyChunk(2, true);
            PngHelperInternal.writeInt2tobytes(this.a, chunkRaw.data, 0);
        } else if (this.imgInfo.indexed) {
            chunkRaw = this.createEmptyChunk(this.e.length, true);
            for (int i2 = 0; i2 < chunkRaw.len; ++i2) {
                chunkRaw.data[i2] = (byte)this.e[i2];
            }
        } else {
            chunkRaw = this.createEmptyChunk(6, true);
            PngHelperInternal.writeInt2tobytes(this.b, chunkRaw.data, 0);
            PngHelperInternal.writeInt2tobytes(this.c, chunkRaw.data, 0);
            PngHelperInternal.writeInt2tobytes(this.d, chunkRaw.data, 0);
        }
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        if (this.imgInfo.greyscale) {
            this.a = PngHelperInternal.readInt2fromBytes(chunkRaw.data, 0);
        } else if (this.imgInfo.indexed) {
            int n2 = chunkRaw.data.length;
            this.e = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.e[i2] = chunkRaw.data[i2] & 0xFF;
            }
        } else {
            if (chunkRaw.data.length >= 2) {
                this.b = PngHelperInternal.readInt2fromBytes(chunkRaw.data, 0);
            }
            if (chunkRaw.data.length >= 4) {
                this.c = PngHelperInternal.readInt2fromBytes(chunkRaw.data, 2);
            }
            if (chunkRaw.data.length >= 6) {
                this.d = PngHelperInternal.readInt2fromBytes(chunkRaw.data, 4);
            }
        }
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkTRNS pngChunkTRNS = (PngChunkTRNS)pngChunk;
        this.a = pngChunkTRNS.a;
        this.b = pngChunkTRNS.b;
        this.c = pngChunkTRNS.b;
        this.d = pngChunkTRNS.b;
        if (pngChunkTRNS.e != null) {
            this.e = new int[pngChunkTRNS.e.length];
            System.arraycopy(pngChunkTRNS.e, 0, this.e, 0, this.e.length);
        }
    }

    public void setRGB(int n2, int n3, int n4) {
        if (this.imgInfo.greyscale || this.imgInfo.indexed) {
            throw new PngjException("only rgb or rgba images support this");
        }
        this.b = n2;
        this.c = n3;
        this.d = n4;
    }

    public int[] getRGB() {
        if (this.imgInfo.greyscale || this.imgInfo.indexed) {
            throw new PngjException("only rgb or rgba images support this");
        }
        return new int[]{this.b, this.c, this.d};
    }

    public void setGray(int n2) {
        if (!this.imgInfo.greyscale) {
            throw new PngjException("only grayscale images support this");
        }
        this.a = n2;
    }

    public int getGray() {
        if (!this.imgInfo.greyscale) {
            throw new PngjException("only grayscale images support this");
        }
        return this.a;
    }

    public void setPalletteAlpha(int[] nArray) {
        if (!this.imgInfo.indexed) {
            throw new PngjException("only indexed images support this");
        }
        this.e = nArray;
    }

    public void setIndexEntryAsTransparent(int n2) {
        if (!this.imgInfo.indexed) {
            throw new PngjException("only indexed images support this");
        }
        this.e = new int[]{n2 + 1};
        for (int i2 = 0; i2 < n2; ++i2) {
            this.e[i2] = 255;
        }
        this.e[n2] = 0;
    }

    public int[] getPalletteAlpha() {
        if (!this.imgInfo.indexed) {
            throw new PngjException("only indexed images support this");
        }
        return this.e;
    }

    public byte[] getPaletteAlphaAsBytes() {
        int[] nArray = this.getPalletteAlpha();
        byte[] byArray = new byte[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            byArray[i2] = (byte)nArray[i2];
        }
        return byArray;
    }
}

