/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.ico;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

class BmpInfoHeader {
    public int size;
    public int width;
    public int height;
    public short planes;
    public short bitCount;
    public int compression;
    public int imageSize;
    public int xpixelsPerM;
    public int ypixelsPerM;
    public int colorsUsed;
    public int colorsImportant;
    public int numColors;

    public BmpInfoHeader() {
        this.size = 40;
        this.width = 0;
        this.height = 0;
        this.planes = 1;
        this.bitCount = 0;
        this.numColors = 0;
        this.compression = 0;
        this.imageSize = 0;
        this.xpixelsPerM = 0;
        this.ypixelsPerM = 0;
        this.colorsUsed = 0;
        this.colorsImportant = 0;
    }

    BmpInfoHeader deepClone() {
        BmpInfoHeader bmpInfoHeader = new BmpInfoHeader();
        bmpInfoHeader.bitCount = this.bitCount;
        bmpInfoHeader.planes = this.planes;
        bmpInfoHeader.colorsImportant = this.colorsImportant;
        bmpInfoHeader.colorsUsed = this.colorsUsed;
        bmpInfoHeader.compression = this.compression;
        bmpInfoHeader.imageSize = this.imageSize;
        bmpInfoHeader.numColors = this.numColors;
        bmpInfoHeader.height = this.height;
        bmpInfoHeader.width = this.width;
        bmpInfoHeader.size = this.size;
        bmpInfoHeader.xpixelsPerM = this.xpixelsPerM;
        bmpInfoHeader.ypixelsPerM = this.ypixelsPerM;
        return bmpInfoHeader;
    }

    public BmpInfoHeader(ImageInputStream imageInputStream) throws IOException {
        this.size = imageInputStream.readInt();
        this.init(imageInputStream, this.size);
    }

    public BmpInfoHeader(ImageInputStream imageInputStream, boolean bl2) throws IOException {
        if (bl2) {
            this.size = BmpInfoHeader.intBack(imageInputStream.readInt());
            this.initBack(imageInputStream, this.size);
        } else {
            this.size = imageInputStream.readInt();
            this.init(imageInputStream, this.size);
        }
    }

    public BmpInfoHeader(ImageInputStream imageInputStream, int n2) throws IOException {
        this.init(imageInputStream, n2);
    }

    public BmpInfoHeader(ImageInputStream imageInputStream, int n2, boolean bl2) throws IOException {
        if (bl2) {
            this.initBack(imageInputStream, n2);
        } else {
            this.init(imageInputStream, n2);
        }
    }

    protected void init(ImageInputStream imageInputStream, int n2) throws IOException {
        this.size = n2;
        this.width = Math.abs(imageInputStream.readInt());
        this.height = Math.abs(imageInputStream.readInt());
        this.planes = imageInputStream.readShort();
        this.bitCount = imageInputStream.readShort();
        this.numColors = (int)Math.pow(2.0, this.bitCount);
        this.compression = imageInputStream.readInt();
        this.imageSize = imageInputStream.readInt();
        this.xpixelsPerM = imageInputStream.readInt();
        this.ypixelsPerM = imageInputStream.readInt();
        this.colorsUsed = imageInputStream.readInt();
        this.colorsImportant = imageInputStream.readInt();
    }

    protected void initBack(ImageInputStream imageInputStream, int n2) throws IOException {
        this.size = n2;
        this.width = Math.abs(BmpInfoHeader.intBack(imageInputStream.readInt()));
        this.height = Math.abs(BmpInfoHeader.intBack(imageInputStream.readInt()));
        this.planes = BmpInfoHeader.shortBack(imageInputStream.readShort());
        this.bitCount = BmpInfoHeader.shortBack(imageInputStream.readShort());
        this.numColors = (int)Math.pow(2.0, this.bitCount);
        this.compression = BmpInfoHeader.intBack(imageInputStream.readInt());
        this.imageSize = BmpInfoHeader.intBack(imageInputStream.readInt());
        this.xpixelsPerM = BmpInfoHeader.intBack(imageInputStream.readInt());
        this.ypixelsPerM = BmpInfoHeader.intBack(imageInputStream.readInt());
        this.colorsUsed = BmpInfoHeader.intBack(imageInputStream.readInt());
        this.colorsImportant = BmpInfoHeader.intBack(imageInputStream.readInt());
    }

    public void write(ImageOutputStream imageOutputStream) throws IOException {
        imageOutputStream.writeInt(BmpInfoHeader.intWBack(this.size));
        imageOutputStream.writeInt(BmpInfoHeader.intWBack(this.width));
        imageOutputStream.writeInt(BmpInfoHeader.intWBack(this.height));
        imageOutputStream.writeShort(BmpInfoHeader.shortWBack(this.planes));
        imageOutputStream.writeShort(BmpInfoHeader.shortWBack(this.bitCount));
        imageOutputStream.writeInt(BmpInfoHeader.intWBack(this.compression));
        imageOutputStream.writeInt(BmpInfoHeader.intWBack(this.imageSize));
        imageOutputStream.writeInt(BmpInfoHeader.intWBack(this.xpixelsPerM));
        imageOutputStream.writeInt(BmpInfoHeader.intWBack(this.ypixelsPerM));
        imageOutputStream.writeInt(BmpInfoHeader.intWBack(this.colorsUsed));
        imageOutputStream.writeInt(BmpInfoHeader.intWBack(this.colorsImportant));
    }

    public static short shortBack(short s2) {
        return (short)((s2 & 0xFF) << 8 | s2 >> 8 & 0xFF);
    }

    public static int intBack(int n2) {
        return (n2 & 0xFF) << 24 | (n2 & 0xFF00) << 8 | n2 >> 16 & 0xFF | n2 >> 24 & 0xFF;
    }

    public static int shortWBack(int n2) {
        return n2;
    }

    public static int intWBack(int n2) {
        return n2;
    }
}

