/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.loaderdescriptors;

import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.BitConverter;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.exceptions.imageformats.GifImageException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.GifHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.IGifBlock;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.blocks.GifGraphicsControlBlock;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.loaderdescriptors.GifBlockLoaderDescriptor;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.utils.ms.lang.Operators;

public class GifGraphicsControlDescriptor
extends GifBlockLoaderDescriptor {
    @Override
    public boolean canLoad(StreamContainer streamContainer) {
        if (streamContainer == null) {
            throw new ArgumentNullException("streamContainer");
        }
        boolean bl2 = false;
        byte[] byArray = new byte[2];
        if (streamContainer.read(byArray) == byArray.length) {
            bl2 = Operators.castToInt32(byArray[0], 6) == 33 && Operators.castToInt32(byArray[1], 6) == 249;
        }
        return bl2;
    }

    @Override
    public IGifBlock load(StreamContainer streamContainer, IColorPalette iColorPalette) {
        byte[] byArray = GifHelper.loadBytes(streamContainer, 8);
        if (Operators.castToInt32(byArray[0], 6) != Operators.castToInt32((byte)33, 6)) {
            throw new GifImageException("Extension introducer is unexpected for graphics control block.");
        }
        if (Operators.castToInt32(byArray[1], 6) != Operators.castToInt32((byte)-7, 6)) {
            throw new GifImageException("Extension label is unexpected for graphics control block.");
        }
        if (Operators.castToInt32(byArray[2], 6) != Operators.castToInt32((byte)4, 6)) {
            throw new GifImageException("Extension block size is unexpected for graphics control block.");
        }
        if (Operators.castToInt32(byArray[7], 6) != 0) {
            throw new GifImageException("Extension block terminator value is unexpected for graphics control block.");
        }
        byte by2 = byArray[3];
        int n2 = BitConverter.toUInt16(byArray, 4);
        byte by3 = byArray[6];
        return new GifGraphicsControlBlock(by2, n2, by3);
    }
}

