/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.exif.makernoteparser;

import com.aspose.html.utils.collections.generic.List;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.IO.MemoryStream;
import com.aspose.html.utils.ms.System.Text.Encoding;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.exif.makernoteparser.IMakerNoteParser;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffDataType;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffBigEndianStream;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStream;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.loaders.TiffLoader;
import com.aspose.html.utils.ms.lang.StringSwitchMap;

class PentaxParser
implements IMakerNoteParser {
    private static final StringSwitchMap a = new StringSwitchMap("AOC\u0000", "PENT");

    PentaxParser() {
    }

    @Override
    public boolean parse(byte[] byArray, boolean bl2, List<TiffDataType>[] listArray) {
        try {
            String string = Encoding.getASCII().getString(byArray, 0, byArray.length);
            int n2 = 0;
            switch (a.of(string)) {
                case 0: {
                    n2 = 6;
                    break;
                }
                case 1: {
                    string = Encoding.getUTF8().getString(byArray, 0, 8);
                    if (!"PENTAX \u0000".equals(string)) break;
                    n2 = 10;
                    break;
                }
                default: {
                    return false;
                }
            }
            listArray[0].addRange(Array.toGenericList(bl2 ? TiffLoader.readDirectoryEntry(new TiffBigEndianStream(new MemoryStream(byArray, n2, byArray.length - n2))) : TiffLoader.readDirectoryEntry(new TiffStream(new MemoryStream(byArray, n2, byArray.length - n2)))));
            return true;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }
}

