/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.exif.makernoteparser;

import com.aspose.html.utils.collections.generic.List;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.IO.MemoryStream;
import com.aspose.html.utils.ms.System.Text.Encoding;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.exif.makernoteparser.IMakerNoteParser;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffDataType;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffBigEndianStream;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStream;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.loaders.TiffLoader;
import com.aspose.html.utils.ms.lang.Operators;

class NikonParser
implements IMakerNoteParser {
    NikonParser() {
    }

    @Override
    public boolean parse(byte[] byArray, boolean bl2, List<TiffDataType>[] listArray) {
        try {
            String string = Encoding.getASCII().getString(byArray, 0, byArray.length);
            int n2 = 0;
            if ("Nikon\u0000".equals(string)) {
                n2 = 8;
                if (Operators.castToInt32(byArray[12], 6) == 255 && Operators.castToInt32(byArray[13], 6) == 255) {
                    n2 = 18;
                }
            }
            listArray[0].addRange(Array.toGenericList(bl2 ? TiffLoader.readDirectoryEntry(new TiffBigEndianStream(new MemoryStream(byArray, n2, byArray.length - n2))) : TiffLoader.readDirectoryEntry(new TiffStream(new MemoryStream(byArray, n2, byArray.length - n2)))));
            return true;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }
}

