/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.DisposableObject;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.LanczosResampler;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.NearestNeighbourResampler;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ScaleCropper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialPixelLoader;

abstract class Resampler
extends DisposableObject
implements IPartialPixelLoader {
    private final double a;
    private final double b;
    private final double c;
    private final double d;
    private final int e;
    private final int f;
    private final int g;
    private final int h;
    private final IPartialPixelLoader i;

    protected Resampler(int n2, int n3, int n4, int n5, IPartialPixelLoader iPartialPixelLoader) {
        this.i = iPartialPixelLoader;
        this.g = n2;
        this.h = n3;
        this.e = n4;
        this.f = n5;
        this.c = (double)n4 / (double)n2;
        this.d = (double)n5 / (double)n3;
        this.a = 1.0 / this.c;
        this.b = 1.0 / this.d;
    }

    public double getInvertScaleX() {
        return this.a;
    }

    public double getInvertScaleY() {
        return this.b;
    }

    public IPartialPixelLoader getFinalProcessor() {
        return this.i;
    }

    public double getScaleX() {
        return this.c;
    }

    public double getScaleY() {
        return this.d;
    }

    public int getWidth() {
        return this.g;
    }

    public int getHeight() {
        return this.h;
    }

    public int getNewWidth() {
        return this.e;
    }

    public int getNewHeight() {
        return this.f;
    }

    public static Resampler getResampler(int n2, int n3, int n4, int n5, int n6, IPartialPixelLoader iPartialPixelLoader) {
        Resampler resampler;
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                resampler = new ScaleCropper(n2, n3, n4, n5, n6, iPartialPixelLoader);
                break;
            }
            case 6: {
                resampler = new LanczosResampler(n3, n4, n5, n6, iPartialPixelLoader);
                break;
            }
            case 7: {
                resampler = new NearestNeighbourResampler(n3, n4, n5, n6, iPartialPixelLoader);
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException("resizeType", "The resize type is not supported.");
            }
        }
        return resampler;
    }

    @Override
    public abstract void process(Rectangle var1, int[] var2, Point var3, Point var4);

    public Rectangle getProjectedRectangle(Rectangle rectangle) {
        int n2 = (int)((double)rectangle.getRight() * this.c + 0.5);
        int n3 = (int)((double)rectangle.getLeft() * this.c + 0.5);
        if ((int)(((double)n3 + 0.5) * this.a) < rectangle.getLeft()) {
            ++n3;
        }
        if (n3 > 0 && (int)(((double)n3 - 0.5) * this.a) == rectangle.getLeft()) {
            --n3;
        }
        if ((int)(((double)n2 - 0.5) * this.a) >= rectangle.getRight()) {
            --n2;
        }
        if (n2 < this.e && (int)(((double)n2 + 0.5) * this.a) < rectangle.getRight()) {
            ++n2;
        }
        int n4 = (int)((double)rectangle.getBottom() * this.d + 0.5);
        int n5 = (int)((double)rectangle.getTop() * this.d + 0.5);
        if ((int)(((double)n5 + 0.5) * this.b) < rectangle.getTop()) {
            ++n5;
        }
        if (n5 > 0 && (int)(((double)n5 - 0.5) * this.b) == rectangle.getTop()) {
            --n5;
        }
        if ((int)(((double)n4 - 0.5) * this.b) >= rectangle.getBottom()) {
            --n4;
        }
        if (n4 < this.f && (int)(((double)n4 + 0.5) * this.b) < rectangle.getBottom()) {
            ++n4;
        }
        Rectangle rectangle2 = new Rectangle(n3, n5, n2 - n3, n4 - n5);
        return rectangle2;
    }
}

