/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.utils.collections.generic.List;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.msMath;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ArrayHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ColorHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ColorPalette;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.RasterImage;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialPixelLoader;
import java.awt.Color;
import java.util.Comparator;

public class ColorPaletteHelper {
    public static IColorPalette createMonochrome() {
        int[] nArray = new int[]{ColorHelper.toArgb(Color.BLACK), ColorHelper.toArgb(Color.WHITE)};
        return new ColorPalette(nArray);
    }

    public static IColorPalette create4Bit() {
        int[] nArray = new int[]{ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 0, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 0, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 128, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 128, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 0, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 0, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 128, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 128, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 192, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 255, 0, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 255, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 255, 255, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 0, 255)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 255, 0, 255)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 255, 255)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 255, 255, 255))};
        return new ColorPalette(nArray);
    }

    public static IColorPalette create4BitGrayscale(boolean bl2) {
        int[] nArray = ArrayHelper.getColors(16);
        int n2 = 255;
        int n3 = -17;
        if (!bl2) {
            n2 = 0;
            n3 = 17;
        }
        for (int i2 = 0; i2 < 16; ++i2) {
            nArray[i2] = ColorHelper.toArgb(ColorHelper.fromArgb(n2, n2, n2));
            n2 += n3;
        }
        return new ColorPalette(nArray);
    }

    public static IColorPalette create8Bit() {
        int[] nArray = new int[]{ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 0, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 0, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 128, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 128, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 0, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 0, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 128, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 192, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 160, 160)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 240, 240, 240)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 32, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 32, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 32, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 32, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 32, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 32, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 64, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 64, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 64, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 64, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 64, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 64, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 64, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 64, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 96, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 96, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 96, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 96, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 96, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 96, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 96, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 96, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 128, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 128, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 128, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 128, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 128, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 128, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 128, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 128, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 160, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 160, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 160, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 160, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 160, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 160, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 160, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 160, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 192, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 192, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 192, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 192, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 192, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 192, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 192, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 192, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 224, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 224, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 224, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 224, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 224, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 224, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 224, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 224, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 0, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 0, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 0, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 0, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 0, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 0, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 0, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 0, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 32, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 32, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 32, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 32, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 32, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 32, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 32, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 32, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 64, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 64, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 64, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 64, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 64, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 64, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 64, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 64, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 96, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 96, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 96, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 96, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 96, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 96, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 96, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 96, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 128, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 128, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 128, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 128, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 128, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 128, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 128, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 128, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 160, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 160, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 160, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 160, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 160, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 160, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 160, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 160, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 192, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 192, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 192, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 192, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 192, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 192, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 192, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 192, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 224, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 224, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 224, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 224, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 224, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 224, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 224, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 224, 64)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 0, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 0, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 0, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 0, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 0, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 0, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 0, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 0, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 32, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 32, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 32, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 32, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 32, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 32, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 32, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 32, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 64, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 64, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 64, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 64, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 64, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 64, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 64, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 64, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 96, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 96, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 96, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 96, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 96, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 96, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 96, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 96, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 128, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 128, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 128, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 128, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 128, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 128, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 128, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 128, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 160, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 160, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 160, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 160, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 160, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 160, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 160, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 160, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 192, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 192, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 192, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 192, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 192, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 192, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 192, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 192, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 224, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 224, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 224, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 224, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 224, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 224, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 224, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 224, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 0, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 0, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 0, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 0, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 0, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 0, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 0, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 0, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 32, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 32, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 32, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 32, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 32, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 32, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 32, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 32, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 64, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 64, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 64, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 64, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 64, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 64, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 64, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 64, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 96, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 96, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 96, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 96, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 96, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 96, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 96, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 96, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 128, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 128, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 128, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 128, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 128, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 128, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 128, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 128, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 160, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 160, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 160, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 160, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 160, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 160, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 192, 160, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 224, 160, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 192, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 32, 192, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 64, 192, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 96, 192, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 192, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 192, 192)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 255, 251, 240)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 160, 160, 164)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 128, 128, 128)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 255, 0, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 255, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 255, 255, 0)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 0, 255)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 255, 0, 255)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 0, 255, 255)), ColorHelper.toArgb(ColorHelper.fromArgb(255, 255, 255, 255))};
        return new ColorPalette(nArray);
    }

    public static IColorPalette create8BitGrayscale(boolean bl2) {
        int[] nArray = ArrayHelper.getColors(256);
        if (bl2) {
            int n2 = 255;
            for (int i2 = 0; i2 < 256; ++i2) {
                nArray[i2] = ColorHelper.toArgb(ColorHelper.fromArgb(n2, n2, n2));
                --n2;
            }
        } else {
            for (int i3 = 0; i3 < 256; ++i3) {
                nArray[i3] = ColorHelper.toArgb(ColorHelper.fromArgb(i3, i3, i3));
            }
        }
        return new ColorPalette(nArray);
    }

    public static IColorPalette getCloseImagePalette(RasterImage rasterImage, int n2) {
        ColorPalette colorPalette;
        if (rasterImage == null) {
            throw new ArgumentNullException("image");
        }
        if (n2 <= 0) {
            throw new ArgumentOutOfRangeException("entriesCount", "The entries count should be a positive number.");
        }
        if (rasterImage.getPalette() != null) {
            int[] nArray = new int[n2];
            int n3 = msMath.min(n2, rasterImage.getPalette().getEntriesCount());
            Array.copy(Array.boxing(rasterImage.getPalette().getArgb32Entries()), Array.boxing(nArray), n3);
            colorPalette = new ColorPalette(nArray);
        } else {
            PaletteCorrector paletteCorrector = new PaletteCorrector();
            rasterImage.loadPartialPixels(rasterImage.getBounds().Clone(), paletteCorrector);
            colorPalette = new ColorPalette(paletteCorrector.getEntries(n2));
        }
        return colorPalette;
    }

    static class PaletteCorrector
    implements IPartialPixelLoader {
        private final List<Entry> a = new List();

        private PaletteCorrector() {
        }

        public int[] getEntries(int n2) {
            this.a.sort(new ColorSorterComparer());
            int[] nArray = new int[n2];
            int n3 = msMath.min(n2, this.a.size());
            for (int i2 = 0; i2 < n3; ++i2) {
                nArray[i2] = this.a.get_Item((int)i2)._Color;
            }
            return nArray;
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n2 = nArray[i2];
                Entry entry = new Entry();
                entry._Color = n2;
                entry.Count = 1;
                int n3 = this.a.binarySearch(entry, entry);
                if (n3 < 0) {
                    this.a.insertItem(~n3, entry);
                    continue;
                }
                ++this.a.get_Item((int)n3).Count;
            }
        }

        static class ColorSorterComparer
        implements Comparator<Entry> {
            private ColorSorterComparer() {
            }

            @Override
            public int compare(Entry entry, Entry entry2) {
                return entry2.Count - entry.Count;
            }
        }

        static class Entry
        implements Comparator<Entry> {
            public int _Color;
            public int Count;

            private Entry() {
            }

            @Override
            public int compare(Entry entry, Entry entry2) {
                return entry._Color - entry2._Color;
            }
        }
    }
}

