/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Xml;

import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.Encoding;
import com.aspose.html.utils.ms.System.Xml.Emitter;
import com.aspose.html.utils.ms.System.Xml.XmlWriter;

class XmlWriterEmitter
extends Emitter {
    private XmlWriter a;

    public XmlWriterEmitter(XmlWriter xmlWriter) {
        this.a = xmlWriter;
    }

    @Override
    public void writeStartDocument(Encoding encoding, int n2) {
        String string = "";
        switch (n2) {
            case 1: {
                string = " standalone=\"yes\"";
                break;
            }
            case 2: {
                string = " standalone=\"no\"";
            }
        }
        if (encoding == null) {
            this.a.writeProcessingInstruction("xml", StringExtensions.concat("version=\"1.0\"", string));
        } else {
            this.a.writeProcessingInstruction("xml", StringExtensions.concat("version=\"1.0\" encoding=\"", encoding.getWebName(), "\"", string));
        }
    }

    @Override
    public void writeEndDocument() {
    }

    @Override
    public void writeDocType(String string, String string2, String string3) {
        if (string3 == null) {
            return;
        }
        this.a.writeDocType(string, string2, string3, null);
    }

    @Override
    public void writeStartElement(String string, String string2, String string3) {
        this.a.writeStartElement(string, string2, string3);
    }

    @Override
    public void writeEndElement() {
        this.a.writeEndElement();
    }

    @Override
    public void writeFullEndElement() {
        this.a.writeFullEndElement();
    }

    @Override
    public void writeAttributeString(String string, String string2, String string3, String string4) {
        this.a.writeAttributeString(string, string2, string3, string4);
    }

    @Override
    public void writeComment(String string) {
        while (StringExtensions.indexOf(string, "--") >= 0) {
            string = StringExtensions.replace(string, "--", "- -");
        }
        if (StringExtensions.endsWith(string, "-")) {
            string = StringExtensions.plusEqOperator(string, ' ');
        }
        this.a.writeComment(string);
    }

    @Override
    public void writeProcessingInstruction(String string, String string2) {
        while (StringExtensions.indexOf(string2, "?>") >= 0) {
            string2 = StringExtensions.replace(string2, "?>", "? >");
        }
        this.a.writeProcessingInstruction(string, string2);
    }

    @Override
    public void writeString(String string) {
        this.a.writeString(string);
    }

    @Override
    public void writeRaw(String string) {
        this.a.writeRaw(string);
    }

    @Override
    public void writeCDataSection(String string) {
        int n2 = StringExtensions.indexOf(string, "]]>");
        if (n2 >= 0) {
            this.a.writeCData(StringExtensions.substring(string, 0, n2 + 2));
            this.writeCDataSection(StringExtensions.substring(string, n2 + 2));
        } else {
            this.a.writeCData(string);
        }
    }

    @Override
    public void writeWhitespace(String string) {
        this.a.writeWhitespace(string);
    }

    @Override
    public void done() {
        this.a.flush();
    }
}

