/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Int32Extensions;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.System.Uri;
import com.aspose.html.utils.ms.System.UriFormatException;
import java.net.URI;

public class UriBuilder {
    private String a;
    private String b;
    private int c;
    private String d;
    private String e;
    private String f;
    private String g;
    private String h;
    private Uri i;
    private boolean j;

    public UriBuilder() {
        this.a(Uri.UriSchemeHttp, "localhost", -1, StringExtensions.Empty, StringExtensions.Empty);
    }

    public UriBuilder(String string) {
        if (string == null) {
            throw new ArgumentNullException("uriString");
        }
        Uri uri = null;
        Uri[] uriArray = new Uri[]{uri};
        boolean bl2 = Uri.tryCreate(string, 1, uriArray);
        uri = uriArray[0];
        if (bl2) {
            this.a(uri);
        } else if (!StringExtensions.contains(string, Uri.SchemeDelimiter)) {
            this.a(new Uri(StringExtensions.concat(Uri.UriSchemeHttp, Uri.SchemeDelimiter, string)));
        } else {
            throw new UriFormatException();
        }
    }

    public UriBuilder(URI uRI) {
        this(Uri.fromJava(uRI));
    }

    UriBuilder(Uri uri) {
        this.a(uri);
    }

    public UriBuilder(String string, String string2) {
        this.a(string, string2, -1, StringExtensions.Empty, StringExtensions.Empty);
    }

    public UriBuilder(String string, String string2, int n2) {
        this.a(string, string2, n2, StringExtensions.Empty, StringExtensions.Empty);
    }

    public UriBuilder(String string, String string2, int n2, String string3) {
        this.a(string, string2, n2, string3, StringExtensions.Empty);
    }

    public UriBuilder(String string, String string2, int n2, String string3, String string4) {
        this.a(string, string2, n2, string3, string4);
    }

    private void a(Uri uri) {
        this.a(uri.getScheme(), uri.getHost(), uri.getPort(), uri.getAbsolutePath(), StringExtensions.Empty);
        this.f = uri.getFragment();
        this.e = uri.getQuery();
        this.g = uri.getUserInfo();
        int n2 = StringExtensions.indexOf(this.g, ':');
        if (n2 != -1) {
            this.h = StringExtensions.substring(this.g, n2 + 1);
            this.g = StringExtensions.substring(this.g, 0, n2);
        } else {
            this.h = StringExtensions.Empty;
        }
    }

    private void a(String string, String string2, int n2, String string3, String string4) {
        this.j = true;
        this.setScheme(string);
        this.setHost(string2);
        this.setPort(n2);
        this.setPath(string3);
        this.e = StringExtensions.Empty;
        this.f = StringExtensions.Empty;
        this.setPath(string3);
        this.g = StringExtensions.Empty;
        this.h = StringExtensions.Empty;
        if (StringExtensions.isNullOrEmpty(string4)) {
            return;
        }
        if (string4.charAt(0) == '#') {
            this.setFragment(StringExtensions.remove(string4, 0, 1));
        } else if (string4.charAt(0) == '?') {
            this.setQuery(StringExtensions.remove(string4, 0, 1));
        } else {
            throw new ArgumentException("extraValue");
        }
    }

    public String getFragment() {
        return this.f;
    }

    public void setFragment(String string) {
        this.f = string;
        if (this.f == null) {
            this.f = StringExtensions.Empty;
        } else if (this.f.length() > 0) {
            this.f = StringExtensions.concat("#", StringExtensions.replace(string, "%23", "#"));
        }
        this.j = true;
    }

    public String getHost() {
        return this.b;
    }

    public void setHost(String string) {
        this.b = StringExtensions.isNullOrEmpty(string) ? StringExtensions.Empty : (StringExtensions.indexOf(string, ':') != -1 && string.charAt(0) != '[' ? StringExtensions.concat("[", string, "]") : string);
        this.j = true;
    }

    public String getPassword() {
        return this.h;
    }

    public void setPassword(String string) {
        this.h = string == null ? StringExtensions.Empty : string;
    }

    public String getPath() {
        return this.d;
    }

    public void setPath(String string) {
        this.d = string == null || string.length() == 0 ? "/" : Uri.a(string.replace('\\', '/'), Uri.b);
        this.j = true;
    }

    public int getPort() {
        return this.c;
    }

    public void setPort(int n2) {
        if (n2 < -1) {
            throw new ArgumentOutOfRangeException("value");
        }
        this.c = n2;
        this.j = true;
    }

    public String getQuery() {
        return this.e;
    }

    public void setQuery(String string) {
        this.e = string == null || string.length() == 0 ? StringExtensions.Empty : StringExtensions.concat("?", string);
        this.j = true;
    }

    public String getScheme() {
        return this.a;
    }

    public void setScheme(String string) {
        int n2;
        if (string == null) {
            string = StringExtensions.Empty;
        }
        if ((n2 = StringExtensions.indexOf(string, ':')) != -1) {
            string = StringExtensions.substring(string, 0, n2);
        }
        this.a = StringExtensions.toLower(string);
        this.j = true;
    }

    public URI getUri() {
        return Uri.toJava(this.a());
    }

    Uri a() {
        if (!this.j) {
            return this.i;
        }
        this.i = new Uri(this.toString());
        this.b = this.i.getHost();
        this.d = this.i.getAbsolutePath();
        this.j = false;
        return this.i;
    }

    public String getUserName() {
        return this.g;
    }

    public void setUserName(String string) {
        this.g = string == null ? StringExtensions.Empty : string;
        this.j = true;
    }

    public boolean equals(Object object) {
        return object == null ? false : this.a().equals(object.toString());
    }

    public int hashCode() {
        return this.a().hashCode();
    }

    public String toString() {
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        msStringBuilder2.append(this.a);
        msStringBuilder2.append(Uri.c(this.a));
        if (!StringExtensions.equals(this.g, StringExtensions.Empty)) {
            msStringBuilder2.append(this.g);
            if (!StringExtensions.equals(this.h, StringExtensions.Empty)) {
                msStringBuilder2.append(StringExtensions.concat(":", this.h));
            }
            msStringBuilder2.append('@');
        }
        if (this.b.length() > 0) {
            msStringBuilder2.append(this.b);
            if (this.c > 0) {
                msStringBuilder2.append(StringExtensions.concat(":", Int32Extensions.toString(this.c)));
            }
        }
        if (!StringExtensions.equals(this.d, StringExtensions.Empty) && msStringBuilder2.get_Char(msStringBuilder2.getLength() - 1) != '/' && this.d.length() > 0 && this.d.charAt(0) != '/') {
            msStringBuilder2.append('/');
        }
        msStringBuilder2.append(this.d);
        msStringBuilder2.append(this.e);
        msStringBuilder2.append(this.f);
        return msStringBuilder2.toString();
    }
}

