/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.Convert;
import com.aspose.html.utils.ms.System.Globalization.NumberFormatInfo;
import com.aspose.html.utils.ms.System.IFormatProvider;
import com.aspose.html.utils.ms.core.System.l;
import com.aspose.html.utils.ms.core.System.n;

public final class SingleExtensions {
    public static final float MinValue = -3.4028235E38f;
    public static final float Epsilon = Float.MIN_VALUE;
    public static final float MaxValue = Float.MAX_VALUE;
    public static final float PositiveInfinity = Float.POSITIVE_INFINITY;
    public static final float NegativeInfinity = Float.NEGATIVE_INFINITY;
    public static final float NaN = Float.NaN;

    public static int compareTo(float f2, float f3) {
        if (SingleExtensions.isPositiveInfinity(f2) && SingleExtensions.isPositiveInfinity(f3)) {
            return 0;
        }
        if (SingleExtensions.isNegativeInfinity(f2) && SingleExtensions.isNegativeInfinity(f3)) {
            return 0;
        }
        if (SingleExtensions.isNaN(f3)) {
            if (SingleExtensions.isNaN(f2)) {
                return 0;
            }
            return 1;
        }
        if (SingleExtensions.isNaN(f2) && !SingleExtensions.isNaN(f3)) {
            return -1;
        }
        if (f2 > f3) {
            return 1;
        }
        if (f2 < f3) {
            return -1;
        }
        return 0;
    }

    public static int compareTo(float f2, Object object) {
        if (object == null) {
            return 1;
        }
        if (object.getClass() != Float.class) {
            throw new ArgumentException("Value is not a System.Single");
        }
        float f3 = Convert.toSingle(object);
        if (SingleExtensions.isPositiveInfinity(f2) && SingleExtensions.isPositiveInfinity(f3)) {
            return 0;
        }
        if (SingleExtensions.isNegativeInfinity(f2) && SingleExtensions.isNegativeInfinity(f3)) {
            return 0;
        }
        if (SingleExtensions.isNaN(f3)) {
            return SingleExtensions.isNaN(f2) ? 0 : 1;
        }
        if (SingleExtensions.isNaN(f2) && !SingleExtensions.isNaN(f3)) {
            return -1;
        }
        if (f2 > f3) {
            return 1;
        }
        if (f2 < f3) {
            return -1;
        }
        return 0;
    }

    public static boolean equals(float f2, float f3) {
        return f3 == f2 || SingleExtensions.isNaN(f3) && SingleExtensions.isNaN(f2);
    }

    public static boolean equals(float f2, Object object) {
        if (object.getClass() != Float.class) {
            return false;
        }
        float f3 = Convert.toSingle(object);
        return SingleExtensions.equals(f2, f3);
    }

    public static int getHashCode(float f2) {
        return new Float(f2).hashCode();
    }

    public static int getTypeCode() {
        return 13;
    }

    public static boolean isInfinity(float f2) {
        return f2 == Float.POSITIVE_INFINITY || f2 == Float.NEGATIVE_INFINITY;
    }

    public static boolean isNaN(float f2) {
        return Double.isNaN(f2);
    }

    public static boolean isNegativeInfinity(float f2) {
        return f2 == Float.NEGATIVE_INFINITY;
    }

    public static boolean isPositiveInfinity(float f2) {
        return f2 == Float.POSITIVE_INFINITY;
    }

    public static float parse(String string) {
        return n.a(string);
    }

    public static float parse(String string, int n2) {
        return n.a(string, n2);
    }

    public static float parse(String string, IFormatProvider iFormatProvider) {
        return n.a(string, iFormatProvider);
    }

    public static float parse(String string, int n2, IFormatProvider iFormatProvider) {
        return n.a(string, n2, iFormatProvider);
    }

    public static String toString(float f2) {
        return l.a("G", f2, (IFormatProvider)NumberFormatInfo.getCurrentInfo());
    }

    public static String toString(float f2, IFormatProvider iFormatProvider) {
        return l.a(null, f2, (IFormatProvider)NumberFormatInfo.getInstance(iFormatProvider));
    }

    public static String toString(float f2, String string) {
        return l.a(string, f2, (IFormatProvider)NumberFormatInfo.getCurrentInfo());
    }

    public static String toString(float f2, String string, IFormatProvider iFormatProvider) {
        return l.a(string, f2, (IFormatProvider)NumberFormatInfo.getInstance(iFormatProvider));
    }

    public static boolean tryParse(String string, int n2, IFormatProvider iFormatProvider, float[] fArray) {
        try {
            fArray[0] = SingleExtensions.parse(string, n2, iFormatProvider);
            return true;
        }
        catch (Exception exception) {
            fArray[0] = 0.0f;
            return false;
        }
    }

    public static boolean tryParse(String string, float[] fArray) {
        return SingleExtensions.tryParse(string, 231, NumberFormatInfo.getCurrentInfo(), fArray);
    }
}

