/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Security.Cryptography.Pkcs;

import com.aspose.html.NotImplementedException;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.NotSupportedException;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptographicAttributeObjectCollection;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.utils.ms.System.Security.Cryptography.Oid;
import com.aspose.html.utils.ms.System.Security.Cryptography.Pkcs.CmsSigner;
import com.aspose.html.utils.ms.System.Security.Cryptography.Pkcs.SignerInfoCollection;
import com.aspose.html.utils.ms.System.Security.Cryptography.Pkcs.SubjectIdentifier;
import com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates.X509Certificate2;
import com.aspose.html.utils.ms.core.bc.cms.CMSException;
import com.aspose.html.utils.ms.core.bc.cms.SignerInformation;
import com.aspose.html.utils.ms.core.bc.cms.SignerInformationVerifier;
import com.aspose.html.utils.ms.core.bc.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import com.aspose.html.utils.ms.core.bc.operator.OperatorCreationException;
import com.aspose.html.utils.ms.core.bc.security.a;
import java.security.cert.CertificateException;

public final class SignerInfo {
    private SubjectIdentifier a;
    private X509Certificate2 b;
    private Oid c;
    private SignerInfoCollection d;
    private CryptographicAttributeObjectCollection e;
    private CryptographicAttributeObjectCollection f;
    private int g;
    private SignerInformation h;

    SignerInfo(SubjectIdentifier subjectIdentifier, X509Certificate2 x509Certificate2, Oid oid, SignerInfoCollection signerInfoCollection, CryptographicAttributeObjectCollection cryptographicAttributeObjectCollection, CryptographicAttributeObjectCollection cryptographicAttributeObjectCollection2, int n2, SignerInformation signerInformation) {
        this.a = subjectIdentifier;
        this.b = x509Certificate2;
        this.c = oid;
        this.d = signerInfoCollection;
        this.e = cryptographicAttributeObjectCollection;
        this.f = cryptographicAttributeObjectCollection2;
        this.g = n2;
        this.h = signerInformation;
    }

    public CryptographicAttributeObjectCollection getSignedAttributes() {
        return this.e;
    }

    public X509Certificate2 getCertificate() {
        return this.b;
    }

    public SignerInfoCollection getCounterSignerInfos() {
        return this.d;
    }

    public Oid getDigestAlgorithm() {
        return this.c;
    }

    public SubjectIdentifier getSignerIdentifier() {
        return this.a;
    }

    public CryptographicAttributeObjectCollection getUnsignedAttributes() {
        return this.f;
    }

    public int getVersion() {
        return this.g;
    }

    public void checkHash() {
    }

    public void checkSignature(boolean bl2) {
        try {
            SignerInformationVerifier signerInformationVerifier = new JcaSimpleSignerInfoVerifierBuilder().build(com.aspose.html.utils.ms.core.bc.security.a.a(this.b));
            this.h.verify(signerInformationVerifier);
        }
        catch (CMSException cMSException) {
            throw new CryptographicException(cMSException.getMessage());
        }
        catch (CertificateException certificateException) {
            throw new CryptographicException(certificateException.getMessage());
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new CryptographicException(operatorCreationException.getMessage());
        }
    }

    public void computeCounterSignature() {
        throw new NotSupportedException("This requires that the current process is running in user interactive mode. Try to use ComputeCounterSignature(CmsSigner) method.");
    }

    public void computeCounterSignature(CmsSigner cmsSigner) {
        if (cmsSigner == null) {
            throw new ArgumentNullException("signer");
        }
        throw new NotImplementedException();
    }

    public void removeCounterSignature(SignerInfo signerInfo) {
        throw new NotImplementedException();
    }

    public void removeCounterSignature(int n2) {
        if (n2 < 0 || n2 >= this.d.size()) {
            throw new ArgumentException("index was out of range");
        }
        this.removeCounterSignature(this.d.get_Item(n2));
    }
}

