/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Net;

import com.aspose.html.utils.Stream;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.AsyncCallback;
import com.aspose.html.utils.ms.System.Buffer;
import com.aspose.html.utils.ms.System.IAsyncResult;
import com.aspose.html.utils.ms.System.Net.HttpStreamAsyncResult;
import com.aspose.html.utils.ms.System.NotSupportedException;
import com.aspose.html.utils.ms.System.ObjectDisposedException;
import com.aspose.html.utils.ms.System.msMath;
import com.aspose.html.utils.ms.lang.Operators;

class RequestStream
extends Stream {
    private byte[] a;
    private int b;
    private int c;
    private long d;
    private boolean e;
    private Stream f;

    RequestStream(Stream stream, byte[] byArray, int n2, int n3) {
        this(stream, byArray, n2, n3, -1L);
    }

    RequestStream(Stream stream, byte[] byArray, int n2, int n3, long l2) {
        this.f = stream;
        this.a = byArray;
        this.b = n2;
        this.c = n3;
        this.d = l2;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canSeek() {
        return false;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public long getLength() {
        throw new NotSupportedException();
    }

    @Override
    public long getPosition() {
        throw new NotSupportedException();
    }

    @Override
    public void setPosition(long l2) {
        throw new NotSupportedException();
    }

    @Override
    public void close() {
        this.e = true;
    }

    @Override
    public void flush() {
    }

    private int a(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new ArgumentNullException("buffer");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("offset", "< 0");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("count", "< 0");
        }
        int n4 = byArray.length;
        if (n2 > n4) {
            throw new ArgumentException("destination offset is beyond array size");
        }
        if (n2 > n4 - n3) {
            throw new ArgumentException("Reading would overrun buffer");
        }
        if (this.d == 0L) {
            return -1;
        }
        if (this.c == 0) {
            return 0;
        }
        int n5 = msMath.min(this.c, n3);
        if (this.d > 0L) {
            n5 = Operators.castToInt32(msMath.min((long)n5, this.d), 11);
        }
        if (this.b > this.a.length - n5) {
            n5 = msMath.min(n5, this.a.length - this.b);
        }
        if (n5 == 0) {
            return 0;
        }
        Buffer.blockCopy(Array.boxing(this.a), this.b, Array.boxing(byArray), n2, n5);
        this.b += n5;
        this.c -= n5;
        if (this.d > 0L) {
            this.d -= (long)n5;
        }
        return n5;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (this.e) {
            throw new ObjectDisposedException(Operators.typeOf(RequestStream.class).toString());
        }
        int n4 = this.a(byArray, n2, n3);
        if (n4 == -1) {
            return 0;
        }
        if (n4 > 0) {
            return n4;
        }
        n4 = this.f.read(byArray, n2, n3);
        if (n4 > 0 && this.d > 0L) {
            this.d -= (long)n4;
        }
        return n4;
    }

    @Override
    public IAsyncResult beginRead(byte[] byArray, int n2, int n3, AsyncCallback asyncCallback, Object object) {
        if (this.e) {
            throw new ObjectDisposedException(Operators.typeOf(RequestStream.class).toString());
        }
        int n4 = this.a(byArray, n2, n3);
        if (n4 > 0 || n4 == -1) {
            HttpStreamAsyncResult httpStreamAsyncResult = new HttpStreamAsyncResult();
            httpStreamAsyncResult.a = byArray;
            httpStreamAsyncResult.b = n2;
            httpStreamAsyncResult.c = n3;
            httpStreamAsyncResult.d = asyncCallback;
            httpStreamAsyncResult.e = object;
            httpStreamAsyncResult.f = msMath.max(0, n4);
            httpStreamAsyncResult.a();
            return httpStreamAsyncResult;
        }
        if (this.d >= 0L && (long)n3 > this.d) {
            n3 = Operators.castToInt32(msMath.min(Integer.MAX_VALUE, this.d), 11);
        }
        return this.f.beginRead(byArray, n2, n3, asyncCallback, object);
    }

    @Override
    public int endRead(IAsyncResult iAsyncResult) {
        if (this.e) {
            throw new ObjectDisposedException(Operators.typeOf(RequestStream.class).toString());
        }
        if (iAsyncResult == null) {
            throw new ArgumentNullException("async_result");
        }
        if (Operators.is(iAsyncResult, HttpStreamAsyncResult.class)) {
            HttpStreamAsyncResult httpStreamAsyncResult = (HttpStreamAsyncResult)iAsyncResult;
            if (!iAsyncResult.isCompleted()) {
                iAsyncResult.getAsyncWaitHandle().waitOne();
            }
            return httpStreamAsyncResult.f;
        }
        int n2 = this.f.endRead(iAsyncResult);
        if (this.d > 0L && n2 > 0) {
            this.d -= (long)n2;
        }
        return n2;
    }

    @Override
    public long seek(long l2, int n2) {
        throw new NotSupportedException();
    }

    @Override
    public void setLength(long l2) {
        throw new NotSupportedException();
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        throw new NotSupportedException();
    }

    @Override
    public IAsyncResult beginWrite(byte[] byArray, int n2, int n3, AsyncCallback asyncCallback, Object object) {
        throw new NotSupportedException();
    }

    @Override
    public void endWrite(IAsyncResult iAsyncResult) {
        throw new NotSupportedException();
    }
}

