/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.IO;

import com.aspose.html.utils.collections.generic.List;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Environment;
import com.aspose.html.utils.ms.System.IO.Directory;
import com.aspose.html.utils.ms.System.IO.DirectoryNotFoundException;
import com.aspose.html.utils.ms.System.IO.FileInfo;
import com.aspose.html.utils.ms.System.IO.FileSystemInfo;
import com.aspose.html.utils.ms.System.IO.IOException;
import com.aspose.html.utils.ms.System.IO.Path;
import com.aspose.html.utils.ms.System.StringExtensions;
import java.io.File;

public final class DirectoryInfo
extends FileSystemInfo {
    private String b;
    private String c;

    public DirectoryInfo(String string) {
        this(string, false);
    }

    DirectoryInfo(String string, boolean bl2) {
        this.checkPath(string);
        this.FullPath = Path.getFullPath(string);
        this.OriginalPath = bl2 ? Path.getFileName(string) : string;
        this.a();
    }

    private void a() {
        int n2;
        int n3 = this.FullPath.length() - 1;
        if (n3 > 1 && this.FullPath.charAt(n3) == Path.DirectorySeparatorChar) {
            --n3;
        }
        if ((n2 = StringExtensions.lastIndexOf(this.FullPath, Path.DirectorySeparatorChar, n3)) == -1 || n2 == 0 && n3 == 0) {
            this.b = this.FullPath;
            this.c = null;
        } else {
            this.b = StringExtensions.substring(this.FullPath, n2 + 1, n3 - n2);
            this.c = n2 == 0 && !Environment.IsRunningOnWindows ? StringExtensions.newString(Character.valueOf(Path.DirectorySeparatorChar)) : StringExtensions.substring(this.FullPath, 0, n2);
            if (Environment.IsRunningOnWindows && this.c.length() == 2 && this.c.charAt(1) == ':' && Character.isLetter(this.c.charAt(0))) {
                this.c = StringExtensions.plusEqOperator(this.c, Path.DirectorySeparatorChar);
            }
        }
    }

    @Override
    public boolean exists() {
        return new File(this.FullPath).exists();
    }

    @Override
    public String getName() {
        return this.b;
    }

    public DirectoryInfo getParent() {
        if (this.c == null || this.c.length() == 0) {
            return null;
        }
        return new DirectoryInfo(this.c);
    }

    public DirectoryInfo getRoot() {
        String string = Path.getPathRoot(this.FullPath);
        if (string == null) {
            return null;
        }
        return new DirectoryInfo(string);
    }

    public void create() {
        Directory.createDirectory(this.FullPath);
    }

    public DirectoryInfo createSubdirectory(String string) {
        this.checkPath(string);
        string = Path.combine(this.FullPath, string);
        Directory.createDirectory(string);
        return new DirectoryInfo(string);
    }

    public FileInfo[] getFiles() {
        return this.getFiles("*");
    }

    public FileInfo[] getFiles(String string) {
        if (string == null) {
            throw new ArgumentNullException("searchPattern");
        }
        if (!this.exists()) {
            throw new DirectoryNotFoundException(this.FullPath);
        }
        String[] stringArray = Directory.getFiles(this.FullPath, string);
        FileInfo[] fileInfoArray = new FileInfo[stringArray.length];
        int n2 = 0;
        for (String string2 : stringArray) {
            fileInfoArray[n2++] = new FileInfo(string2);
        }
        return fileInfoArray;
    }

    public DirectoryInfo[] getDirectories() {
        return this.getDirectories("*");
    }

    public DirectoryInfo[] getDirectories(String string) {
        if (string == null) {
            throw new ArgumentNullException("searchPattern");
        }
        if (!this.exists()) {
            throw new DirectoryNotFoundException(this.FullPath);
        }
        String[] stringArray = Directory.getDirectories(this.FullPath, string);
        DirectoryInfo[] directoryInfoArray = new DirectoryInfo[stringArray.length];
        int n2 = 0;
        for (String string2 : stringArray) {
            directoryInfoArray[n2++] = new DirectoryInfo(string2);
        }
        return directoryInfoArray;
    }

    public FileSystemInfo[] getFileSystemInfos() {
        return this.getFileSystemInfos("*");
    }

    public FileSystemInfo[] getFileSystemInfos(String string) {
        return this.a(string, 0);
    }

    private FileSystemInfo[] a(String string, int n2) {
        if (string == null) {
            throw new ArgumentNullException("searchPattern");
        }
        if (n2 != 0 && n2 != 1) {
            throw new ArgumentOutOfRangeException("searchOption", "Must be TopDirectoryOnly or AllDirectories");
        }
        if (!Directory.exists(this.FullPath)) {
            throw new IOException("Invalid directory");
        }
        List<FileSystemInfo> list = new List<FileSystemInfo>();
        this.a(string, n2, list);
        return list.toArray((FileSystemInfo[])new FileSystemInfo[0]);
    }

    private void a(String string, int n2, List<FileSystemInfo> list) {
        String[] stringArray = Directory.getDirectories(this.FullPath, string);
        String[] stringArray2 = Directory.getFiles(this.FullPath, string);
        for (String string2 : stringArray) {
            list.addItem(new DirectoryInfo(string2));
        }
        for (String string2 : stringArray2) {
            list.addItem(new FileInfo(string2));
        }
        if (n2 == 1) {
            for (String string2 : stringArray) {
                DirectoryInfo directoryInfo = new DirectoryInfo(string2);
                directoryInfo.a(string, n2, list);
            }
        }
    }

    @Override
    public void delete() {
        this.delete(false);
    }

    public void delete(boolean bl2) {
        Directory.delete(this.FullPath, bl2);
    }

    public void moveTo(String string) {
        if (string == null) {
            throw new ArgumentNullException("destDirName");
        }
        if (StringExtensions.trim(string).length() == 0) {
            throw new ArgumentException("An empty file name is not valid.");
        }
        Directory.move(this.FullPath, Path.getFullPath(string));
    }

    public String toString() {
        return this.OriginalPath;
    }

    public DirectoryInfo[] getDirectories(String string, int n2) {
        switch (n2) {
            case 0: {
                return this.getDirectories(string);
            }
            case 1: {
                String[] stringArray = Directory.getDirectories(this.FullPath, string, 1);
                DirectoryInfo[] directoryInfoArray = new DirectoryInfo[stringArray.length];
                int n3 = 0;
                for (String string2 : stringArray) {
                    directoryInfoArray[n3++] = new DirectoryInfo(string2);
                }
                return directoryInfoArray;
            }
        }
        String string3 = StringExtensions.format("Invalid enum value '{0}' for '{1}'.", n2, "SearchOption");
        throw new ArgumentOutOfRangeException("searchOption", string3);
    }

    public FileInfo[] getFiles(String string, int n2) {
        switch (n2) {
            case 0: {
                return this.getFiles(string);
            }
            case 1: {
                String[] stringArray = Directory.getFiles(this.FullPath, string, 1);
                FileInfo[] fileInfoArray = new FileInfo[stringArray.length];
                int n3 = 0;
                for (String string2 : stringArray) {
                    fileInfoArray[n3++] = new FileInfo(string2);
                }
                return fileInfoArray;
            }
        }
        String string3 = StringExtensions.format("Invalid enum value '{0}' for '{1}'.", n2, "SearchOption");
        throw new ArgumentOutOfRangeException("searchOption", string3);
    }
}

